/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur.dependencies;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.modrinth.minotaur.dependencies.DependencyType;
import com.modrinth.minotaur.dependencies.ModDependency;
import com.modrinth.minotaur.dependencies.VersionDependency;
import java.util.Locale;
import java.util.Objects;
import masecla.modrinth4j.main.ModrinthAPI;
import masecla.modrinth4j.model.version.ProjectVersion;
import org.gradle.api.GradleException;
import org.jetbrains.annotations.ApiStatus;

public class Dependency {
    @Expose
    @SerializedName(value="dependency_type")
    private final ProjectVersion.ProjectDependencyType dependencyType;

    @ApiStatus.Internal
    Dependency(DependencyType type) {
        this.dependencyType = type.toNew();
    }

    @ApiStatus.Internal
    Dependency(String type) {
        this.dependencyType = ProjectVersion.ProjectDependencyType.valueOf((String)type.toUpperCase(Locale.ROOT));
    }

    ProjectVersion.ProjectDependencyType getDependencyType() {
        return this.dependencyType;
    }

    public ProjectVersion.ProjectDependency toNew(ModrinthAPI api) {
        if (this instanceof ModDependency) {
            ModDependency dep = (ModDependency)this;
            String id = Objects.requireNonNull((String)api.projects().getProjectIdBySlug(dep.getProjectId()).join(), "Failed to resolve dependency project ID: " + dep.getProjectId());
            return new ProjectVersion.ProjectDependency(null, id, null, dep.getDependencyType());
        }
        if (this instanceof VersionDependency) {
            ProjectVersion version;
            VersionDependency dep = (VersionDependency)this;
            try {
                version = dep.getProjectId() == null ? (ProjectVersion)api.versions().getVersion(dep.getVersionId()).join() : (ProjectVersion)api.versions().getVersionByNumber(dep.getProjectId(), dep.getVersionId()).join();
            }
            catch (Exception e) {
                throw new GradleException("Failed to resolve version \"" + dep.getVersionId() + "\"!", (Throwable)e);
            }
            return new ProjectVersion.ProjectDependency(version.getId(), version.getProjectId(), null, dep.getDependencyType());
        }
        throw new GradleException("Dependency was not an instance of ModDependency or VersionDependency!");
    }

    public static Dependency fromNew(ProjectVersion.ProjectDependency newDep) {
        if (newDep.getVersionId() != null) {
            return new VersionDependency(newDep.getProjectId(), newDep.getVersionId(), newDep.getDependencyType().name());
        }
        return new ModDependency(newDep.getProjectId(), newDep.getDependencyType().name());
    }
}

