/*
 * Decompiled with CFR 0.152.
 */
package com.modrinth.minotaur;

import com.modrinth.minotaur.Util;
import com.modrinth.minotaur.dependencies.Dependency;
import com.modrinth.minotaur.dependencies.container.DependencyDSL;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public class ModrinthExtension
extends DependencyDSL {
    private final Property<String> apiUrl;
    private final Property<String> token;
    private final Property<String> projectId;
    private final Property<String> versionNumber;
    private final Property<String> versionName;
    private final Property<String> changelog;
    private final Property<String> versionType;
    private final Property<String> syncBodyFrom;
    private final Property<Object> legacyUploadFile;
    private final RegularFileProperty file;
    private final ListProperty<Object> additionalFiles;
    public final ListProperty<String> gameVersions;
    public final ListProperty<String> loaders;
    private final ListProperty<Dependency> dependencies;
    private final Property<Boolean> failSilently;
    private final Property<Boolean> detectLoaders;
    private final Property<Boolean> debugMode;
    private final Property<Boolean> autoAddDependsOn;
    public static final String DEFAULT_API_URL = "https://api.modrinth.com/v2";
    public static final String STAGING_API_URL = "https://staging-api.modrinth.com/v2";
    public static final String DEFAULT_TOKEN = System.getenv("MODRINTH_TOKEN");
    public static final String DEFAULT_CHANGELOG = "No changelog was specified.";
    public static final String DEFAULT_VERSION_TYPE = "release";

    public ModrinthExtension(Project project) {
        super(project.getObjects());
        this.apiUrl = project.getObjects().property(String.class).convention((Object)DEFAULT_API_URL);
        this.token = project.getObjects().property(String.class).convention((Object)DEFAULT_TOKEN);
        this.projectId = project.getObjects().property(String.class);
        this.versionNumber = project.getObjects().property(String.class);
        this.versionName = project.getObjects().property(String.class);
        this.changelog = project.getObjects().property(String.class).convention((Object)DEFAULT_CHANGELOG);
        this.legacyUploadFile = project.getObjects().property(Object.class);
        this.file = project.getObjects().fileProperty().convention(this.legacyUploadFile.flatMap(o -> Util.resolveFileProperty(project, o)));
        this.additionalFiles = project.getObjects().listProperty(Object.class).empty();
        this.versionType = project.getObjects().property(String.class).convention((Object)DEFAULT_VERSION_TYPE);
        this.gameVersions = project.getObjects().listProperty(String.class).empty();
        this.loaders = project.getObjects().listProperty(String.class).empty();
        this.dependencies = project.getObjects().listProperty(Dependency.class).empty();
        this.failSilently = project.getObjects().property(Boolean.class).convention((Object)false);
        this.detectLoaders = project.getObjects().property(Boolean.class).convention((Object)true);
        this.debugMode = project.getObjects().property(Boolean.class).convention((Object)false);
        this.syncBodyFrom = project.getObjects().property(String.class);
        this.autoAddDependsOn = project.getObjects().property(Boolean.class).convention((Object)true);
    }

    public Property<String> getApiUrl() {
        return this.apiUrl;
    }

    public Property<String> getToken() {
        return this.token;
    }

    public Property<String> getProjectId() {
        return this.projectId;
    }

    public Property<String> getVersionNumber() {
        return this.versionNumber;
    }

    public Property<String> getVersionName() {
        return this.versionName;
    }

    public Property<String> getChangelog() {
        return this.changelog;
    }

    public Property<Object> getUploadFile() {
        return this.legacyUploadFile;
    }

    public RegularFileProperty getFile() {
        return this.file;
    }

    public ListProperty<Object> getAdditionalFiles() {
        return this.additionalFiles;
    }

    public Property<String> getVersionType() {
        return this.versionType;
    }

    public ListProperty<String> getGameVersions() {
        return this.gameVersions;
    }

    public ListProperty<String> getLoaders() {
        return this.loaders;
    }

    public ListProperty<Dependency> getDependencies() {
        return this.dependencies;
    }

    public Property<Boolean> getFailSilently() {
        return this.failSilently;
    }

    public Property<Boolean> getDetectLoaders() {
        return this.detectLoaders;
    }

    public Property<Boolean> getDebugMode() {
        return this.debugMode;
    }

    public Property<String> getSyncBodyFrom() {
        return this.syncBodyFrom;
    }

    public Property<Boolean> getAutoAddDependsOn() {
        return this.autoAddDependsOn;
    }
}

