/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import android.view.View;
import android.widget.CheckBox;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Spinner;
import com.mobsandgeeks.saripaar.AnnotationRule;
import com.mobsandgeeks.saripaar.DefaultViewValidatedAction;
import com.mobsandgeeks.saripaar.QuickRule;
import com.mobsandgeeks.saripaar.Reflector;
import com.mobsandgeeks.saripaar.Registry;
import com.mobsandgeeks.saripaar.Rule;
import com.mobsandgeeks.saripaar.SaripaarFieldsComparator;
import com.mobsandgeeks.saripaar.SequenceComparator;
import com.mobsandgeeks.saripaar.ValidationContext;
import com.mobsandgeeks.saripaar.ValidationError;
import com.mobsandgeeks.saripaar.adapter.CheckBoxBooleanAdapter;
import com.mobsandgeeks.saripaar.adapter.RadioButtonBooleanAdapter;
import com.mobsandgeeks.saripaar.adapter.RadioGroupBooleanAdapter;
import com.mobsandgeeks.saripaar.adapter.SpinnerIndexAdapter;
import com.mobsandgeeks.saripaar.adapter.ViewDataAdapter;
import com.mobsandgeeks.saripaar.annotation.AssertFalse;
import com.mobsandgeeks.saripaar.annotation.AssertTrue;
import com.mobsandgeeks.saripaar.annotation.Checked;
import com.mobsandgeeks.saripaar.annotation.ConfirmEmail;
import com.mobsandgeeks.saripaar.annotation.ConfirmPassword;
import com.mobsandgeeks.saripaar.annotation.CreditCard;
import com.mobsandgeeks.saripaar.annotation.DecimalMax;
import com.mobsandgeeks.saripaar.annotation.DecimalMin;
import com.mobsandgeeks.saripaar.annotation.Digits;
import com.mobsandgeeks.saripaar.annotation.Domain;
import com.mobsandgeeks.saripaar.annotation.Email;
import com.mobsandgeeks.saripaar.annotation.Future;
import com.mobsandgeeks.saripaar.annotation.IpAddress;
import com.mobsandgeeks.saripaar.annotation.Isbn;
import com.mobsandgeeks.saripaar.annotation.Length;
import com.mobsandgeeks.saripaar.annotation.Max;
import com.mobsandgeeks.saripaar.annotation.Min;
import com.mobsandgeeks.saripaar.annotation.NotEmpty;
import com.mobsandgeeks.saripaar.annotation.Order;
import com.mobsandgeeks.saripaar.annotation.Password;
import com.mobsandgeeks.saripaar.annotation.Past;
import com.mobsandgeeks.saripaar.annotation.Pattern;
import com.mobsandgeeks.saripaar.annotation.Select;
import com.mobsandgeeks.saripaar.annotation.Url;
import com.mobsandgeeks.saripaar.annotation.ValidateUsing;
import com.mobsandgeeks.saripaar.exception.ConversionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Validator {
    private static final Registry SARIPAAR_REGISTRY = new Registry();
    private final Map<Class<? extends View>, HashMap<Class<?>, ViewDataAdapter>> mRegisteredAdaptersMap = new HashMap();
    private Object mController;
    private Mode mValidationMode;
    private ValidationContext mValidationContext;
    private Map<View, ArrayList<Pair<Rule, ViewDataAdapter>>> mViewRulesMap;
    private boolean mOrderedFields;
    private SequenceComparator mSequenceComparator;
    private ViewValidatedAction mViewValidatedAction;
    private Handler mViewValidatedActionHandler;
    private ValidationListener mValidationListener;
    private AsyncValidationTask mAsyncValidationTask;

    public Validator(Object controller) {
        Validator.assertNotNull(controller, "controller");
        this.mController = controller;
        this.mValidationMode = Mode.BURST;
        this.mSequenceComparator = new SequenceComparator();
        this.mViewValidatedAction = new DefaultViewValidatedAction();
    }

    public static void registerAnnotation(Class<? extends Annotation> ruleAnnotation) {
        SARIPAAR_REGISTRY.register(ruleAnnotation);
    }

    public static <VIEW extends View> void registerAnnotation(Class<? extends Annotation> annotation, Class<VIEW> viewType, ViewDataAdapter<VIEW, ?> viewDataAdapter) {
        ValidateUsing validateUsing = annotation.getAnnotation(ValidateUsing.class);
        Class<?> ruleDataType = Reflector.getRuleDataType(validateUsing);
        SARIPAAR_REGISTRY.register(viewType, ruleDataType, viewDataAdapter, annotation);
    }

    public <VIEW extends View, DATA_TYPE> void registerAdapter(Class<VIEW> viewType, ViewDataAdapter<VIEW, DATA_TYPE> viewDataAdapter) {
        Validator.assertNotNull(viewType, "viewType");
        Validator.assertNotNull(viewDataAdapter, "viewDataAdapter");
        HashMap dataTypeAdapterMap = this.mRegisteredAdaptersMap.get(viewType);
        if (dataTypeAdapterMap == null) {
            dataTypeAdapterMap = new HashMap();
            this.mRegisteredAdaptersMap.put(viewType, dataTypeAdapterMap);
        }
        Method getDataMethod = Reflector.findGetDataMethod(viewDataAdapter.getClass());
        Class<?> adapterDataType = getDataMethod.getReturnType();
        dataTypeAdapterMap.put(adapterDataType, viewDataAdapter);
    }

    public void setValidationListener(ValidationListener validationListener) {
        Validator.assertNotNull(validationListener, "validationListener");
        this.mValidationListener = validationListener;
    }

    public void setViewValidatedAction(ViewValidatedAction viewValidatedAction) {
        this.mViewValidatedAction = viewValidatedAction;
    }

    public void setValidationMode(Mode validationMode) {
        Validator.assertNotNull((Object)validationMode, "validationMode");
        this.mValidationMode = validationMode;
    }

    public Mode getValidationMode() {
        return this.mValidationMode;
    }

    public void validate() {
        this.validate(false);
    }

    public void validateBefore(View view) {
        this.validateBefore(view, false);
    }

    public void validateTill(View view) {
        this.validateTill(view, false);
    }

    public void validate(boolean async) {
        this.createRulesSafelyAndLazily(false);
        View lastView = this.getLastView();
        if (Mode.BURST.equals((Object)this.mValidationMode)) {
            this.validateUnorderedFieldsWithCallbackTill(lastView, async);
        } else if (Mode.IMMEDIATE.equals((Object)this.mValidationMode)) {
            String reasonSuffix = String.format("in %s mode.", Mode.IMMEDIATE.toString());
            this.validateOrderedFieldsWithCallbackTill(lastView, reasonSuffix, async);
        } else {
            throw new RuntimeException("This should never happen!");
        }
    }

    public void validateBefore(View view, boolean async) {
        this.createRulesSafelyAndLazily(false);
        View previousView = this.getViewBefore(view);
        this.validateOrderedFieldsWithCallbackTill(previousView, "when using 'validateBefore(View)'.", async);
    }

    public void validateTill(View view, boolean async) {
        this.validateOrderedFieldsWithCallbackTill(view, "when using 'validateTill(View)'.", async);
    }

    public boolean isValidating() {
        return this.mAsyncValidationTask != null && this.mAsyncValidationTask.getStatus() != AsyncTask.Status.FINISHED;
    }

    public boolean cancelAsync() {
        boolean cancelled = false;
        if (this.mAsyncValidationTask != null) {
            cancelled = this.mAsyncValidationTask.cancel(true);
            this.mAsyncValidationTask = null;
        }
        return cancelled;
    }

    public <VIEW extends View> void put(VIEW view, QuickRule<VIEW> ... quickRules) {
        Validator.assertNotNull(view, "view");
        Validator.assertNotNull(quickRules, "quickRules");
        if (quickRules.length == 0) {
            throw new IllegalArgumentException("'quickRules' cannot be empty.");
        }
        this.createRulesSafelyAndLazily(true);
        if (this.mOrderedFields && !this.mViewRulesMap.containsKey(view)) {
            String message = String.format("All fields are ordered, so this `%s` should be ordered too, declare the view as a field and add the `@Order` annotation.", view.getClass().getName());
            throw new IllegalStateException(message);
        }
        ArrayList<Pair> ruleAdapterPairs = this.mViewRulesMap.get(view);
        ruleAdapterPairs = ruleAdapterPairs == null ? new ArrayList<Pair>() : ruleAdapterPairs;
        for (QuickRule<VIEW> quickRule : quickRules) {
            if (quickRule == null) continue;
            ruleAdapterPairs.add(new Pair(quickRule, null));
        }
        Collections.sort(ruleAdapterPairs, this.mSequenceComparator);
        this.mViewRulesMap.put(view, ruleAdapterPairs);
    }

    public void removeRules(View view) {
        Validator.assertNotNull(view, "view");
        if (this.mViewRulesMap == null) {
            this.createRulesSafelyAndLazily(false);
        }
        this.mViewRulesMap.remove(view);
    }

    static boolean isSaripaarAnnotation(Class<? extends Annotation> annotation) {
        return SARIPAAR_REGISTRY.getRegisteredAnnotations().contains(annotation);
    }

    private static void assertNotNull(Object object, String argumentName) {
        if (object == null) {
            String message = String.format("'%s' cannot be null.", argumentName);
            throw new IllegalArgumentException(message);
        }
    }

    private void createRulesSafelyAndLazily(boolean addingQuickRules) {
        if (this.mViewRulesMap == null) {
            List<Field> annotatedFields = this.getSaripaarAnnotatedFields(this.mController.getClass());
            this.mViewRulesMap = this.createRules(annotatedFields);
            this.mValidationContext.setViewRulesMap(this.mViewRulesMap);
        }
        if (!addingQuickRules && this.mViewRulesMap.size() == 0) {
            String message = "No rules found. You must have at least one rule to validate. If you are using custom annotations, make sure that you have registered them using the 'Validator.register()' method.";
            throw new IllegalStateException(message);
        }
    }

    private List<Field> getSaripaarAnnotatedFields(Class<?> controllerClass) {
        Set<Class<? extends Annotation>> saripaarAnnotations = SARIPAAR_REGISTRY.getRegisteredAnnotations();
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        List<Field> controllerViewFields = this.getControllerViewFields(controllerClass);
        for (Field field : controllerViewFields) {
            if (!this.isSaripaarAnnotatedField(field, saripaarAnnotations)) continue;
            annotatedFields.add(field);
        }
        SaripaarFieldsComparator comparator = new SaripaarFieldsComparator();
        Collections.sort(annotatedFields, comparator);
        this.mOrderedFields = annotatedFields.size() == 1 ? ((Field)annotatedFields.get(0)).getAnnotation(Order.class) != null : annotatedFields.size() != 0 && comparator.areOrderedFields();
        return annotatedFields;
    }

    private List<Field> getControllerViewFields(Class<?> controllerClass) {
        ArrayList<Field> controllerViewFields = new ArrayList<Field>();
        controllerViewFields.addAll(this.getViewFields(controllerClass));
        Class<?> superClass = controllerClass.getSuperclass();
        while (!superClass.equals(Object.class)) {
            List<Field> viewFields = this.getViewFields(superClass);
            if (viewFields.size() > 0) {
                controllerViewFields.addAll(viewFields);
            }
            superClass = superClass.getSuperclass();
        }
        return controllerViewFields;
    }

    private List<Field> getViewFields(Class<?> clazz) {
        Field[] declaredFields;
        ArrayList<Field> viewFields = new ArrayList<Field>();
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (!View.class.isAssignableFrom(field.getType())) continue;
            viewFields.add(field);
        }
        return viewFields;
    }

    private boolean isSaripaarAnnotatedField(Field field, Set<Class<? extends Annotation>> registeredAnnotations) {
        boolean hasOrderAnnotation = field.getAnnotation(Order.class) != null;
        boolean hasSaripaarAnnotation = false;
        if (!hasOrderAnnotation) {
            Annotation annotation;
            Annotation[] annotations;
            Annotation[] annotationArray = annotations = field.getAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n && !(hasSaripaarAnnotation = registeredAnnotations.contains((annotation = annotationArray[i]).annotationType())); ++i) {
            }
        }
        return hasOrderAnnotation || hasSaripaarAnnotation;
    }

    private Map<View, ArrayList<Pair<Rule, ViewDataAdapter>>> createRules(List<Field> annotatedFields) {
        LinkedHashMap<View, ArrayList<Pair<Rule, ViewDataAdapter>>> viewRulesMap = new LinkedHashMap<View, ArrayList<Pair<Rule, ViewDataAdapter>>>();
        for (Field field : annotatedFields) {
            Annotation[] fieldAnnotations;
            ArrayList<Pair<Rule, ViewDataAdapter>> ruleAdapterPairs = new ArrayList<Pair<Rule, ViewDataAdapter>>();
            for (Annotation fieldAnnotation : fieldAnnotations = field.getAnnotations()) {
                if (!Validator.isSaripaarAnnotation(fieldAnnotation.annotationType())) continue;
                Pair<Rule, ViewDataAdapter> ruleAdapterPair = this.getRuleAdapterPair(fieldAnnotation, field);
                ruleAdapterPairs.add(ruleAdapterPair);
            }
            Collections.sort(ruleAdapterPairs, this.mSequenceComparator);
            viewRulesMap.put(this.getView(field), ruleAdapterPairs);
        }
        return viewRulesMap;
    }

    private Pair<Rule, ViewDataAdapter> getRuleAdapterPair(Annotation saripaarAnnotation, Field viewField) {
        Class<?> ruleDataType;
        Class<?> viewFieldType;
        Class<? extends Annotation> annotationType = saripaarAnnotation.annotationType();
        ViewDataAdapter dataAdapter = this.getDataAdapter(annotationType, viewFieldType = viewField.getType(), ruleDataType = Reflector.getRuleDataType(saripaarAnnotation));
        if (dataAdapter == null) {
            String viewType = viewFieldType.getName();
            String message = String.format("To use '%s' on '%s', register a '%s' that returns a '%s' from the '%s'.", annotationType.getName(), viewType, ViewDataAdapter.class.getName(), ruleDataType.getName(), viewType);
            throw new UnsupportedOperationException(message);
        }
        if (this.mValidationContext == null) {
            this.mValidationContext = new ValidationContext(this.getContext(viewField));
        }
        Class<? extends AnnotationRule> ruleType = this.getRuleType(saripaarAnnotation);
        AnnotationRule rule = Reflector.instantiateRule(ruleType, saripaarAnnotation, this.mValidationContext);
        return new Pair((Object)rule, (Object)dataAdapter);
    }

    private ViewDataAdapter getDataAdapter(Class<? extends Annotation> annotationType, Class<?> viewFieldType, Class<?> adapterDataType) {
        ViewDataAdapter<?, ?> dataAdapter = SARIPAAR_REGISTRY.getDataAdapter(annotationType, viewFieldType);
        if (dataAdapter == null) {
            HashMap<Class<?>, ViewDataAdapter> dataTypeAdapterMap = this.mRegisteredAdaptersMap.get(viewFieldType);
            dataAdapter = dataTypeAdapterMap != null ? dataTypeAdapterMap.get(adapterDataType) : null;
        }
        return dataAdapter;
    }

    private Context getContext(Field viewField) {
        Context context = null;
        try {
            if (!viewField.isAccessible()) {
                viewField.setAccessible(true);
            }
            View view = (View)viewField.get(this.mController);
            context = view.getContext();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return context;
    }

    private Class<? extends AnnotationRule> getRuleType(Annotation ruleAnnotation) {
        ValidateUsing validateUsing = ruleAnnotation.annotationType().getAnnotation(ValidateUsing.class);
        return validateUsing != null ? validateUsing.value() : null;
    }

    private View getView(Field field) {
        View view = null;
        try {
            field.setAccessible(true);
            view = (View)field.get(this.mController);
            if (view == null) {
                String message = String.format("'%s %s' is null.", field.getType().getSimpleName(), field.getName());
                throw new IllegalStateException(message);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return view;
    }

    private void validateUnorderedFieldsWithCallbackTill(View view, boolean async) {
        this.validateFieldsWithCallbackTill(view, false, null, async);
    }

    private void validateOrderedFieldsWithCallbackTill(View view, String reasonSuffix, boolean async) {
        this.validateFieldsWithCallbackTill(view, true, reasonSuffix, async);
    }

    private void validateFieldsWithCallbackTill(View view, boolean orderedFields, String reasonSuffix, boolean async) {
        this.createRulesSafelyAndLazily(false);
        if (async) {
            if (this.mAsyncValidationTask != null) {
                this.mAsyncValidationTask.cancel(true);
            }
            this.mAsyncValidationTask = new AsyncValidationTask(view, orderedFields, reasonSuffix);
            this.mAsyncValidationTask.execute(null);
        } else {
            this.triggerValidationListenerCallback(this.validateTill(view, orderedFields, reasonSuffix));
        }
    }

    private synchronized ValidationReport validateTill(View view, boolean requiresOrderedRules, String reasonSuffix) {
        if (requiresOrderedRules) {
            this.assertOrderedFields(this.mOrderedFields, reasonSuffix);
        }
        Validator.assertNotNull(this.mValidationListener, "validationListener");
        return this.getValidationReport(view, this.mViewRulesMap, this.mValidationMode);
    }

    private void triggerValidationListenerCallback(ValidationReport validationReport) {
        List<ValidationError> validationErrors = validationReport.errors;
        if (validationErrors.size() == 0 && !validationReport.hasMoreErrors) {
            this.mValidationListener.onValidationSucceeded();
        } else {
            this.mValidationListener.onValidationFailed(validationErrors);
        }
    }

    private void assertOrderedFields(boolean orderedRules, String reasonSuffix) {
        if (!orderedRules) {
            String message = "Rules are unordered, all view fields should be ordered using the '@Order' annotation " + reasonSuffix;
            throw new IllegalStateException(message);
        }
    }

    private ValidationReport getValidationReport(View targetView, Map<View, ArrayList<Pair<Rule, ViewDataAdapter>>> viewRulesMap, Mode validationMode) {
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        Set<View> views = viewRulesMap.keySet();
        boolean addErrorToReport = targetView != null;
        boolean hasMoreErrors = false;
        block0: for (View view : views) {
            ArrayList<Pair<Rule, ViewDataAdapter>> ruleAdapterPairs = viewRulesMap.get(view);
            int nRules = ruleAdapterPairs.size();
            ArrayList<Rule> failedRules = null;
            for (int i = 0; i < nRules; ++i) {
                boolean isLastRuleForView;
                if (!view.isShown() || !view.isEnabled()) continue;
                Pair<Rule, ViewDataAdapter> ruleAdapterPair = ruleAdapterPairs.get(i);
                Rule failedRule = this.validateViewWithRule(view, (Rule)ruleAdapterPair.first, (ViewDataAdapter)ruleAdapterPair.second);
                boolean bl = isLastRuleForView = nRules == i + 1;
                if (failedRule != null) {
                    if (addErrorToReport) {
                        if (failedRules == null) {
                            failedRules = new ArrayList<Rule>();
                            validationErrors.add(new ValidationError(view, failedRules));
                        }
                        failedRules.add(failedRule);
                    } else {
                        hasMoreErrors = true;
                    }
                    if (Mode.IMMEDIATE.equals((Object)validationMode) && isLastRuleForView) break block0;
                }
                if (!view.equals(targetView) || !isLastRuleForView) continue;
                addErrorToReport = false;
            }
            boolean viewPassedAllRules = (failedRules == null || failedRules.size() == 0) && !hasMoreErrors;
            if (!viewPassedAllRules || this.mViewValidatedAction == null) continue;
            this.triggerViewValidatedCallback(this.mViewValidatedAction, view);
        }
        return new ValidationReport(validationErrors, hasMoreErrors);
    }

    private Rule validateViewWithRule(View view, Rule rule, ViewDataAdapter dataAdapter) {
        boolean valid = false;
        if (rule instanceof AnnotationRule) {
            try {
                Object data = dataAdapter.getData(view);
                valid = rule.isValid(data);
            }
            catch (ConversionException e) {
                valid = false;
                e.printStackTrace();
            }
        } else if (rule instanceof QuickRule) {
            valid = rule.isValid(view);
        }
        return valid ? null : rule;
    }

    private void triggerViewValidatedCallback(final ViewValidatedAction viewValidatedAction, final View view) {
        boolean isOnMainThread;
        boolean bl = isOnMainThread = Looper.myLooper() == Looper.getMainLooper();
        if (isOnMainThread) {
            viewValidatedAction.onAllRulesPassed(view);
        } else {
            this.runOnMainThread(new Runnable(){

                @Override
                public void run() {
                    viewValidatedAction.onAllRulesPassed(view);
                }
            });
        }
    }

    private void runOnMainThread(Runnable runnable) {
        if (this.mViewValidatedActionHandler == null) {
            this.mViewValidatedActionHandler = new Handler(Looper.getMainLooper());
        }
        this.mViewValidatedActionHandler.post(runnable);
    }

    private View getLastView() {
        Set<View> views = this.mViewRulesMap.keySet();
        View lastView = null;
        Iterator<View> iterator = views.iterator();
        while (iterator.hasNext()) {
            View view;
            lastView = view = iterator.next();
        }
        return lastView;
    }

    private View getViewBefore(View view) {
        ArrayList<View> views = new ArrayList<View>(this.mViewRulesMap.keySet());
        int nViews = views.size();
        View previousView = null;
        for (int i = 0; i < nViews; ++i) {
            View currentView = views.get(i);
            if (currentView != view) continue;
            previousView = i > 0 ? views.get(i - 1) : null;
            break;
        }
        return previousView;
    }

    static {
        SARIPAAR_REGISTRY.register(CheckBox.class, Boolean.class, new CheckBoxBooleanAdapter(), AssertFalse.class, AssertTrue.class, Checked.class);
        SARIPAAR_REGISTRY.register(RadioGroup.class, Boolean.class, new RadioGroupBooleanAdapter(), Checked.class);
        SARIPAAR_REGISTRY.register(RadioButton.class, Boolean.class, new RadioButtonBooleanAdapter(), AssertFalse.class, AssertTrue.class, Checked.class);
        SARIPAAR_REGISTRY.register(Spinner.class, Integer.class, new SpinnerIndexAdapter(), Select.class);
        SARIPAAR_REGISTRY.register(DecimalMax.class, DecimalMin.class);
        SARIPAAR_REGISTRY.register(Max.class, Min.class);
        SARIPAAR_REGISTRY.register(ConfirmEmail.class, ConfirmPassword.class, CreditCard.class, Digits.class, Domain.class, Email.class, Future.class, IpAddress.class, Isbn.class, Length.class, NotEmpty.class, Password.class, Past.class, Pattern.class, Url.class);
    }

    class AsyncValidationTask
    extends AsyncTask<Void, Void, ValidationReport> {
        private View mView;
        private boolean mOrderedRules;
        private String mReasonSuffix;

        public AsyncValidationTask(View view, boolean orderedRules, String reasonSuffix) {
            this.mView = view;
            this.mOrderedRules = orderedRules;
            this.mReasonSuffix = reasonSuffix;
        }

        protected ValidationReport doInBackground(Void ... params) {
            return Validator.this.validateTill(this.mView, this.mOrderedRules, this.mReasonSuffix);
        }

        protected void onPostExecute(ValidationReport validationReport) {
            Validator.this.triggerValidationListenerCallback(validationReport);
        }
    }

    static class ValidationReport {
        List<ValidationError> errors;
        boolean hasMoreErrors;

        ValidationReport(List<ValidationError> errors, boolean hasMoreErrors) {
            this.errors = errors;
            this.hasMoreErrors = hasMoreErrors;
        }
    }

    public static enum Mode {
        BURST,
        IMMEDIATE;

    }

    public static interface ViewValidatedAction {
        public void onAllRulesPassed(View var1);
    }

    public static interface ValidationListener {
        public void onValidationSucceeded();

        public void onValidationFailed(List<ValidationError> var1);
    }
}

