/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar;

import android.os.AsyncTask;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.mobsandgeeks.saripaar.AnnotationRuleFactory;
import com.mobsandgeeks.saripaar.Rule;
import com.mobsandgeeks.saripaar.annotation.Checked;
import com.mobsandgeeks.saripaar.annotation.ConfirmPassword;
import com.mobsandgeeks.saripaar.annotation.Email;
import com.mobsandgeeks.saripaar.annotation.IpAddress;
import com.mobsandgeeks.saripaar.annotation.NumberRule;
import com.mobsandgeeks.saripaar.annotation.Password;
import com.mobsandgeeks.saripaar.annotation.Regex;
import com.mobsandgeeks.saripaar.annotation.Required;
import com.mobsandgeeks.saripaar.annotation.Select;
import com.mobsandgeeks.saripaar.annotation.TextRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Validator {
    static final String TAG = "Validator";
    static final boolean DEBUG = false;
    private Object mController;
    private boolean mAnnotationsProcessed = false;
    private List<ViewRulePair> mViewsAndRules = new ArrayList<ViewRulePair>();
    private Map<String, Object> mProperties = new HashMap<String, Object>();
    private AsyncTask<Void, Void, ViewRulePair> mAsyncValidationTask;
    private ValidationListener mValidationListener;

    private Validator() {
    }

    public Validator(Object controller) {
        this();
        if (controller == null) {
            throw new IllegalArgumentException("'controller' cannot be null");
        }
        this.mController = controller;
    }

    public void put(View view, Rule<?> rule) {
        if (rule == null) {
            throw new IllegalArgumentException("'rule' cannot be null");
        }
        this.mViewsAndRules.add(new ViewRulePair(view, rule));
    }

    public void put(View view, List<Rule<?>> rules) {
        if (rules == null) {
            throw new IllegalArgumentException("'rules' cannot be null");
        }
        for (Rule<?> rule : rules) {
            this.put(view, rule);
        }
    }

    public void put(Rule<?> rule) {
        this.put(null, rule);
    }

    public synchronized void validate() {
        if (this.mValidationListener == null) {
            throw new IllegalStateException("Set a " + ValidationListener.class.getSimpleName() + " before attempting to validate.");
        }
        ViewRulePair failedViewRulePair = this.validateAllRules();
        if (failedViewRulePair == null) {
            this.mValidationListener.onValidationSucceeded();
        } else {
            this.mValidationListener.onValidationFailed(failedViewRulePair.view, failedViewRulePair.rule);
        }
    }

    public void validateAsync() {
        if (this.mValidationListener == null) {
            throw new IllegalStateException("Set a " + ValidationListener.class.getSimpleName() + " before attempting to validate.");
        }
        if (this.mAsyncValidationTask != null) {
            this.mAsyncValidationTask.cancel(true);
            this.mAsyncValidationTask = null;
        }
        this.mAsyncValidationTask = new AsyncTask<Void, Void, ViewRulePair>(){

            protected ViewRulePair doInBackground(Void ... params) {
                return Validator.this.validateAllRules();
            }

            protected void onPostExecute(ViewRulePair pair) {
                if (pair == null) {
                    Validator.this.mValidationListener.onValidationSucceeded();
                } else {
                    Validator.this.mValidationListener.onValidationFailed(pair.view, pair.rule);
                }
                Validator.this.mAsyncValidationTask = null;
            }

            protected void onCancelled() {
                Validator.this.mAsyncValidationTask = null;
            }
        };
        this.mAsyncValidationTask.execute((Object[])null);
    }

    public boolean isValidating() {
        return this.mAsyncValidationTask != null && this.mAsyncValidationTask.getStatus() != AsyncTask.Status.FINISHED;
    }

    public boolean cancelAsync() {
        boolean cancelled = false;
        if (this.mAsyncValidationTask != null) {
            cancelled = this.mAsyncValidationTask.cancel(true);
            this.mAsyncValidationTask = null;
        }
        return cancelled;
    }

    public ValidationListener getValidationListener() {
        return this.mValidationListener;
    }

    public void setValidationListener(ValidationListener validationListener) {
        this.mValidationListener = validationListener;
    }

    public void setProperty(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        this.mProperties.put(name, value);
    }

    public Object getProperty(String name) {
        if (name == null) {
            throw new IllegalArgumentException("'name' cannot be null");
        }
        return this.mProperties.get(name);
    }

    public Object removeProperty(String name) {
        return name != null ? this.mProperties.remove(name) : null;
    }

    public boolean containsProperty(String name) {
        return name != null ? this.mProperties.containsKey(name) : false;
    }

    public void removeAllProperties() {
        this.mProperties.clear();
    }

    public void removeRulesFor(View view) {
        if (view == null) {
            throw new IllegalArgumentException("'view' cannot be null");
        }
        int index = 0;
        while (index < this.mViewsAndRules.size()) {
            ViewRulePair pair = this.mViewsAndRules.get(index);
            if (pair.view == view) {
                this.mViewsAndRules.remove(index);
                continue;
            }
            ++index;
        }
    }

    private ViewRulePair validateAllRules() {
        if (!this.mAnnotationsProcessed) {
            this.createRulesFromAnnotations(this.getSaripaarAnnotatedFields());
            this.mAnnotationsProcessed = true;
        }
        if (this.mViewsAndRules.size() == 0) {
            Log.i((String)TAG, (String)"No rules found. Passing validation by default.");
            return null;
        }
        ViewRulePair failedViewRulePair = null;
        for (ViewRulePair pair : this.mViewsAndRules) {
            if (pair == null || pair.view != null && (!pair.view.isShown() || !pair.view.isEnabled()) || pair.rule.isValid(pair.view)) continue;
            failedViewRulePair = pair;
            break;
        }
        return failedViewRulePair;
    }

    private void createRulesFromAnnotations(List<AnnotationFieldPair> annotationFieldPairs) {
        TextView passwordTextView = null;
        TextView confirmPasswordTextView = null;
        for (AnnotationFieldPair pair : annotationFieldPairs) {
            if (pair.annotation.annotationType().equals(Password.class)) {
                if (passwordTextView == null) {
                    passwordTextView = (TextView)this.getView(pair.field);
                } else {
                    throw new IllegalStateException("You cannot annotate two fields in the same Activity with @Password.");
                }
            }
            if (pair.annotation.annotationType().equals(ConfirmPassword.class)) {
                if (passwordTextView == null) {
                    throw new IllegalStateException("A @Password annotated field is required before you can use @ConfirmPassword.");
                }
                if (confirmPasswordTextView != null) {
                    throw new IllegalStateException("You cannot annotate two fields in the same Activity with @ConfirmPassword.");
                }
                if (confirmPasswordTextView == null) {
                    confirmPasswordTextView = (TextView)this.getView(pair.field);
                }
            }
            ViewRulePair viewRulePair = null;
            viewRulePair = pair.annotation.annotationType().equals(ConfirmPassword.class) ? this.getViewAndRule(pair.field, pair.annotation, passwordTextView) : this.getViewAndRule(pair.field, pair.annotation, new Object[0]);
            if (viewRulePair == null) continue;
            this.mViewsAndRules.add(viewRulePair);
        }
    }

    private ViewRulePair getViewAndRule(Field field, Annotation annotation, Object ... params) {
        View view = this.getView(field);
        if (view == null) {
            Log.w((String)TAG, (String)String.format("Your %s - %s is null. Please check your field assignment(s).", field.getType().getSimpleName(), field.getName()));
            return null;
        }
        Rule<?> rule = null;
        rule = params != null && params.length > 0 ? AnnotationRuleFactory.getRule(field, view, annotation, params) : AnnotationRuleFactory.getRule(field, view, annotation);
        return rule != null ? new ViewRulePair(view, rule) : null;
    }

    private View getView(Field field) {
        try {
            field.setAccessible(true);
            Object instance = this.mController;
            return (View)field.get(instance);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<AnnotationFieldPair> getSaripaarAnnotatedFields() {
        ArrayList<AnnotationFieldPair> annotationFieldPairs = new ArrayList<AnnotationFieldPair>();
        List<Field> fieldsWithAnnotations = this.getViewFieldsWithAnnotations();
        for (Field field : fieldsWithAnnotations) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = field.getAnnotations()) {
                if (!this.isSaripaarAnnotation(annotation)) continue;
                annotationFieldPairs.add(new AnnotationFieldPair(annotation, field));
            }
        }
        Collections.sort(annotationFieldPairs, new AnnotationFieldPairCompartor());
        return annotationFieldPairs;
    }

    private List<Field> getViewFieldsWithAnnotations() {
        ArrayList<Field> fieldsWithAnnotations = new ArrayList<Field>();
        List<Field> viewFields = this.getAllViewFields();
        for (Field field : viewFields) {
            Annotation[] annotations = field.getAnnotations();
            if (annotations == null || annotations.length == 0) continue;
            fieldsWithAnnotations.add(field);
        }
        return fieldsWithAnnotations;
    }

    private List<Field> getAllViewFields() {
        ArrayList<Field> viewFields = new ArrayList<Field>();
        Class<?> superClass = null;
        if (this.mController != null) {
            viewFields.addAll(this.getDeclaredViewFields(this.mController.getClass()));
            superClass = this.mController.getClass().getSuperclass();
        }
        while (superClass != null && !superClass.equals(Object.class)) {
            List<Field> declaredViewFields = this.getDeclaredViewFields(superClass);
            if (declaredViewFields.size() > 0) {
                viewFields.addAll(declaredViewFields);
            }
            superClass = superClass.getSuperclass();
        }
        return viewFields;
    }

    private List<Field> getDeclaredViewFields(Class<?> clazz) {
        Field[] declaredFields;
        ArrayList<Field> viewFields = new ArrayList<Field>();
        for (Field f : declaredFields = clazz.getDeclaredFields()) {
            if (!View.class.isAssignableFrom(f.getType())) continue;
            viewFields.add(f);
        }
        return viewFields;
    }

    private boolean isSaripaarAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        return annotationType.equals(Checked.class) || annotationType.equals(ConfirmPassword.class) || annotationType.equals(Email.class) || annotationType.equals(IpAddress.class) || annotationType.equals(NumberRule.class) || annotationType.equals(Password.class) || annotationType.equals(Regex.class) || annotationType.equals(Required.class) || annotationType.equals(Select.class) || annotationType.equals(TextRule.class);
    }

    private class AnnotationFieldPairCompartor
    implements Comparator<AnnotationFieldPair> {
        private AnnotationFieldPairCompartor() {
        }

        @Override
        public int compare(AnnotationFieldPair lhs, AnnotationFieldPair rhs) {
            int rhsOrder;
            int lhsOrder = this.getAnnotationOrder(lhs.annotation);
            return lhsOrder < (rhsOrder = this.getAnnotationOrder(rhs.annotation)) ? -1 : (lhsOrder == rhsOrder ? 0 : 1);
        }

        private int getAnnotationOrder(Annotation annotation) {
            Class<? extends Annotation> annotatedClass = annotation.annotationType();
            if (annotatedClass.equals(Checked.class)) {
                return ((Checked)annotation).order();
            }
            if (annotatedClass.equals(ConfirmPassword.class)) {
                return ((ConfirmPassword)annotation).order();
            }
            if (annotatedClass.equals(Email.class)) {
                return ((Email)annotation).order();
            }
            if (annotatedClass.equals(IpAddress.class)) {
                return ((IpAddress)annotation).order();
            }
            if (annotatedClass.equals(NumberRule.class)) {
                return ((NumberRule)annotation).order();
            }
            if (annotatedClass.equals(Password.class)) {
                return ((Password)annotation).order();
            }
            if (annotatedClass.equals(Regex.class)) {
                return ((Regex)annotation).order();
            }
            if (annotatedClass.equals(Required.class)) {
                return ((Required)annotation).order();
            }
            if (annotatedClass.equals(Select.class)) {
                return ((Select)annotation).order();
            }
            if (annotatedClass.equals(TextRule.class)) {
                return ((TextRule)annotation).order();
            }
            throw new IllegalArgumentException(String.format("%s is not a Saripaar annotation", annotatedClass.getName()));
        }
    }

    private class AnnotationFieldPair {
        public Annotation annotation;
        public Field field;

        public AnnotationFieldPair(Annotation annotation, Field field) {
            this.annotation = annotation;
            this.field = field;
        }
    }

    private class ViewRulePair {
        public View view;
        public Rule rule;

        public ViewRulePair(View view, Rule<?> rule) {
            this.view = view;
            this.rule = rule;
        }
    }

    public static interface ValidationListener {
        public void onValidationSucceeded();

        public void onValidationFailed(View var1, Rule<?> var2);
    }
}

