/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.rpc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLHandshakeException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.p2p.solanaj.rpc.Cluster;
import org.p2p.solanaj.rpc.RpcApi;
import org.p2p.solanaj.rpc.RpcException;
import org.p2p.solanaj.rpc.WeightedCluster;
import org.p2p.solanaj.rpc.types.RpcRequest;
import org.p2p.solanaj.rpc.types.RpcResponse;
import org.p2p.solanaj.rpc.types.WeightedEndpoint;

public class RpcClient {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private String endpoint;
    private OkHttpClient httpClient;
    private RpcApi rpcApi;
    private WeightedCluster cluster;
    private final ObjectMapper objectMapper;

    private static OkHttpClient.Builder createOptimizedClientBuilder() {
        return new OkHttpClient.Builder().protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
    }

    public RpcClient(WeightedCluster cluster) {
        this.cluster = cluster;
        this.endpoint = cluster.getEndpoints().get(0).getUrl();
        this.httpClient = RpcClient.createOptimizedClientBuilder().readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public RpcClient(Cluster endpoint) {
        this(endpoint.getEndpoint());
    }

    public RpcClient(String endpoint) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().readTimeout(20L, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, String userAgent) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().addNetworkInterceptor(chain -> {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header("User-Agent", userAgent).build();
            return chain.proceed(requestWithUserAgent);
        }).readTimeout(20L, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, int timeout) {
        this(endpoint, RpcClient.createOptimizedClientBuilder().readTimeout((long)timeout, TimeUnit.SECONDS).build());
    }

    public RpcClient(String endpoint, int readTimeoutMs, int connectTimeoutMs, int writeTimeoutMs) {
        this.endpoint = endpoint;
        this.httpClient = RpcClient.createOptimizedClientBuilder().readTimeout((long)readTimeoutMs, TimeUnit.MILLISECONDS).connectTimeout((long)connectTimeoutMs, TimeUnit.MILLISECONDS).writeTimeout((long)writeTimeoutMs, TimeUnit.MILLISECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public RpcClient(String endpoint, OkHttpClient httpClient) {
        this.endpoint = endpoint;
        this.httpClient = httpClient;
        this.rpcApi = new RpcApi(this);
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public RpcClient(String endpoint, String proxyHost, int proxyPort) {
        this.endpoint = endpoint;
        this.httpClient = RpcClient.createOptimizedClientBuilder().proxy(new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(proxyHost, proxyPort))).readTimeout(20L, TimeUnit.SECONDS).build();
        this.rpcApi = new RpcApi(this);
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }

    public <T> T call(String method, List<Object> params, Class<T> clazz) throws RpcException {
        RpcRequest rpcRequest = new RpcRequest(method, params);
        try {
            RpcResponse rpcResult;
            String result;
            Request request = new Request.Builder().url(this.getEndpoint()).header("Accept-Encoding", "gzip, deflate").post(RequestBody.create((String)this.objectMapper.writeValueAsString((Object)rpcRequest), (MediaType)JSON)).build();
            Response response = this.httpClient.newCall(request).execute();
            String contentEncoding = response.header("Content-Encoding");
            if ("gzip".equals(contentEncoding)) {
                try (GZIPInputStream gzipStream = new GZIPInputStream(new ByteArrayInputStream(response.body().bytes()));){
                    result = new String(gzipStream.readAllBytes());
                }
            } else {
                result = response.body().string();
            }
            if ((rpcResult = (RpcResponse)this.objectMapper.readValue(result, this.objectMapper.getTypeFactory().constructParametricType(RpcResponse.class, new Class[]{clazz}))) == null || rpcResult.getError() != null) {
                throw new RpcException(rpcResult != null ? rpcResult.getError().getMessage() : "RPC response is null");
            }
            return rpcResult.getResult();
        }
        catch (SSLHandshakeException e) {
            this.httpClient = RpcClient.createOptimizedClientBuilder().build();
            throw new RpcException("SSL Handshake failed: " + e.getMessage());
        }
        catch (JsonProcessingException e) {
            throw new RpcException("JSON processing error during RPC call: " + e.getMessage());
        }
        catch (IOException e) {
            throw new RpcException("IO error during RPC call: " + e.getMessage());
        }
    }

    public RpcApi getApi() {
        return this.rpcApi;
    }

    public String getEndpoint() {
        return this.cluster != null ? this.getWeightedEndpoint() : this.endpoint;
    }

    private String getWeightedEndpoint() {
        int totalWeight = this.cluster.endpoints.stream().mapToInt(WeightedEndpoint::getWeight).sum();
        double randomNumber = Math.random() * (double)totalWeight;
        int currentWeight = 0;
        for (WeightedEndpoint endpoint : this.cluster.endpoints) {
            if (!(randomNumber < (double)(currentWeight += endpoint.getWeight().intValue()))) continue;
            return endpoint.getUrl();
        }
        return "";
    }
}

