/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.programs.Program;

public class TokenProgram
extends Program {
    public static final PublicKey PROGRAM_ID = new PublicKey("TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA");
    public static final PublicKey SYSVAR_RENT_PUBKEY = new PublicKey("SysvarRent111111111111111111111111111111111");
    private static final int INITIALIZE_MINT_METHOD_ID = 0;
    private static final int INITIALIZE_ACCOUNT_METHOD_ID = 1;
    private static final int INITIALIZE_MULTISIG_METHOD_ID = 2;
    private static final int TRANSFER_METHOD_ID = 3;
    private static final int APPROVE_METHOD_ID = 4;
    private static final int REVOKE_METHOD_ID = 5;
    private static final int SET_AUTHORITY_METHOD_ID = 6;
    private static final int MINT_TO_METHOD_ID = 7;
    private static final int BURN_METHOD_ID = 8;
    private static final int CLOSE_ACCOUNT_METHOD_ID = 9;
    private static final int FREEZE_ACCOUNT_METHOD_ID = 10;
    private static final int THAW_ACCOUNT_METHOD_ID = 11;
    private static final int TRANSFER_CHECKED_METHOD_ID = 12;

    public static TransactionInstruction transfer(PublicKey source, PublicKey destination, long amount, PublicKey owner) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(source, false, true));
        keys.add(new AccountMeta(destination, false, true));
        keys.add(new AccountMeta(owner, true, false));
        byte[] transactionData = TokenProgram.encodeTransferTokenInstructionData(amount);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    public static TransactionInstruction transferChecked(PublicKey source, PublicKey destination, long amount, byte decimals, PublicKey owner, PublicKey tokenMint) {
        return TokenProgram.transferChecked(source, destination, amount, decimals, owner, owner, tokenMint);
    }

    public static TransactionInstruction transferChecked(PublicKey source, PublicKey destination, long amount, byte decimals, PublicKey owner, PublicKey fee, PublicKey tokenMint) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(source, false, true));
        keys.add(new AccountMeta(tokenMint, false, false));
        keys.add(new AccountMeta(destination, false, true));
        if (owner == fee) {
            keys.add(new AccountMeta(fee, true, true));
        } else {
            keys.add(new AccountMeta(owner, true, false));
            keys.add(new AccountMeta(fee, true, true));
        }
        byte[] transactionData = TokenProgram.encodeTransferCheckedTokenInstructionData(amount, decimals);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, transactionData);
    }

    public static TransactionInstruction initializeAccount(PublicKey account, PublicKey mint, PublicKey owner) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(account, false, true));
        keys.add(new AccountMeta(mint, false, false));
        keys.add(new AccountMeta(owner, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)1);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction closeAccount(PublicKey accountPubkey, PublicKey destinationPubkey, PublicKey ownerPubkey) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(destinationPubkey, false, true));
        keys.add(new AccountMeta(ownerPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)9);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    private static byte[] encodeTransferTokenInstructionData(long amount) {
        ByteBuffer result = ByteBuffer.allocate(9);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)3);
        result.putLong(amount);
        return result.array();
    }

    private static byte[] encodeTransferCheckedTokenInstructionData(long amount, byte decimals) {
        ByteBuffer result = ByteBuffer.allocate(10);
        result.order(ByteOrder.LITTLE_ENDIAN);
        result.put((byte)12);
        result.putLong(amount);
        result.put(decimals);
        return result.array();
    }

    public static TransactionInstruction initializeMint(PublicKey mintPubkey, int decimals, PublicKey mintAuthority, PublicKey freezeAuthority) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(mintPubkey, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        ByteBuffer buffer = ByteBuffer.allocate(35 + (freezeAuthority != null ? 32 : 0));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)0);
        buffer.put((byte)decimals);
        buffer.put(mintAuthority.toByteArray());
        buffer.put((byte)(freezeAuthority != null ? 1 : 0));
        if (freezeAuthority != null) {
            buffer.put(freezeAuthority.toByteArray());
        }
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction initializeMultisig(PublicKey multisigPubkey, List<PublicKey> signerPubkeys, int m) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(multisigPubkey, false, true));
        keys.add(new AccountMeta(SYSVAR_RENT_PUBKEY, false, false));
        for (PublicKey signerPubkey : signerPubkeys) {
            keys.add(new AccountMeta(signerPubkey, false, false));
        }
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)2);
        buffer.put((byte)m);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction approve(PublicKey sourcePubkey, PublicKey delegatePubkey, PublicKey ownerPubkey, long amount) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(sourcePubkey, false, true));
        keys.add(new AccountMeta(delegatePubkey, false, false));
        keys.add(new AccountMeta(ownerPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)4);
        buffer.putLong(amount);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction revoke(PublicKey accountPubkey, PublicKey ownerPubkey) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(ownerPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)5);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction setAuthority(PublicKey accountPubkey, PublicKey currentAuthorityPubkey, PublicKey newAuthorityPubkey, AuthorityType authorityType) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(currentAuthorityPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(3 + (newAuthorityPubkey != null ? 32 : 0));
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)6);
        buffer.put((byte)authorityType.getValue());
        buffer.put((byte)(newAuthorityPubkey != null ? 1 : 0));
        if (newAuthorityPubkey != null) {
            buffer.put(newAuthorityPubkey.toByteArray());
        }
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction mintTo(PublicKey mintPubkey, PublicKey destinationPubkey, PublicKey authorityPubkey, long amount) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(mintPubkey, false, true));
        keys.add(new AccountMeta(destinationPubkey, false, true));
        keys.add(new AccountMeta(authorityPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)7);
        buffer.putLong(amount);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction burn(PublicKey accountPubkey, PublicKey mintPubkey, PublicKey ownerPubkey, long amount) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(mintPubkey, false, true));
        keys.add(new AccountMeta(ownerPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)8);
        buffer.putLong(amount);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction freezeAccount(PublicKey accountPubkey, PublicKey mintPubkey, PublicKey authorityPubkey) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(mintPubkey, false, false));
        keys.add(new AccountMeta(authorityPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)10);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static TransactionInstruction thawAccount(PublicKey accountPubkey, PublicKey mintPubkey, PublicKey authorityPubkey) {
        ArrayList<AccountMeta> keys = new ArrayList<AccountMeta>();
        keys.add(new AccountMeta(accountPubkey, false, true));
        keys.add(new AccountMeta(mintPubkey, false, false));
        keys.add(new AccountMeta(authorityPubkey, true, false));
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)11);
        return TokenProgram.createTransactionInstruction(PROGRAM_ID, keys, buffer.array());
    }

    public static enum AuthorityType {
        MINT_TOKENS(0),
        FREEZE_ACCOUNT(1),
        ACCOUNT_OWNER(2),
        CLOSE_ACCOUNT(3);

        private final int value;

        private AuthorityType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

