/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.programs;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.Sysvar;
import org.p2p.solanaj.core.TransactionInstruction;

public class SystemProgram {
    public static final PublicKey PROGRAM_ID = new PublicKey("11111111111111111111111111111111");
    private static final int PROGRAM_INDEX_CREATE_ACCOUNT = 0;
    private static final int PROGRAM_INDEX_ASSIGN = 1;
    private static final int PROGRAM_INDEX_TRANSFER = 2;
    private static final int UINT32_SIZE = 4;
    private static final int INT64_SIZE = 8;
    private static final int PUBKEY_SIZE = 32;
    public static final int PROGRAM_INDEX_NONCE_INIT_INSTRUCTION = 6;
    public static final int ADVANCE_NONCE_INSTRUCTION = 4;

    private SystemProgram() {
    }

    public static TransactionInstruction transfer(PublicKey fromPublicKey, PublicKey toPublicKey, long lamports) {
        if (lamports < 0L) {
            throw new IllegalArgumentException("Lamports must be non-negative");
        }
        List<AccountMeta> keys = Arrays.asList(new AccountMeta(fromPublicKey, true, true), new AccountMeta(toPublicKey, false, true));
        byte[] data = new byte[12];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(2).putLong(lamports);
        return new TransactionInstruction(PROGRAM_ID, keys, data);
    }

    public static TransactionInstruction createAccount(PublicKey fromPublicKey, PublicKey newAccountPublicKey, long lamports, long space, PublicKey programId) {
        if (lamports < 0L || space < 0L) {
            throw new IllegalArgumentException("Lamports and space must be non-negative");
        }
        List<AccountMeta> keys = Arrays.asList(new AccountMeta(fromPublicKey, true, true), new AccountMeta(newAccountPublicKey, true, true));
        byte[] data = new byte[52];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(0).putLong(lamports).putLong(space);
        System.arraycopy(programId.toByteArray(), 0, data, 20, 32);
        return new TransactionInstruction(PROGRAM_ID, keys, data);
    }

    public static TransactionInstruction assign(PublicKey owner, PublicKey newOwner) {
        List<AccountMeta> keys = List.of(new AccountMeta(owner, true, true));
        byte[] data = new byte[36];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(1);
        System.arraycopy(newOwner.toByteArray(), 0, data, 4, 32);
        return new TransactionInstruction(PROGRAM_ID, keys, data);
    }

    public static TransactionInstruction nonceInitialize(PublicKey nonce, PublicKey authorized) {
        List<AccountMeta> keys = Arrays.asList(new AccountMeta(nonce, false, true), new AccountMeta(Sysvar.RECENT_BLOCKHASHES, false, false), new AccountMeta(Sysvar.SYSVAR_RENT_ADDRESS, false, false));
        byte[] data = new byte[36];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(6);
        System.arraycopy(authorized.toByteArray(), 0, data, 4, 32);
        return new TransactionInstruction(PROGRAM_ID, keys, data);
    }

    public static TransactionInstruction nonceAdvance(PublicKey nonce, PublicKey authorized) {
        List<AccountMeta> keys = Arrays.asList(new AccountMeta(nonce, false, true), new AccountMeta(Sysvar.RECENT_BLOCKHASHES, false, false), new AccountMeta(authorized, true, false));
        byte[] data = new byte[4];
        ByteBuffer.wrap(data).order(ByteOrder.LITTLE_ENDIAN).putInt(4);
        return new TransactionInstruction(PROGRAM_ID, keys, data);
    }
}

