/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.Message;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.utils.Base58;
import org.p2p.solanaj.utils.ShortvecEncoding;
import org.p2p.solanaj.utils.TweetNaclFast;

public class Transaction {
    public static final int SIGNATURE_LENGTH = 64;
    private final Message message = new Message();
    private final List<String> signatures = new ArrayList<String>();
    private byte[] serializedMessage;

    public Transaction addInstruction(TransactionInstruction instruction) {
        Objects.requireNonNull(instruction, "Instruction cannot be null");
        this.message.addInstruction(instruction);
        return this;
    }

    public void setRecentBlockHash(String recentBlockhash) {
        Objects.requireNonNull(recentBlockhash, "Recent blockhash cannot be null");
        this.message.setRecentBlockHash(recentBlockhash);
    }

    public void sign(Account signer) {
        this.sign(Arrays.asList(Objects.requireNonNull(signer, "Signer cannot be null")));
    }

    public void sign(List<Account> signers) {
        if (signers == null || signers.isEmpty()) {
            throw new IllegalArgumentException("No signers provided");
        }
        Account feePayer = signers.get(0);
        this.message.setFeePayer(feePayer);
        this.serializedMessage = this.message.serialize();
        for (Account signer : signers) {
            try {
                TweetNaclFast.Signature signatureProvider = new TweetNaclFast.Signature(new byte[0], signer.getSecretKey());
                byte[] signature = signatureProvider.detached(this.serializedMessage);
                this.signatures.add(Base58.encode(signature));
            }
            catch (Exception e) {
                throw new RuntimeException("Error signing transaction", e);
            }
        }
    }

    public byte[] serialize() {
        int signaturesSize = this.signatures.size();
        byte[] signaturesLength = ShortvecEncoding.encodeLength(signaturesSize);
        int totalSize = signaturesLength.length + signaturesSize * 64 + this.serializedMessage.length;
        ByteBuffer out = ByteBuffer.allocate(totalSize);
        out.put(signaturesLength);
        for (String signature : this.signatures) {
            byte[] rawSignature = Base58.decode(signature);
            out.put(rawSignature);
        }
        out.put(this.serializedMessage);
        return out.array();
    }
}

