/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.p2p.solanaj.core.Account;
import org.p2p.solanaj.core.AccountKeysList;
import org.p2p.solanaj.core.AccountMeta;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.core.TransactionInstruction;
import org.p2p.solanaj.utils.Base58;
import org.p2p.solanaj.utils.ShortvecEncoding;

public class Message {
    private static final int RECENT_BLOCK_HASH_LENGTH = 32;
    private MessageHeader messageHeader;
    private String recentBlockhash;
    private AccountKeysList accountKeys = new AccountKeysList();
    private List<TransactionInstruction> instructions = new ArrayList<TransactionInstruction>();
    private Account feePayer;

    public Message addInstruction(TransactionInstruction instruction) {
        this.accountKeys.addAll(instruction.getKeys());
        this.accountKeys.add(new AccountMeta(instruction.getProgramId(), false, false));
        this.instructions.add(instruction);
        return this;
    }

    public void setRecentBlockHash(String recentBlockhash) {
        this.recentBlockhash = recentBlockhash;
    }

    public byte[] serialize() {
        if (this.recentBlockhash == null) {
            throw new IllegalArgumentException("recentBlockhash required");
        }
        if (this.instructions.size() == 0) {
            throw new IllegalArgumentException("No instructions provided");
        }
        this.messageHeader = new MessageHeader();
        List<AccountMeta> keysList = this.getAccountKeys();
        int accountKeysSize = keysList.size();
        byte[] accountAddressesLength = ShortvecEncoding.encodeLength(accountKeysSize);
        int compiledInstructionsLength = 0;
        ArrayList<CompiledInstruction> compiledInstructions = new ArrayList<CompiledInstruction>();
        for (TransactionInstruction instruction : this.instructions) {
            int keysSize = instruction.getKeys().size();
            byte[] keyIndices = new byte[keysSize];
            for (int i = 0; i < keysSize; ++i) {
                keyIndices[i] = (byte)this.findAccountIndex(keysList, instruction.getKeys().get(i).getPublicKey());
            }
            CompiledInstruction compiledInstruction = new CompiledInstruction();
            compiledInstruction.programIdIndex = (byte)this.findAccountIndex(keysList, instruction.getProgramId());
            compiledInstruction.keyIndicesCount = ShortvecEncoding.encodeLength(keysSize);
            compiledInstruction.keyIndices = keyIndices;
            compiledInstruction.dataLength = ShortvecEncoding.encodeLength(instruction.getData().length);
            compiledInstruction.data = instruction.getData();
            compiledInstructions.add(compiledInstruction);
            compiledInstructionsLength += compiledInstruction.getLength();
        }
        byte[] instructionsLength = ShortvecEncoding.encodeLength(compiledInstructions.size());
        int bufferSize = 35 + accountAddressesLength.length + accountKeysSize * 32 + instructionsLength.length + compiledInstructionsLength;
        ByteBuffer out = ByteBuffer.allocate(bufferSize);
        ByteBuffer accountKeysBuff = ByteBuffer.allocate(accountKeysSize * 32);
        for (AccountMeta accountMeta : keysList) {
            accountKeysBuff.put(accountMeta.getPublicKey().toByteArray());
            if (accountMeta.isSigner()) {
                this.messageHeader.numRequiredSignatures = (byte)(this.messageHeader.numRequiredSignatures + 1);
                if (accountMeta.isWritable()) continue;
                this.messageHeader.numReadonlySignedAccounts = (byte)(this.messageHeader.numReadonlySignedAccounts + 1);
                continue;
            }
            if (accountMeta.isWritable()) continue;
            this.messageHeader.numReadonlyUnsignedAccounts = (byte)(this.messageHeader.numReadonlyUnsignedAccounts + 1);
        }
        out.put(this.messageHeader.toByteArray());
        out.put(accountAddressesLength);
        out.put(accountKeysBuff.array());
        out.put(Base58.decode(this.recentBlockhash));
        out.put(instructionsLength);
        for (CompiledInstruction compiledInstruction : compiledInstructions) {
            out.put(compiledInstruction.programIdIndex);
            out.put(compiledInstruction.keyIndicesCount);
            out.put(compiledInstruction.keyIndices);
            out.put(compiledInstruction.dataLength);
            out.put(compiledInstruction.data);
        }
        return out.array();
    }

    protected void setFeePayer(Account feePayer) {
        this.feePayer = feePayer;
    }

    public List<AccountMeta> getAccountKeys() {
        AccountKeysList accounts = new AccountKeysList();
        accounts.add(new AccountMeta(this.feePayer.getPublicKey(), true, true));
        accounts.addAll(this.accountKeys);
        return accounts.getList();
    }

    private int findAccountIndex(List<AccountMeta> accountMetaList, PublicKey key) {
        for (int i = 0; i < accountMetaList.size(); ++i) {
            if (!accountMetaList.get(i).getPublicKey().equals(key)) continue;
            return i;
        }
        throw new RuntimeException("unable to find account index");
    }

    private class MessageHeader {
        static final int HEADER_LENGTH = 3;
        byte numRequiredSignatures = 0;
        byte numReadonlySignedAccounts = 0;
        byte numReadonlyUnsignedAccounts = 0;

        private MessageHeader() {
        }

        byte[] toByteArray() {
            return new byte[]{this.numRequiredSignatures, this.numReadonlySignedAccounts, this.numReadonlyUnsignedAccounts};
        }
    }

    private class CompiledInstruction {
        byte programIdIndex;
        byte[] keyIndicesCount;
        byte[] keyIndices;
        byte[] dataLength;
        byte[] data;

        private CompiledInstruction() {
        }

        int getLength() {
            return 1 + this.keyIndicesCount.length + this.keyIndices.length + this.dataLength.length + this.data.length;
        }
    }
}

