/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.core;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.p2p.solanaj.core.PublicKey;
import org.p2p.solanaj.utils.Base58;
import org.p2p.solanaj.utils.TweetNaclFast;
import org.p2p.solanaj.utils.bip32.wallet.DerivableType;
import org.p2p.solanaj.utils.bip32.wallet.SolanaBip44;

public class Account {
    private final TweetNaclFast.Signature.KeyPair keyPair;

    public Account() {
        this.keyPair = TweetNaclFast.Signature.keyPair();
    }

    public Account(byte[] secretKey) {
        this.keyPair = TweetNaclFast.Signature.keyPair_fromSecretKey(secretKey);
    }

    private Account(TweetNaclFast.Signature.KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public static Account fromMnemonic(List<String> words, String passphrase) {
        byte[] seed = Account.mnemonicToSeed(words, passphrase);
        TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSeed(seed);
        return new Account(keyPair);
    }

    public static Account fromBip44Mnemonic(List<String> words, String passphrase) {
        SolanaBip44 solanaBip44 = new SolanaBip44();
        byte[] seed = Account.mnemonicToSeed(words, passphrase);
        byte[] privateKey = solanaBip44.getPrivateKeyFromSeed(seed, DerivableType.BIP44);
        return new Account(TweetNaclFast.Signature.keyPair_fromSeed(privateKey));
    }

    public static Account fromBip44MnemonicWithChange(List<String> words, String passphrase) {
        SolanaBip44 solanaBip44 = new SolanaBip44();
        byte[] seed = Account.mnemonicToSeed(words, passphrase);
        byte[] privateKey = solanaBip44.getPrivateKeyFromSeed(seed, DerivableType.BIP44CHANGE);
        return new Account(TweetNaclFast.Signature.keyPair_fromSeed(privateKey));
    }

    public static Account fromBip39Mnemonic(List<String> words, String passphrase) {
        byte[] seed = Account.mnemonicToSeed(words, passphrase);
        TweetNaclFast.Signature.KeyPair keyPair = TweetNaclFast.Signature.keyPair_fromSeed(seed);
        return new Account(keyPair);
    }

    public static Account fromJson(String json) {
        return new Account(Account.convertJsonStringToByteArray(json));
    }

    public PublicKey getPublicKey() {
        return new PublicKey(this.keyPair.getPublicKey());
    }

    public byte[] getSecretKey() {
        return this.keyPair.getSecretKey();
    }

    private static byte[] convertJsonStringToByteArray(String characters) {
        ByteBuffer buffer = ByteBuffer.allocate(64);
        String sanitizedJson = characters.replaceAll("\\[", "").replaceAll("]", "").trim();
        String[] chars = sanitizedJson.split(",");
        Arrays.stream(chars).forEach(character -> {
            byte byteValue = (byte)Integer.parseInt(character.trim());
            buffer.put(byteValue);
        });
        return buffer.array();
    }

    public static Account fromBase58PrivateKey(String base58PrivateKey) {
        byte[] privateKey = Base58.decode(base58PrivateKey);
        return new Account(privateKey);
    }

    public String getPublicKeyBase58() {
        return this.getPublicKey().toBase58();
    }

    public String getPrivateKeyBase58() {
        return Base58.encode(this.getSecretKey());
    }

    private static byte[] mnemonicToSeed(List<String> words, String passphrase) {
        try {
            String mnemonic = String.join((CharSequence)" ", words);
            String salt = "mnemonic" + passphrase;
            PBEKeySpec spec = new PBEKeySpec(mnemonic.toCharArray(), salt.getBytes(), 2048, 512);
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return factory.generateSecret(spec).getEncoded();
        }
        catch (Exception e) {
            throw new RuntimeException("Error deriving seed from mnemonic", e);
        }
    }
}

