/*
 * Decompiled with CFR 0.152.
 */
package org.p2p.solanaj.utils.bip32.crypto;

import java.math.BigInteger;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.math.ec.ECPoint;

public class Secp256k1 {
    static final X9ECParameters SECP = CustomNamedCurves.getByName((String)"secp256k1");

    public static byte[] serP(ECPoint p) {
        return p.getEncoded(true);
    }

    public static ECPoint deserP(byte[] p) {
        return SECP.getCurve().decodePoint(p);
    }

    public static ECPoint point(BigInteger p) {
        return SECP.getG().multiply(p);
    }

    public static BigInteger getN() {
        return SECP.getN();
    }
}

