/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.mixpanel.android.mpmetrics.ConfigurationChecker;
import com.mixpanel.android.mpmetrics.DeviceIdProvider;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.ProxyServerInteractor;
import org.json.JSONObject;

public class MixpanelOptions {
    private final String instanceName;
    private final boolean optOutTrackingDefault;
    private final JSONObject superProperties;
    private final boolean featureFlagsEnabled;
    private final JSONObject featureFlagsContext;
    private final DeviceIdProvider deviceIdProvider;
    private final String serverURL;
    private final ProxyServerInteractor proxyServerInteractor;

    private MixpanelOptions(Builder builder) {
        this.instanceName = builder.instanceName;
        this.optOutTrackingDefault = builder.optOutTrackingDefault;
        this.superProperties = builder.superProperties;
        this.featureFlagsEnabled = builder.featureFlagsEnabled;
        this.featureFlagsContext = builder.featureFlagsContext;
        this.deviceIdProvider = builder.deviceIdProvider;
        this.serverURL = builder.serverURL;
        this.proxyServerInteractor = builder.proxyServerInteractor;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public boolean isOptOutTrackingDefault() {
        return this.optOutTrackingDefault;
    }

    public JSONObject getSuperProperties() {
        if (this.superProperties == null) {
            return null;
        }
        try {
            return new JSONObject(this.superProperties.toString());
        }
        catch (Exception e) {
            MPLog.e(ConfigurationChecker.LOGTAG, "Invalid super properties", e);
            return null;
        }
    }

    public boolean areFeatureFlagsEnabled() {
        return this.featureFlagsEnabled;
    }

    public JSONObject getFeatureFlagsContext() {
        if (this.featureFlagsContext == null) {
            return new JSONObject();
        }
        try {
            return new JSONObject(this.featureFlagsContext.toString());
        }
        catch (Exception e) {
            MPLog.e(ConfigurationChecker.LOGTAG, "Invalid feature flags context", e);
            return new JSONObject();
        }
    }

    @Nullable
    public DeviceIdProvider getDeviceIdProvider() {
        return this.deviceIdProvider;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public ProxyServerInteractor getProxyServerInteractor() {
        return this.proxyServerInteractor;
    }

    public static class Builder {
        private String instanceName;
        private boolean optOutTrackingDefault = false;
        private JSONObject superProperties;
        private boolean featureFlagsEnabled = false;
        private JSONObject featureFlagsContext = new JSONObject();
        private DeviceIdProvider deviceIdProvider = null;
        private String serverURL;
        private ProxyServerInteractor proxyServerInteractor;

        public Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public Builder optOutTrackingDefault(boolean optOutTrackingDefault) {
            this.optOutTrackingDefault = optOutTrackingDefault;
            return this;
        }

        public Builder superProperties(JSONObject superProperties) {
            if (superProperties == null) {
                this.superProperties = null;
            } else {
                try {
                    this.superProperties = new JSONObject(superProperties.toString());
                }
                catch (Exception e) {
                    this.superProperties = null;
                }
            }
            return this;
        }

        public Builder featureFlagsEnabled(boolean featureFlagsEnabled) {
            this.featureFlagsEnabled = featureFlagsEnabled;
            return this;
        }

        public Builder featureFlagsContext(JSONObject featureFlagsContext) {
            if (featureFlagsContext == null) {
                this.featureFlagsContext = new JSONObject();
            } else {
                try {
                    this.featureFlagsContext = new JSONObject(featureFlagsContext.toString());
                }
                catch (Exception e) {
                    this.featureFlagsContext = null;
                }
            }
            return this;
        }

        public Builder deviceIdProvider(DeviceIdProvider deviceIdProvider) {
            this.deviceIdProvider = deviceIdProvider;
            return this;
        }

        public Builder serverURL(@NonNull String serverURL) {
            this.serverURL = serverURL;
            return this;
        }

        public Builder serverURL(@NonNull String serverURL, @Nullable ProxyServerInteractor proxyServerInteractor) {
            this.serverURL = serverURL;
            this.proxyServerInteractor = proxyServerInteractor;
            return this;
        }

        public MixpanelOptions build() {
            return new MixpanelOptions(this);
        }
    }
}

