/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.util.MPLog;
import java.io.Serializable;
import java.util.HashMap;

public class SessionReplayBroadcastReceiver
extends BroadcastReceiver {
    private static final String LOGTAG = "SessionReplayBroadcastReceiver";
    private final MixpanelAPI sdkInstance;
    public static final IntentFilter INTENT_FILTER = new IntentFilter();

    public SessionReplayBroadcastReceiver(MixpanelAPI instance) {
        this.sdkInstance = instance;
    }

    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        if ("com.mixpanel.properties.register".equals(action)) {
            HashMap data = null;
            Serializable serializableData = intent.getSerializableExtra("data");
            if (serializableData instanceof HashMap) {
                try {
                    data = (HashMap)serializableData;
                }
                catch (ClassCastException e) {
                    MPLog.e(LOGTAG, "Failed to cast broadcast extras data to HashMap", e);
                    MPLog.d(LOGTAG, "Broadcast extras data: " + serializableData);
                }
            }
            if (data != null && data.containsKey("$mp_replay_id")) {
                this.sdkInstance.registerSuperPropertiesMap(data);
            }
        } else if ("com.mixpanel.properties.unregister".equals(action)) {
            this.sdkInstance.unregisterSuperProperty("$mp_replay_id");
        }
    }

    static {
        INTENT_FILTER.addAction("com.mixpanel.properties.register");
        INTENT_FILTER.addAction("com.mixpanel.properties.unregister");
    }
}

