/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.mixpanel.android.mpmetrics.FeatureFlagDelegate;
import com.mixpanel.android.mpmetrics.FlagCompletionCallback;
import com.mixpanel.android.mpmetrics.FlagsConfig;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.mpmetrics.MixpanelAPI;
import com.mixpanel.android.mpmetrics.MixpanelFlagVariant;
import com.mixpanel.android.util.Base64Coder;
import com.mixpanel.android.util.JsonUtils;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.RemoteService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONException;
import org.json.JSONObject;

class FeatureFlagManager
implements MixpanelAPI.Flags {
    private static final String LOGTAG = "MixpanelAPI.FeatureFlagManager";
    private final WeakReference<FeatureFlagDelegate> mDelegate;
    private final FlagsConfig mFlagsConfig;
    private final String mFlagsEndpoint;
    private final RemoteService mHttpService;
    private final FeatureFlagHandler mHandler;
    private final ExecutorService mNetworkExecutor;
    private final Object mLock = new Object();
    private volatile Map<String, MixpanelFlagVariant> mFlags = null;
    private final Set<String> mTrackedFlags = new HashSet<String>();
    private boolean mIsFetching = false;
    private List<FlagCompletionCallback<Boolean>> mFetchCompletionCallbacks = new ArrayList<FlagCompletionCallback<Boolean>>();
    private volatile FetchTiming mFetchTiming = FetchTiming.neverFetched();
    private static final int MSG_FETCH_FLAGS_IF_NEEDED = 0;
    private static final int MSG_COMPLETE_FETCH = 1;

    public FeatureFlagManager(@NonNull FeatureFlagDelegate delegate, @NonNull RemoteService httpService, @NonNull FlagsConfig flagsConfig) {
        this.mDelegate = new WeakReference<FeatureFlagDelegate>(delegate);
        this.mFlagsEndpoint = delegate.getMPConfig().getFlagsEndpoint();
        this.mHttpService = httpService;
        this.mFlagsConfig = flagsConfig;
        HandlerThread handlerThread = new HandlerThread("com.mixpanel.android.FeatureFlagManagerWorker", 1);
        handlerThread.start();
        this.mHandler = new FeatureFlagHandler(handlerThread.getLooper());
        this.mNetworkExecutor = Executors.newSingleThreadExecutor();
    }

    @Override
    public void loadFlags() {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areFlagsReady() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFlags != null;
        }
    }

    @Override
    @NonNull
    public MixpanelFlagVariant getVariantSync(@NonNull String flagName, @NonNull MixpanelFlagVariant fallback) {
        if (!this.areFlagsReady()) {
            MPLog.w(LOGTAG, "Flags not ready for getVariantSync call for '" + flagName + "'. Returning fallback.");
            return fallback;
        }
        var resultContainer = new Object(){
            MixpanelFlagVariant flagVariant = null;
            boolean tracked = false;
        };
        this.mHandler.runAndWait(() -> {
            if (this.mFlags == null) {
                MPLog.w(LOGTAG, "Flags became null unexpectedly in getVariantSync runnable.");
                return;
            }
            MixpanelFlagVariant variant = this.mFlags.get(flagName);
            if (variant != null) {
                resultContainer.flagVariant = variant;
                resultContainer.tracked = this._checkAndSetTrackedFlag(flagName);
            }
        });
        if (resultContainer.flagVariant != null) {
            if (resultContainer.tracked) {
                this._performTrackingDelegateCall(flagName, resultContainer.flagVariant);
            }
            return resultContainer.flagVariant;
        }
        MPLog.i(LOGTAG, "Flag '" + flagName + "' not found sync. Returning fallback.");
        return fallback;
    }

    @Override
    @Nullable
    public Object getVariantValueSync(@NonNull String flagName, @Nullable Object fallbackValue) {
        MixpanelFlagVariant fallbackVariant = new MixpanelFlagVariant("", fallbackValue);
        MixpanelFlagVariant resultVariant = this.getVariantSync(flagName, fallbackVariant);
        return resultVariant.value;
    }

    @Override
    public boolean isEnabledSync(@NonNull String flagName, boolean fallbackValue) {
        Object variantValue = this.getVariantValueSync(flagName, fallbackValue);
        return this._evaluateBooleanFlag(flagName, variantValue, fallbackValue);
    }

    @Override
    public void getVariant(@NonNull String flagName, @NonNull MixpanelFlagVariant fallback, @NonNull FlagCompletionCallback<MixpanelFlagVariant> completion) {
        this.mHandler.post(() -> {
            boolean flagsAreCurrentlyReady;
            boolean bl = flagsAreCurrentlyReady = this.mFlags != null;
            if (flagsAreCurrentlyReady) {
                MPLog.v(LOGTAG, "Flags ready. Checking for flag '" + flagName + "'");
                MixpanelFlagVariant flagVariant = this.mFlags.get(flagName);
                boolean needsTracking = flagVariant != null ? this._checkAndSetTrackedFlag(flagName) : false;
                MixpanelFlagVariant result = flagVariant != null ? flagVariant : fallback;
                MPLog.v(LOGTAG, "Found flag variant (or fallback): " + result.key + " -> " + result.value);
                new Handler(Looper.getMainLooper()).post(() -> {
                    completion.onComplete(result);
                    if (flagVariant != null && needsTracking) {
                        MPLog.v(LOGTAG, "Tracking needed for '" + flagName + "'.");
                        this._performTrackingDelegateCall(flagName, result);
                    }
                });
            } else {
                MPLog.i(LOGTAG, "Flags not ready, attempting fetch for getVariant call '" + flagName + "'...");
                this._fetchFlagsIfNeeded(success -> {
                    MPLog.v(LOGTAG, "Fetch completion received on main thread for '" + flagName + "'. Success: " + success);
                    if (success.booleanValue()) {
                        this.mHandler.post(() -> {
                            MPLog.v(LOGTAG, "Processing successful fetch result for '" + flagName + "' on handler thread.");
                            MixpanelFlagVariant fetchedVariant = this.mFlags != null ? this.mFlags.get(flagName) : null;
                            boolean tracked = fetchedVariant != null ? this._checkAndSetTrackedFlag(flagName) : false;
                            MixpanelFlagVariant finalResult = fetchedVariant != null ? fetchedVariant : fallback;
                            new Handler(Looper.getMainLooper()).post(() -> {
                                completion.onComplete(finalResult);
                                if (fetchedVariant != null && tracked) {
                                    this._performTrackingDelegateCall(flagName, finalResult);
                                }
                            });
                        });
                    } else {
                        MPLog.w(LOGTAG, "Fetch failed for '" + flagName + "'. Returning fallback.");
                        completion.onComplete(fallback);
                    }
                });
            }
        });
    }

    @Override
    public void getVariantValue(@NonNull String flagName, @Nullable Object fallbackValue, @NonNull FlagCompletionCallback<Object> completion) {
        MixpanelFlagVariant fallbackVariant = new MixpanelFlagVariant("", fallbackValue);
        this.getVariant(flagName, fallbackVariant, result -> completion.onComplete(result.value));
    }

    @Override
    public void isEnabled(@NonNull String flagName, boolean fallbackValue, @NonNull FlagCompletionCallback<Boolean> completion) {
        this.getVariantValue(flagName, fallbackValue, value -> {
            boolean isEnabled = this._evaluateBooleanFlag(flagName, value, fallbackValue);
            completion.onComplete(isEnabled);
        });
    }

    private void _fetchFlagsIfNeeded(@Nullable FlagCompletionCallback<Boolean> completion) {
        boolean shouldStartFetch = false;
        if (!this.mFlagsConfig.enabled) {
            MPLog.i(LOGTAG, "Feature flags are disabled, not fetching.");
            this.postCompletion(completion, false);
            return;
        }
        if (!this.mIsFetching) {
            this.mIsFetching = true;
            shouldStartFetch = true;
            if (completion != null) {
                this.mFetchCompletionCallbacks.add(completion);
            }
        } else {
            MPLog.d(LOGTAG, "Fetch already in progress, queueing completion handler.");
            if (completion != null) {
                this.mFetchCompletionCallbacks.add(completion);
            }
        }
        if (shouldStartFetch) {
            MPLog.d(LOGTAG, "Starting flag fetch (dispatching network request)...");
            this.mNetworkExecutor.execute(this::_performFetchRequest);
        }
    }

    private void _performFetchRequest() {
        String errorMessage;
        JSONObject responseJson;
        boolean success;
        long fetchStartNanos;
        block16: {
            fetchStartNanos = System.nanoTime();
            long fetchStartMillis = System.currentTimeMillis();
            MPLog.v(LOGTAG, "Performing fetch request on thread: " + Thread.currentThread().getName());
            success = false;
            responseJson = null;
            errorMessage = "Delegate or config not available";
            FeatureFlagDelegate delegate = (FeatureFlagDelegate)this.mDelegate.get();
            if (delegate == null) {
                MPLog.w(LOGTAG, "Delegate became null before network request could start.");
                this.postResultToHandler(false, null, errorMessage);
                return;
            }
            MPConfig config = delegate.getMPConfig();
            String distinctId = delegate.getDistinctId();
            String deviceId = delegate.getAnonymousId();
            if (distinctId == null) {
                MPLog.w(LOGTAG, "Distinct ID is null. Cannot fetch flags.");
                errorMessage = "Distinct ID is null.";
                this.postResultToHandler(false, null, errorMessage);
                return;
            }
            try {
                JSONObject contextJson = new JSONObject(this.mFlagsConfig.context.toString());
                contextJson.put("distinct_id", (Object)distinctId);
                if (deviceId != null) {
                    contextJson.put("device_id", (Object)deviceId);
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("context", contextJson.toString());
                params.put("token", delegate.getToken());
                params.put("mp_lib", "android");
                params.put("$lib_version", "8.2.5");
                MPLog.v(LOGTAG, "Request query parameters: " + ((Object)params).toString());
                String token = delegate.getToken();
                if (token == null || token.trim().isEmpty()) {
                    throw new IOException("Mixpanel token is missing or empty.");
                }
                String authString = token + ":";
                String base64Auth = Base64Coder.encodeString(authString);
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Authorization", "Basic " + base64Auth);
                RemoteService.RequestResult result = this.mHttpService.performRequest(RemoteService.HttpMethod.GET, this.mFlagsEndpoint, config.getProxyServerInteractor(), params, headers, null, config.getSSLSocketFactory());
                byte[] responseBytes = result.getResponse();
                if (responseBytes == null) {
                    errorMessage = "Received non-successful HTTP status or null response from flags endpoint.";
                    MPLog.w(LOGTAG, errorMessage);
                    break block16;
                }
                try {
                    String responseString = new String(responseBytes, "UTF-8");
                    MPLog.v(LOGTAG, "Flags response: " + responseString);
                    responseJson = new JSONObject(responseString);
                    if (responseJson.has("error")) {
                        errorMessage = "Mixpanel API returned error: " + responseJson.getString("error");
                        MPLog.e(LOGTAG, errorMessage);
                    } else {
                        success = true;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 not supported on this platform?", e);
                }
                catch (JSONException e) {
                    errorMessage = "Could not parse Mixpanel flags response";
                    MPLog.e(LOGTAG, errorMessage, e);
                }
            }
            catch (RemoteService.ServiceUnavailableException e) {
                errorMessage = "Mixpanel service unavailable";
                MPLog.w(LOGTAG, errorMessage, e);
            }
            catch (MalformedURLException e) {
                errorMessage = "Flags endpoint URL is malformed: " + this.mFlagsEndpoint;
                MPLog.e(LOGTAG, errorMessage, e);
            }
            catch (IOException e) {
                errorMessage = "Network error while fetching flags";
                MPLog.e(LOGTAG, errorMessage, e);
            }
            catch (JSONException e) {
                errorMessage = "Failed to construct request JSON";
                MPLog.e(LOGTAG, errorMessage, e);
            }
            catch (Exception e) {
                errorMessage = "Unexpected error during flag fetch";
                MPLog.e(LOGTAG, errorMessage, e);
            }
        }
        long fetchEndNanos = System.nanoTime();
        long fetchEndMillis = System.currentTimeMillis();
        long fetchLatencyMs = (fetchEndNanos - fetchStartNanos) / 1000000L;
        this.mFetchTiming = new FetchTiming(fetchEndMillis, fetchLatencyMs);
        this.postResultToHandler(success, responseJson, errorMessage);
    }

    private void postResultToHandler(boolean success, @Nullable JSONObject responseJson, @Nullable String errorMessage) {
        Bundle resultData = new Bundle();
        resultData.putBoolean("success", success);
        if (success && responseJson != null) {
            resultData.putString("responseJson", responseJson.toString());
        } else if (!success && errorMessage != null) {
            resultData.putString("errorMessage", errorMessage);
        }
        Message msg = this.mHandler.obtainMessage(1);
        msg.setData(resultData);
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void _completeFetch(boolean success, @Nullable JSONObject flagsResponseJson) {
        MPLog.d(LOGTAG, "Completing fetch request. Success: " + success);
        this.mIsFetching = false;
        List<FlagCompletionCallback<Boolean>> callbacksToCall = this.mFetchCompletionCallbacks;
        this.mFetchCompletionCallbacks = new ArrayList<FlagCompletionCallback<Boolean>>();
        if (success && flagsResponseJson != null) {
            Map<String, MixpanelFlagVariant> newFlags = JsonUtils.parseFlagsResponse(flagsResponseJson);
            Object object = this.mLock;
            synchronized (object) {
                this.mFlags = Collections.unmodifiableMap(newFlags);
            }
            MPLog.v(LOGTAG, "Flags updated: " + this.mFlags.size() + " flags loaded.");
        } else {
            MPLog.w(LOGTAG, "Flag fetch failed or response missing/invalid. Keeping existing flags (if any).");
        }
        if (!callbacksToCall.isEmpty()) {
            MPLog.d(LOGTAG, "Calling " + callbacksToCall.size() + " fetch completion handlers.");
            for (FlagCompletionCallback<Boolean> callback : callbacksToCall) {
                this.postCompletion(callback, success);
            }
        } else {
            MPLog.d(LOGTAG, "No fetch completion handlers to call.");
        }
    }

    private boolean _checkAndSetTrackedFlag(@NonNull String flagName) {
        if (!this.mTrackedFlags.contains(flagName)) {
            this.mTrackedFlags.add(flagName);
            return true;
        }
        return false;
    }

    private void _performTrackingDelegateCall(String flagName, MixpanelFlagVariant variant) {
        FeatureFlagDelegate delegate = (FeatureFlagDelegate)this.mDelegate.get();
        if (delegate == null) {
            MPLog.w(LOGTAG, "Delegate is null, cannot track $experiment_started.");
            return;
        }
        JSONObject properties = new JSONObject();
        try {
            properties.put("Experiment name", (Object)flagName);
            properties.put("Variant name", (Object)variant.key);
            properties.put("$experiment_type", (Object)"feature_flag");
            FetchTiming timing = this.mFetchTiming;
            if (timing.hasBeenFetched()) {
                properties.put("timeLastFetched", timing.timeLastFetched);
                properties.put("fetchLatencyMs", timing.fetchLatencyMs);
            }
            if (variant.experimentID != null) {
                properties.put("$experiment_id", (Object)variant.experimentID);
            }
            if (variant.isExperimentActive != null) {
                properties.put("$is_experiment_active", (Object)variant.isExperimentActive);
            }
            if (variant.isQATester != null) {
                properties.put("$is_qa_tester", (Object)variant.isQATester);
            }
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Failed to create JSON properties for $experiment_started event", e);
            return;
        }
        MPLog.v(LOGTAG, "Queueing $experiment_started event for dispatch: " + properties.toString());
        new Handler(Looper.getMainLooper()).post(() -> {
            FeatureFlagDelegate currentDelegate = (FeatureFlagDelegate)this.mDelegate.get();
            if (currentDelegate != null) {
                currentDelegate.track("$experiment_started", properties);
                MPLog.v(LOGTAG, "Tracked $experiment_started for " + flagName + " (dispatched to main)");
            } else {
                MPLog.w(LOGTAG, "Delegate was null when track call executed on main thread.");
            }
        });
    }

    private <T> void postCompletion(@Nullable FlagCompletionCallback<T> callback, T result) {
        if (callback != null) {
            new Handler(Looper.getMainLooper()).post(() -> callback.onComplete(result));
        }
    }

    private boolean _evaluateBooleanFlag(String flagName, Object variantValue, boolean fallbackValue) {
        if (variantValue instanceof Boolean) {
            return (Boolean)variantValue;
        }
        MPLog.w(LOGTAG, "Flag value for " + flagName + " not boolean: " + variantValue);
        return fallbackValue;
    }

    private static class FetchTiming {
        private static final long NEVER_FETCHED = -1L;
        final long timeLastFetched;
        final long fetchLatencyMs;

        private FetchTiming(long timeLastFetched, long fetchLatencyMs) {
            this.timeLastFetched = timeLastFetched;
            this.fetchLatencyMs = fetchLatencyMs;
        }

        static FetchTiming neverFetched() {
            return new FetchTiming(-1L, -1L);
        }

        boolean hasBeenFetched() {
            return this.timeLastFetched != -1L;
        }
    }

    private class FeatureFlagHandler
    extends Handler {
        public FeatureFlagHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(@NonNull Message msg) {
            switch (msg.what) {
                case 0: {
                    FeatureFlagManager.this._fetchFlagsIfNeeded(null);
                    break;
                }
                case 1: {
                    Bundle data = msg.getData();
                    boolean success = data.getBoolean("success");
                    String responseJsonString = data.getString("responseJson");
                    String errorMessage = data.getString("errorMessage");
                    JSONObject responseJson = null;
                    if (success && responseJsonString != null) {
                        try {
                            responseJson = new JSONObject(responseJsonString);
                        }
                        catch (JSONException e) {
                            MPLog.e(FeatureFlagManager.LOGTAG, "Could not parse response JSON string in completeFetch", e);
                            success = false;
                            errorMessage = "Failed to parse flags response JSON.";
                        }
                    }
                    if (!success && errorMessage != null) {
                        MPLog.w(FeatureFlagManager.LOGTAG, "Flag fetch failed: " + errorMessage);
                    }
                    FeatureFlagManager.this._completeFetch(success, responseJson);
                    break;
                }
                default: {
                    MPLog.e(FeatureFlagManager.LOGTAG, "Unknown message type " + msg.what);
                }
            }
        }

        public void runAndWait(Runnable r) {
            if (Thread.currentThread() == this.getLooper().getThread()) {
                r.run();
            } else {
                CountDownLatch latch = new CountDownLatch(1);
                this.post(() -> {
                    try {
                        r.run();
                    }
                    finally {
                        latch.countDown();
                    }
                });
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    MPLog.e(FeatureFlagManager.LOGTAG, "Interrupted waiting for handler task", e);
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

