/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.util;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import com.mixpanel.android.util.MPLog;
import com.mixpanel.android.util.MixpanelNetworkErrorListener;
import com.mixpanel.android.util.OfflineMode;
import com.mixpanel.android.util.ProxyServerInteractor;
import com.mixpanel.android.util.RemoteService;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HttpService
implements RemoteService {
    private final boolean shouldGzipRequestPayload;
    private final MixpanelNetworkErrorListener networkErrorListener;
    private static boolean sIsMixpanelBlocked;
    private static final int MIN_UNAVAILABLE_HTTP_RESPONSE_CODE = 500;
    private static final int MAX_UNAVAILABLE_HTTP_RESPONSE_CODE = 599;
    private static final String LOGTAG = "MixpanelAPI.Message";
    private static final int HTTP_OUTPUT_STREAM_BUFFER_SIZE = 8192;
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String GZIP_CONTENT_TYPE_HEADER = "gzip";

    public HttpService(boolean shouldGzipRequestPayload, MixpanelNetworkErrorListener networkErrorListener) {
        this.shouldGzipRequestPayload = shouldGzipRequestPayload;
        this.networkErrorListener = networkErrorListener;
    }

    public HttpService() {
        this(false, null);
    }

    @Override
    public void checkIsMixpanelBlocked() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    long startTimeNanos = System.nanoTime();
                    String host = "api.mixpanel.com";
                    InetAddress apiMixpanelInet = InetAddress.getByName(host);
                    boolean bl = sIsMixpanelBlocked = apiMixpanelInet.isLoopbackAddress() || apiMixpanelInet.isAnyLocalAddress();
                    if (sIsMixpanelBlocked) {
                        MPLog.v(HttpService.LOGTAG, "AdBlocker is enabled. Won't be able to use Mixpanel services.");
                        HttpService.this.onNetworkError(null, host, apiMixpanelInet.getHostAddress(), startTimeNanos, -1L, -1L, new IOException(host + " is blocked"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        t.start();
    }

    @Override
    @SuppressLint(value={"MissingPermission"})
    public boolean isOnline(Context context, OfflineMode offlineMode) {
        boolean isOnline;
        if (sIsMixpanelBlocked) {
            return false;
        }
        if (this.onOfflineMode(offlineMode)) {
            return false;
        }
        try {
            ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo netInfo = cm.getActiveNetworkInfo();
            if (netInfo == null) {
                isOnline = true;
                MPLog.v(LOGTAG, "A default network has not been set so we cannot be certain whether we are offline");
            } else {
                isOnline = netInfo.isConnectedOrConnecting();
                MPLog.v(LOGTAG, "ConnectivityManager says we " + (isOnline ? "are" : "are not") + " online");
            }
        }
        catch (SecurityException e) {
            isOnline = true;
            MPLog.v(LOGTAG, "Don't have permission to check connectivity, will assume we are online");
        }
        return isOnline;
    }

    private boolean onOfflineMode(OfflineMode offlineMode) {
        boolean onOfflineMode;
        try {
            onOfflineMode = offlineMode != null && offlineMode.isOffline();
        }
        catch (Exception e) {
            onOfflineMode = false;
            MPLog.v(LOGTAG, "Client State should not throw exception, will assume is not on offline mode", e);
        }
        return onOfflineMode;
    }

    @Override
    public byte[] performRequest(String endpointUrl, ProxyServerInteractor interactor, Map<String, Object> params, SSLSocketFactory socketFactory) throws RemoteService.ServiceUnavailableException, IOException {
        MPLog.v(LOGTAG, "Attempting request to " + endpointUrl);
        byte[] response = null;
        int retries = 0;
        boolean succeeded = false;
        while (retries < 3 && !succeeded) {
            InputStream in = null;
            OutputStream out = null;
            HttpURLConnection connection = null;
            String targetIpAddress = null;
            long startTimeNanos = System.nanoTime();
            long uncompressedBodySize = -1L;
            long compressedBodySize = -1L;
            try {
                Map<String, String> headers;
                URL url = new URL(endpointUrl);
                InetAddress inetAddress = InetAddress.getByName(url.getHost());
                targetIpAddress = inetAddress.getHostAddress();
                connection = (HttpURLConnection)url.openConnection();
                if (null != socketFactory && connection instanceof HttpsURLConnection) {
                    ((HttpsURLConnection)connection).setSSLSocketFactory(socketFactory);
                }
                if (interactor != null && HttpService.isProxyRequest(endpointUrl) && (headers = interactor.getProxyRequestHeaders()) != null) {
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        connection.setRequestProperty(entry.getKey(), entry.getValue());
                    }
                }
                connection.setConnectTimeout(2000);
                connection.setReadTimeout(30000);
                byte[] bodyBytesToSend = null;
                if (null != params) {
                    Uri.Builder builder = new Uri.Builder();
                    for (Map.Entry<String, Object> param : params.entrySet()) {
                        builder.appendQueryParameter(param.getKey(), param.getValue().toString());
                    }
                    String string = builder.build().getEncodedQuery();
                    byte[] originalBodyBytes = Objects.requireNonNull(string).getBytes(StandardCharsets.UTF_8);
                    uncompressedBodySize = originalBodyBytes.length;
                    if (this.shouldGzipRequestPayload) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try (GZIPOutputStream gzipOut = new GZIPOutputStream(baos);){
                            gzipOut.write(originalBodyBytes);
                        }
                        bodyBytesToSend = baos.toByteArray();
                        compressedBodySize = bodyBytesToSend.length;
                        connection.setRequestProperty(CONTENT_ENCODING_HEADER, GZIP_CONTENT_TYPE_HEADER);
                        connection.setFixedLengthStreamingMode(compressedBodySize);
                    } else {
                        bodyBytesToSend = originalBodyBytes;
                        connection.setFixedLengthStreamingMode(uncompressedBodySize);
                    }
                    connection.setDoOutput(true);
                    connection.setRequestMethod("POST");
                    out = connection.getOutputStream();
                    out.write(bodyBytesToSend);
                    out.flush();
                    out.close();
                    out = null;
                }
                if (interactor != null && HttpService.isProxyRequest(endpointUrl)) {
                    interactor.onProxyResponse(endpointUrl, connection.getResponseCode());
                }
                in = connection.getInputStream();
                response = HttpService.slurp(in);
                in.close();
                in = null;
                succeeded = true;
            }
            catch (EOFException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                MPLog.d(LOGTAG, "Failure to connect, likely caused by a known issue with Android lib. Retrying.");
                ++retries;
            }
            catch (IOException e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                if (connection != null && connection.getResponseCode() >= 500 && connection.getResponseCode() <= 599) {
                    throw new RemoteService.ServiceUnavailableException("Service Unavailable", connection.getHeaderField("Retry-After"));
                }
                throw e;
            }
            catch (Exception e) {
                this.onNetworkError(connection, endpointUrl, targetIpAddress, startTimeNanos, uncompressedBodySize, compressedBodySize, e);
                throw e;
            }
            finally {
                if (null != out) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {}
                }
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
                if (null == connection) continue;
                connection.disconnect();
            }
        }
        if (retries >= 3) {
            MPLog.v(LOGTAG, "Could not connect to Mixpanel service after three retries.");
        }
        return response;
    }

    private void onNetworkError(HttpURLConnection connection, String endpointUrl, String targetIpAddress, long startTimeNanos, long uncompressedBodySize, long compressedBodySize, Exception e) {
        if (this.networkErrorListener != null) {
            long endTimeNanos = System.nanoTime();
            long durationMillis = TimeUnit.NANOSECONDS.toMillis(endTimeNanos - startTimeNanos);
            int responseCode = -1;
            String responseMessage = "";
            if (connection != null) {
                try {
                    responseCode = connection.getResponseCode();
                    responseMessage = connection.getResponseMessage();
                }
                catch (Exception respExc) {
                    MPLog.w(LOGTAG, "Could not retrieve response code/message after error", respExc);
                }
            }
            String ip = targetIpAddress == null ? "N/A" : targetIpAddress;
            this.networkErrorListener.onNetworkError(endpointUrl, ip, durationMillis, uncompressedBodySize, compressedBodySize, responseCode, responseMessage, e);
        }
    }

    private OutputStream getBufferedOutputStream(OutputStream out) throws IOException {
        if (this.shouldGzipRequestPayload) {
            return new GZIPOutputStream((OutputStream)new BufferedOutputStream(out), 8192);
        }
        return new BufferedOutputStream(out);
    }

    private static boolean isProxyRequest(String endpointUrl) {
        return !endpointUrl.toLowerCase().contains("https://api.mixpanel.com".toLowerCase());
    }

    private static byte[] slurp(InputStream inputStream) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[8192];
        while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }
}

