/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.mpmetrics;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Looper;
import com.mixpanel.android.mpmetrics.SuperPropertyUpdate;
import com.mixpanel.android.util.MPLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"CommitPrefEdits"})
class PersistentIdentity {
    private final Future<SharedPreferences> mLoadStoredPreferences;
    private final Future<SharedPreferences> mLoadReferrerPreferences;
    private final Future<SharedPreferences> mTimeEventsPreferences;
    private final Future<SharedPreferences> mMixpanelPreferences;
    private final SharedPreferences.OnSharedPreferenceChangeListener mReferrerChangeListener;
    private JSONObject mSuperPropertiesCache;
    private final Object mSuperPropsLock = new Object();
    private Map<String, String> mReferrerPropertiesCache;
    private boolean mIdentitiesLoaded;
    private String mEventsDistinctId;
    private boolean mEventsUserIdPresent;
    private String mPeopleDistinctId;
    private String mAnonymousId;
    private boolean mHadPersistedDistinctId;
    private Boolean mIsUserOptOut;
    private static Integer sPreviousVersionCode;
    private static Boolean sIsFirstAppLaunch;
    private Map<String, Long> mTimeEventsCache = null;
    private final Object mTimeEventsCacheLock = new Object();
    private boolean mTimeEventsCacheLoading = false;
    private static boolean sReferrerPrefsDirty;
    private static final Object sReferrerPrefsLock;
    private static final String LOGTAG = "MixpanelAPI.PIdentity";

    public static String getPeopleDistinctId(SharedPreferences storedPreferences) {
        return storedPreferences.getString("people_distinct_id", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeReferrerPrefs(Context context, String preferencesName, Map<String, String> properties) {
        Object object = sReferrerPrefsLock;
        synchronized (object) {
            SharedPreferences referralInfo = context.getSharedPreferences(preferencesName, 0);
            SharedPreferences.Editor editor = referralInfo.edit();
            editor.clear();
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                editor.putString(entry.getKey(), entry.getValue());
            }
            PersistentIdentity.writeEdits(editor);
            sReferrerPrefsDirty = true;
        }
    }

    public PersistentIdentity(Future<SharedPreferences> referrerPreferences, Future<SharedPreferences> storedPreferences, Future<SharedPreferences> timeEventsPreferences, Future<SharedPreferences> mixpanelPreferences) {
        this.mLoadReferrerPreferences = referrerPreferences;
        this.mLoadStoredPreferences = storedPreferences;
        this.mTimeEventsPreferences = timeEventsPreferences;
        this.mMixpanelPreferences = mixpanelPreferences;
        this.mSuperPropertiesCache = null;
        this.mReferrerPropertiesCache = null;
        this.mIdentitiesLoaded = false;
        this.mReferrerChangeListener = (sharedPreferences, key) -> {
            Object object = sReferrerPrefsLock;
            synchronized (object) {
                this.readReferrerProperties();
                sReferrerPrefsDirty = false;
            }
        };
        this.preloadTimeEventsAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSuperPropertiesToObject(JSONObject ob) {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            JSONObject superProperties = this.getSuperPropertiesCache();
            Iterator superIter = superProperties.keys();
            while (superIter.hasNext()) {
                String key = (String)superIter.next();
                try {
                    ob.put(key, superProperties.get(key));
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Object read from one JSON Object cannot be written to another", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSuperProperties(SuperPropertyUpdate updates) {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            JSONObject oldPropCache = this.getSuperPropertiesCache();
            JSONObject copy = new JSONObject();
            try {
                Iterator keys = oldPropCache.keys();
                while (keys.hasNext()) {
                    String k = (String)keys.next();
                    Object v = oldPropCache.get(k);
                    copy.put(k, v);
                }
            }
            catch (JSONException e) {
                MPLog.e(LOGTAG, "Can't copy from one JSONObject to another", e);
                return;
            }
            JSONObject replacementCache = updates.update(copy);
            if (replacementCache == null) {
                MPLog.w(LOGTAG, "An update to Mixpanel's super properties returned null, and will have no effect.");
                return;
            }
            this.mSuperPropertiesCache = replacementCache;
            this.storeSuperProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSuperProperties(JSONObject superProperties) {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            JSONObject propCache = this.getSuperPropertiesCache();
            Iterator iter = superProperties.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                try {
                    propCache.put(key, superProperties.get(key));
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Exception registering super property.", e);
                }
            }
            this.storeSuperProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSuperProperty(String superPropertyName) {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            JSONObject propCache = this.getSuperPropertiesCache();
            propCache.remove(superPropertyName);
            this.storeSuperProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSuperPropertiesOnce(JSONObject superProperties) {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            JSONObject propCache = this.getSuperPropertiesCache();
            Iterator iter = superProperties.keys();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                if (propCache.has(key)) continue;
                try {
                    propCache.put(key, superProperties.get(key));
                }
                catch (JSONException e) {
                    MPLog.e(LOGTAG, "Exception registering super property.", e);
                }
            }
            this.storeSuperProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSuperProperties() {
        Object object = this.mSuperPropsLock;
        synchronized (object) {
            this.mSuperPropertiesCache = new JSONObject();
            this.storeSuperProperties();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getReferrerProperties() {
        Object object = sReferrerPrefsLock;
        synchronized (object) {
            if (sReferrerPrefsDirty || null == this.mReferrerPropertiesCache) {
                this.readReferrerProperties();
                sReferrerPrefsDirty = false;
            }
        }
        return this.mReferrerPropertiesCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearReferrerProperties() {
        Object object = sReferrerPrefsLock;
        synchronized (object) {
            try {
                SharedPreferences referrerPrefs = this.mLoadReferrerPreferences.get();
                SharedPreferences.Editor prefsEdit = referrerPrefs.edit();
                prefsEdit.clear();
                PersistentIdentity.writeEdits(prefsEdit);
            }
            catch (ExecutionException e) {
                MPLog.e(LOGTAG, "Cannot load referrer properties from shared preferences.", e.getCause());
            }
            catch (InterruptedException e) {
                MPLog.e(LOGTAG, "Cannot load referrer properties from shared preferences.", e);
            }
        }
    }

    public synchronized String getAnonymousId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mAnonymousId;
    }

    public synchronized boolean getHadPersistedDistinctId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mHadPersistedDistinctId;
    }

    public synchronized String getEventsDistinctId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mEventsDistinctId;
    }

    public synchronized String getEventsUserId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        if (this.mEventsUserIdPresent) {
            return this.mEventsDistinctId;
        }
        return null;
    }

    public synchronized void setAnonymousIdIfAbsent(String anonymousId) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        if (this.mAnonymousId != null) {
            return;
        }
        this.mAnonymousId = anonymousId;
        this.mHadPersistedDistinctId = true;
        this.writeIdentities();
    }

    public synchronized void setEventsDistinctId(String eventsDistinctId) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        this.mEventsDistinctId = eventsDistinctId;
        this.writeIdentities();
    }

    public synchronized void markEventsUserIdPresent() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        this.mEventsUserIdPresent = true;
        this.writeIdentities();
    }

    public synchronized String getPeopleDistinctId() {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        return this.mPeopleDistinctId;
    }

    public synchronized void setPeopleDistinctId(String peopleDistinctId) {
        if (!this.mIdentitiesLoaded) {
            this.readIdentities();
        }
        this.mPeopleDistinctId = peopleDistinctId;
        this.writeIdentities();
    }

    public synchronized void clearPreferences() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor prefsEdit = prefs.edit();
            prefsEdit.clear();
            PersistentIdentity.writeEdits(prefsEdit);
            this.readSuperProperties();
            this.readIdentities();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearTimedEvents() {
        try {
            SharedPreferences prefs = this.mTimeEventsPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.clear();
            PersistentIdentity.writeEdits(editor);
            Object object = this.mTimeEventsCacheLock;
            synchronized (object) {
                if (this.mTimeEventsCache != null) {
                    this.mTimeEventsCache.clear();
                }
            }
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Failed to clear time events", e);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Failed to clear time events", e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Long> getTimeEvents() {
        Object object = this.mTimeEventsCacheLock;
        synchronized (object) {
            if (this.mTimeEventsCache != null) {
                return new HashMap<String, Long>(this.mTimeEventsCache);
            }
            if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                HashMap<String, Long> emptyMap = new HashMap<String, Long>();
                if (!this.mTimeEventsCacheLoading) {
                    this.mTimeEventsCacheLoading = true;
                    new Thread(this::loadTimeEventsCache).start();
                }
                return emptyMap;
            }
            return this.loadTimeEventsCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> loadTimeEventsCache() {
        Object object = this.mTimeEventsCacheLock;
        synchronized (object) {
            if (this.mTimeEventsCache != null) {
                return new HashMap<String, Long>(this.mTimeEventsCache);
            }
            this.mTimeEventsCache = new HashMap<String, Long>();
            try {
                SharedPreferences prefs = this.mTimeEventsPreferences.get();
                Map allEntries = prefs.getAll();
                for (Map.Entry entry : allEntries.entrySet()) {
                    this.mTimeEventsCache.put((String)entry.getKey(), Long.valueOf(entry.getValue().toString()));
                }
            }
            catch (InterruptedException e) {
                MPLog.e(LOGTAG, "Failed to load time events", e);
            }
            catch (ExecutionException e) {
                MPLog.e(LOGTAG, "Failed to load time events", e.getCause());
            }
            finally {
                this.mTimeEventsCacheLoading = false;
            }
            return new HashMap<String, Long>(this.mTimeEventsCache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preloadTimeEventsAsync() {
        Object object = this.mTimeEventsCacheLock;
        synchronized (object) {
            if (this.mTimeEventsCache == null && !this.mTimeEventsCacheLoading) {
                this.mTimeEventsCacheLoading = true;
                new Thread(this::loadTimeEventsCache).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimedEvent(String timeEventName) {
        try {
            SharedPreferences prefs = this.mTimeEventsPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.remove(timeEventName);
            PersistentIdentity.writeEdits(editor);
            Object object = this.mTimeEventsCacheLock;
            synchronized (object) {
                if (this.mTimeEventsCache != null) {
                    this.mTimeEventsCache.remove(timeEventName);
                }
            }
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Failed to remove time event", e);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Failed to remove time event", e.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTimeEvent(String timeEventName, Long timeEventTimestamp) {
        try {
            SharedPreferences prefs = this.mTimeEventsPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.putLong(timeEventName, timeEventTimestamp.longValue());
            PersistentIdentity.writeEdits(editor);
            Object object = this.mTimeEventsCacheLock;
            synchronized (object) {
                if (this.mTimeEventsCache != null) {
                    this.mTimeEventsCache.put(timeEventName, timeEventTimestamp);
                }
            }
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Failed to add time event", e);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Failed to add time event", e.getCause());
        }
    }

    public synchronized boolean isNewVersion(String versionCode) {
        if (versionCode == null) {
            return false;
        }
        Integer version = Integer.valueOf(versionCode);
        try {
            SharedPreferences mixpanelPreferences;
            if (sPreviousVersionCode == null && (sPreviousVersionCode = Integer.valueOf((mixpanelPreferences = this.mMixpanelPreferences.get()).getInt("latest_version_code", -1))) == -1) {
                sPreviousVersionCode = version;
                SharedPreferences.Editor mixpanelPreferencesEditor = this.mMixpanelPreferences.get().edit();
                mixpanelPreferencesEditor.putInt("latest_version_code", version.intValue());
                PersistentIdentity.writeEdits(mixpanelPreferencesEditor);
            }
            if (sPreviousVersionCode < version) {
                SharedPreferences.Editor mixpanelPreferencesEditor = this.mMixpanelPreferences.get().edit();
                mixpanelPreferencesEditor.putInt("latest_version_code", version.intValue());
                PersistentIdentity.writeEdits(mixpanelPreferencesEditor);
                return true;
            }
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Couldn't write internal Mixpanel shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Couldn't write internal Mixpanel from shared preferences.", e);
        }
        return false;
    }

    public synchronized boolean isFirstLaunch(boolean dbExists, String token) {
        if (sIsFirstAppLaunch == null) {
            try {
                SharedPreferences mixpanelPreferences = this.mMixpanelPreferences.get();
                boolean hasLaunched = mixpanelPreferences.getBoolean("has_launched_" + token, false);
                if (hasLaunched) {
                    sIsFirstAppLaunch = false;
                } else {
                    sIsFirstAppLaunch = !dbExists;
                    if (!sIsFirstAppLaunch.booleanValue()) {
                        this.setHasLaunched(token);
                    }
                }
            }
            catch (InterruptedException | ExecutionException e) {
                sIsFirstAppLaunch = false;
            }
        }
        return sIsFirstAppLaunch;
    }

    public synchronized void setHasLaunched(String token) {
        try {
            SharedPreferences.Editor mixpanelPreferencesEditor = this.mMixpanelPreferences.get().edit();
            mixpanelPreferencesEditor.putBoolean("has_launched_" + token, true);
            PersistentIdentity.writeEdits(mixpanelPreferencesEditor);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Couldn't write internal Mixpanel shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Couldn't write internal Mixpanel shared preferences.", e);
        }
    }

    public synchronized void setOptOutTracking(boolean optOutTracking, String token) {
        this.mIsUserOptOut = optOutTracking;
        this.writeOptOutFlag(token);
    }

    public synchronized boolean getOptOutTracking(String token) {
        if (this.mIsUserOptOut == null) {
            this.readOptOutFlag(token);
            if (this.mIsUserOptOut == null) {
                this.mIsUserOptOut = false;
            }
        }
        return this.mIsUserOptOut;
    }

    private JSONObject getSuperPropertiesCache() {
        if (this.mSuperPropertiesCache == null) {
            this.readSuperProperties();
        }
        return this.mSuperPropertiesCache;
    }

    private void readSuperProperties() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            String props = prefs.getString("super_properties", "{}");
            MPLog.v(LOGTAG, "Loading Super Properties " + props);
            this.mSuperPropertiesCache = new JSONObject(props);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Cannot load superProperties from SharedPreferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Cannot load superProperties from SharedPreferences.", e);
        }
        catch (JSONException e) {
            MPLog.e(LOGTAG, "Cannot parse stored superProperties");
            this.storeSuperProperties();
        }
        finally {
            if (this.mSuperPropertiesCache == null) {
                this.mSuperPropertiesCache = new JSONObject();
            }
        }
    }

    private void readReferrerProperties() {
        this.mReferrerPropertiesCache = new HashMap<String, String>();
        try {
            SharedPreferences referrerPrefs = this.mLoadReferrerPreferences.get();
            referrerPrefs.unregisterOnSharedPreferenceChangeListener(this.mReferrerChangeListener);
            referrerPrefs.registerOnSharedPreferenceChangeListener(this.mReferrerChangeListener);
            Map prefsMap = referrerPrefs.getAll();
            for (Map.Entry entry : prefsMap.entrySet()) {
                String prefsName = (String)entry.getKey();
                Object prefsVal = entry.getValue();
                this.mReferrerPropertiesCache.put(prefsName, prefsVal.toString());
            }
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Cannot load referrer properties from shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Cannot load referrer properties from shared preferences.", e);
        }
    }

    private void storeSuperProperties() {
        if (this.mSuperPropertiesCache == null) {
            MPLog.e(LOGTAG, "storeSuperProperties should not be called with uninitialized superPropertiesCache.");
            return;
        }
        String props = this.mSuperPropertiesCache.toString();
        MPLog.v(LOGTAG, "Storing Super Properties " + props);
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("super_properties", props);
            PersistentIdentity.writeEdits(editor);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Cannot store superProperties in shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Cannot store superProperties in shared preferences.", e);
        }
    }

    private void readIdentities() {
        SharedPreferences prefs = null;
        try {
            prefs = this.mLoadStoredPreferences.get();
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Cannot read distinct ids from sharedPreferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Cannot read distinct ids from sharedPreferences.", e);
        }
        if (prefs == null) {
            return;
        }
        this.mEventsDistinctId = prefs.getString("events_distinct_id", null);
        this.mEventsUserIdPresent = prefs.getBoolean("events_user_id_present", false);
        this.mPeopleDistinctId = prefs.getString("people_distinct_id", null);
        this.mAnonymousId = prefs.getString("anonymous_id", null);
        this.mHadPersistedDistinctId = prefs.getBoolean("had_persisted_distinct_id", false);
        if (this.mEventsDistinctId == null) {
            this.mAnonymousId = UUID.randomUUID().toString();
            this.mEventsDistinctId = "$device:" + this.mAnonymousId;
            this.mEventsUserIdPresent = false;
            this.writeIdentities();
        }
        this.mIdentitiesLoaded = true;
    }

    private void readOptOutFlag(String token) {
        SharedPreferences prefs = null;
        try {
            prefs = this.mMixpanelPreferences.get();
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Cannot read opt out flag from sharedPreferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Cannot read opt out flag from sharedPreferences.", e);
        }
        if (prefs == null) {
            return;
        }
        this.mIsUserOptOut = prefs.getBoolean("opt_out_" + token, false);
    }

    private void writeOptOutFlag(String token) {
        try {
            SharedPreferences prefs = this.mMixpanelPreferences.get();
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putBoolean("opt_out_" + token, this.mIsUserOptOut.booleanValue());
            PersistentIdentity.writeEdits(prefsEditor);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Can't write opt-out shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Can't write opt-out shared preferences.", e);
        }
    }

    protected void removeOptOutFlag(String token) {
        try {
            SharedPreferences prefs = this.mMixpanelPreferences.get();
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.remove("opt_out_" + token);
            PersistentIdentity.writeEdits(prefsEditor);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Can't remove opt-out shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Can't remove opt-out shared preferences.", e);
        }
    }

    protected boolean hasOptOutFlag(String token) {
        try {
            SharedPreferences prefs = this.mMixpanelPreferences.get();
            return prefs.contains("opt_out_" + token);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Can't read opt-out shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Can't read opt-out shared preferences.", e);
        }
        return false;
    }

    private void writeIdentities() {
        try {
            SharedPreferences prefs = this.mLoadStoredPreferences.get();
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString("events_distinct_id", this.mEventsDistinctId);
            prefsEditor.putBoolean("events_user_id_present", this.mEventsUserIdPresent);
            prefsEditor.putString("people_distinct_id", this.mPeopleDistinctId);
            prefsEditor.putString("anonymous_id", this.mAnonymousId);
            prefsEditor.putBoolean("had_persisted_distinct_id", this.mHadPersistedDistinctId);
            PersistentIdentity.writeEdits(prefsEditor);
        }
        catch (ExecutionException e) {
            MPLog.e(LOGTAG, "Can't write distinct ids to shared preferences.", e.getCause());
        }
        catch (InterruptedException e) {
            MPLog.e(LOGTAG, "Can't write distinct ids to shared preferences.", e);
        }
    }

    private static void writeEdits(SharedPreferences.Editor editor) {
        editor.apply();
    }

    static {
        sReferrerPrefsDirty = true;
        sReferrerPrefsLock = new Object();
    }
}

