/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.util.Log;
import com.mixpanel.android.mpmetrics.MPConfig;

class FlipGesture
implements SensorEventListener {
    private int mTriggerState = -1;
    private int mFlipState = 0;
    private long mLastFlipTime = -1L;
    private final float[] mSmoothed = new float[3];
    private final OnFlipGestureListener mListener;
    private static final float MINIMUM_GRAVITY_FOR_FLIP = 7.8f;
    private static final float MAXIMUM_GRAVITY_FOR_FLIP = 11.8f;
    private static final long MINIMUM_UP_DOWN_DURATION = 250000000L;
    private static final long MINIMUM_CANCEL_DURATION = 1000000000L;
    private static final int FLIP_STATE_UP = -1;
    private static final int FLIP_STATE_NONE = 0;
    private static final int FLIP_STATE_DOWN = 1;
    private static final int TRIGGER_STATE_NONE = 0;
    private static final int TRIGGER_STATE_BEGIN = 1;
    private static final float ACCELEROMETER_SMOOTHING = 0.7f;
    private static final String LOGTAG = "MixpanelAPI.FlipGesture";

    public FlipGesture(OnFlipGestureListener listener) {
        this.mListener = listener;
    }

    public void onSensorChanged(SensorEvent event) {
        float[] smoothed = this.smoothXYZ(event.values);
        int oldFlipState = this.mFlipState;
        float totalGravitySquared = smoothed[0] * smoothed[0] + smoothed[1] * smoothed[1] + smoothed[2] * smoothed[2];
        float minimumGravitySquared = 60.840004f;
        float maximumGravitySquared = 139.24f;
        this.mFlipState = 0;
        if (smoothed[2] > 7.8f && smoothed[2] < 11.8f) {
            this.mFlipState = -1;
        }
        if (smoothed[2] < -7.8f && smoothed[2] > -11.8f) {
            this.mFlipState = 1;
        }
        if (totalGravitySquared < 60.840004f || totalGravitySquared > 139.24f) {
            this.mFlipState = 0;
        }
        if (oldFlipState != this.mFlipState) {
            this.mLastFlipTime = event.timestamp;
        }
        long flipDurationNanos = event.timestamp - this.mLastFlipTime;
        switch (this.mFlipState) {
            case 1: {
                if (flipDurationNanos <= 250000000L || this.mTriggerState != 0) break;
                if (MPConfig.DEBUG) {
                    Log.v((String)LOGTAG, (String)"Flip gesture begun");
                }
                this.mTriggerState = 1;
                break;
            }
            case -1: {
                if (flipDurationNanos <= 250000000L || this.mTriggerState != 1) break;
                if (MPConfig.DEBUG) {
                    Log.v((String)LOGTAG, (String)"Flip gesture completed");
                }
                this.mTriggerState = 0;
                this.mListener.onFlipGesture();
                break;
            }
            case 0: {
                if (flipDurationNanos <= 1000000000L || this.mTriggerState == 0) break;
                if (MPConfig.DEBUG) {
                    Log.v((String)LOGTAG, (String)"Flip gesture abandoned");
                }
                this.mTriggerState = 0;
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private float[] smoothXYZ(float[] samples) {
        for (int i = 0; i < 3; ++i) {
            float oldVal = this.mSmoothed[i];
            this.mSmoothed[i] = oldVal + 0.7f * (samples[i] - oldVal);
        }
        return this.mSmoothed;
    }

    public static interface OnFlipGestureListener {
        public void onFlipGesture();
    }
}

