/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.annotation.TargetApi;
import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Base64OutputStream;
import android.util.DisplayMetrics;
import android.util.JsonWriter;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.mixpanel.android.mpmetrics.MPConfig;
import com.mixpanel.android.viewcrawler.PropertyDescription;
import com.mixpanel.android.viewcrawler.UIThreadSet;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONObject;

@TargetApi(value=16)
class ViewSnapshot {
    private final List<PropertyDescription> mProperties;
    private final SparseArray<String> mIdsToNames;
    private final Handler mMainThreadHandler;
    private static final String LOGTAG = "MixpanelAPI.ViewSnapshot";

    public ViewSnapshot(List<PropertyDescription> properties, SparseArray<String> idsToNames) {
        this.mProperties = properties;
        this.mIdsToNames = idsToNames;
        this.mMainThreadHandler = new Handler(Looper.getMainLooper());
    }

    public void snapshots(UIThreadSet<Activity> liveActivities, OutputStream out) throws IOException {
        block8: {
            RootViewFinder finder = new RootViewFinder(liveActivities);
            FutureTask<List<RootViewInfo>> infoFuture = new FutureTask<List<RootViewInfo>>(finder);
            this.mMainThreadHandler.post(infoFuture);
            OutputStreamWriter writer = new OutputStreamWriter(out);
            try {
                List<RootViewInfo> infoList = infoFuture.get(1L, TimeUnit.SECONDS);
                int infoCount = infoList.size();
                writer.write("[");
                for (int i = 0; i < infoCount; ++i) {
                    if (i > 0) {
                        writer.write(",");
                    }
                    RootViewInfo info = infoList.get(i);
                    writer.write("{");
                    writer.write("\"activity\":");
                    writer.write(JSONObject.quote((String)info.activityName));
                    writer.write(",");
                    writer.write("\"scale\":");
                    writer.write(String.format("%s", Float.valueOf(info.scale)));
                    writer.write(",");
                    writer.write("\"serialized_objects\":");
                    JsonWriter j = new JsonWriter((Writer)writer);
                    j.beginObject();
                    j.name("rootObject").value((long)info.rootView.hashCode());
                    j.name("objects");
                    this.snapshotViewHierarchy(j, info.rootView);
                    j.endObject();
                    j.flush();
                    writer.write(",");
                    writer.write("\"screenshot\":");
                    writer.flush();
                    this.writeScreenshot(info.screenshot, out);
                    writer.write("}");
                }
                writer.write("]");
                writer.flush();
            }
            catch (InterruptedException e) {
                if (MPConfig.DEBUG) {
                    Log.d((String)LOGTAG, (String)"Screenshot interrupted, no screenshot will be sent.", (Throwable)e);
                }
            }
            catch (TimeoutException e) {
                if (MPConfig.DEBUG) {
                    Log.i((String)LOGTAG, (String)"Screenshot took more than 1 second to be scheduled and executed. No screenshot will be sent.", (Throwable)e);
                }
            }
            catch (ExecutionException e) {
                if (!MPConfig.DEBUG) break block8;
                Log.e((String)LOGTAG, (String)"Exception thrown during screenshot attempt", (Throwable)e);
            }
        }
    }

    List<PropertyDescription> getProperties() {
        return this.mProperties;
    }

    void snapshotViewHierarchy(JsonWriter j, View rootView) throws IOException {
        j.beginArray();
        this.snapshotView(j, rootView);
        j.endArray();
    }

    private void snapshotView(JsonWriter j, View view) throws IOException {
        View child;
        int i;
        int childCount;
        ViewGroup group;
        int viewId = view.getId();
        String viewIdName = -1 == viewId ? null : (String)this.mIdsToNames.get(viewId);
        j.beginObject();
        j.name("hashCode").value((long)view.hashCode());
        j.name("id").value((long)viewId);
        j.name("mp_id_name").value(viewIdName);
        CharSequence description = view.getContentDescription();
        if (null == description) {
            j.name("contentDescription").nullValue();
        } else {
            j.name("contentDescription").value(description.toString());
        }
        Object tag = view.getTag();
        if (null == tag) {
            j.name("tag").nullValue();
        } else if (tag instanceof CharSequence) {
            j.name("tag").value(tag.toString());
        }
        j.name("top").value((long)view.getTop());
        j.name("left").value((long)view.getLeft());
        j.name("width").value((long)view.getWidth());
        j.name("height").value((long)view.getHeight());
        j.name("scrollX").value((long)view.getScrollX());
        j.name("scrollY").value((long)view.getScrollY());
        j.name("visibility").value((long)view.getVisibility());
        float translationX = 0.0f;
        float translationY = 0.0f;
        if (Build.VERSION.SDK_INT >= 11) {
            translationX = view.getTranslationX();
            translationY = view.getTranslationY();
        }
        j.name("translationX").value((double)translationX);
        j.name("translationY").value((double)translationY);
        j.name("classes");
        j.beginArray();
        Class<?> klass = view.getClass();
        do {
            j.value(klass.getCanonicalName());
        } while ((klass = klass.getSuperclass()) != Object.class);
        j.endArray();
        this.addProperties(j, view);
        j.name("subviews");
        j.beginArray();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            childCount = group.getChildCount();
            for (i = 0; i < childCount; ++i) {
                child = group.getChildAt(i);
                if (null == child) continue;
                j.value((long)child.hashCode());
            }
        }
        j.endArray();
        j.endObject();
        if (view instanceof ViewGroup) {
            group = (ViewGroup)view;
            childCount = group.getChildCount();
            for (i = 0; i < childCount; ++i) {
                child = group.getChildAt(i);
                if (null == child) continue;
                this.snapshotView(j, child);
            }
        }
    }

    private void writeScreenshot(Bitmap screenshot, OutputStream out) throws IOException {
        if (null != screenshot && screenshot.getWidth() > 0 && screenshot.getHeight() > 0) {
            out.write(34);
            Base64OutputStream imageOut = new Base64OutputStream(out, 2);
            screenshot.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)imageOut);
            imageOut.flush();
            out.write(34);
        } else {
            out.write("null".getBytes());
        }
    }

    private void addProperties(JsonWriter j, View v) throws IOException {
        Class<?> viewClass = v.getClass();
        for (PropertyDescription desc : this.mProperties) {
            Object value;
            if (!desc.targetClass.isAssignableFrom(viewClass) || null == desc.accessor || null == (value = desc.accessor.applyMethod(v))) continue;
            if (value instanceof Number) {
                j.name(desc.name).value((Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                j.name(desc.name).value(((Boolean)value).booleanValue());
                continue;
            }
            j.name(desc.name).value(value.toString());
        }
    }

    private static class RootViewInfo {
        public final String activityName;
        public final View rootView;
        public Bitmap screenshot;
        public float scale;

        public RootViewInfo(String activityName, View rootView) {
            this.activityName = activityName;
            this.rootView = rootView;
            this.screenshot = null;
            this.scale = 1.0f;
        }
    }

    private static class RootViewFinder
    implements Callable<List<RootViewInfo>> {
        private final UIThreadSet<Activity> mLiveActivities;
        private final List<RootViewInfo> mRootViews;
        private final DisplayMetrics mDisplayMetrics;
        private final Paint mScalePaint;
        private final int mClientDensity = 160;

        public RootViewFinder(UIThreadSet<Activity> liveActivities) {
            this.mLiveActivities = liveActivities;
            this.mDisplayMetrics = new DisplayMetrics();
            this.mRootViews = new ArrayList<RootViewInfo>();
            this.mScalePaint = new Paint(2);
        }

        @Override
        public List<RootViewInfo> call() throws Exception {
            this.mRootViews.clear();
            Set<Activity> liveActivities = this.mLiveActivities.getAll();
            for (Activity a : liveActivities) {
                String activityName = a.getClass().getCanonicalName();
                View rootView = a.getWindow().getDecorView().getRootView();
                a.getWindowManager().getDefaultDisplay().getMetrics(this.mDisplayMetrics);
                RootViewInfo info = new RootViewInfo(activityName, rootView);
                this.mRootViews.add(info);
            }
            int viewCount = this.mRootViews.size();
            for (int i = 0; i < viewCount; ++i) {
                RootViewInfo info = this.mRootViews.get(i);
                this.takeScreenshot(info);
            }
            return this.mRootViews;
        }

        private void takeScreenshot(RootViewInfo info) {
            Boolean originalCacheState;
            Bitmap rawBitmap;
            View rootView;
            block17: {
                rootView = info.rootView;
                rawBitmap = null;
                try {
                    Method createSnapshot = View.class.getDeclaredMethod("createSnapshot", Bitmap.Config.class, Integer.TYPE, Boolean.TYPE);
                    createSnapshot.setAccessible(true);
                    rawBitmap = (Bitmap)createSnapshot.invoke((Object)rootView, Bitmap.Config.RGB_565, -1, false);
                }
                catch (NoSuchMethodException e) {
                    if (MPConfig.DEBUG) {
                        Log.v((String)ViewSnapshot.LOGTAG, (String)"Can't call createSnapshot, will use drawCache", (Throwable)e);
                    }
                }
                catch (IllegalArgumentException e) {
                    Log.d((String)ViewSnapshot.LOGTAG, (String)"Can't call createSnapshot with arguments", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"Exception when calling createSnapshot", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"Can't access createSnapshot, using drawCache", (Throwable)e);
                }
                catch (ClassCastException e) {
                    Log.e((String)ViewSnapshot.LOGTAG, (String)"createSnapshot didn't return a bitmap?", (Throwable)e);
                }
                originalCacheState = null;
                try {
                    if (null == rawBitmap) {
                        originalCacheState = rootView.isDrawingCacheEnabled();
                        rootView.setDrawingCacheEnabled(true);
                        rootView.buildDrawingCache(true);
                        rawBitmap = rootView.getDrawingCache();
                    }
                }
                catch (RuntimeException e) {
                    if (!MPConfig.DEBUG) break block17;
                    Log.v((String)ViewSnapshot.LOGTAG, (String)("Can't take a bitmap snapshot of view " + rootView + ", skipping for now."), (Throwable)e);
                }
            }
            float scale = 1.0f;
            Bitmap bitmap = null;
            if (null != rawBitmap) {
                int rawDensity = rawBitmap.getDensity();
                if (rawDensity != 0) {
                    scale = 160.0f / (float)rawDensity;
                }
                int rawWidth = rawBitmap.getWidth();
                int rawHeight = rawBitmap.getHeight();
                int destWidth = (int)((double)((float)rawBitmap.getWidth() * scale) + 0.5);
                int destHeight = (int)((double)((float)rawBitmap.getHeight() * scale) + 0.5);
                if (rawWidth > 0 && rawHeight > 0 && destWidth > 0 && destHeight > 0) {
                    try {
                        bitmap = Bitmap.createBitmap((int)destWidth, (int)destHeight, (Bitmap.Config)Bitmap.Config.RGB_565);
                        if (null != bitmap) {
                            bitmap.setDensity(160);
                            Canvas scaledCanvas = new Canvas(bitmap);
                            scaledCanvas.drawBitmap(rawBitmap, 0.0f, 0.0f, this.mScalePaint);
                        }
                    }
                    catch (OutOfMemoryError e) {
                        bitmap = null;
                    }
                }
            }
            if (null != originalCacheState && !originalCacheState.booleanValue()) {
                rootView.setDrawingCacheEnabled(false);
            }
            info.scale = scale;
            info.screenshot = bitmap;
        }
    }
}

