/*
 * Decompiled with CFR 0.152.
 */
package com.mixpanel.android.viewcrawler;

import android.util.Log;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class Caller {
    private final String mMethodName;
    private final Object[] mMethodArgs;
    private final Class[] mMethodTypes;
    private final Class mMethodResultType;
    private static final String LOGTAG = "MixpanelABTest.Caller";

    public Caller(String methodName, Object[] methodArgs, Class resultType) {
        this.mMethodName = methodName;
        this.mMethodArgs = methodArgs;
        this.mMethodResultType = resultType;
        this.mMethodTypes = new Class[this.mMethodArgs.length];
        for (int i = 0; i < this.mMethodArgs.length; ++i) {
            this.mMethodTypes[i] = this.mMethodArgs[i].getClass();
        }
    }

    public String toString() {
        return "[Caller " + this.mMethodName + "(" + this.mMethodArgs + ")" + "]";
    }

    public Object[] getArgs() {
        return this.mMethodArgs;
    }

    public Object applyMethod(View target) {
        Class<?> klass = target.getClass();
        for (Method method : klass.getMethods()) {
            Class resultType;
            Class assignType;
            String foundName = method.getName();
            Class<?>[] params = method.getParameterTypes();
            if (!foundName.equals(this.mMethodName) || params.length != this.mMethodArgs.length || !(assignType = Caller.assignableArgType(this.mMethodResultType)).isAssignableFrom(resultType = Caller.assignableArgType(method.getReturnType()))) continue;
            boolean assignable = true;
            for (int i = 0; i < params.length && assignable; ++i) {
                Class argumentType = Caller.assignableArgType(this.mMethodTypes[i]);
                Class paramType = Caller.assignableArgType(params[i]);
                assignable = paramType.isAssignableFrom(argumentType);
            }
            if (!assignable) continue;
            try {
                return method.invoke((Object)target, this.mMethodArgs);
            }
            catch (IllegalAccessException e) {
            }
            catch (InvocationTargetException e) {
                Log.e((String)LOGTAG, (String)("Method " + method.getName() + " threw an exception"), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    private static Class assignableArgType(Class type) {
        if (type == Integer.class) {
            type = Integer.TYPE;
        } else if (type == Float.class) {
            type = Float.TYPE;
        } else if (type == Double.class) {
            type = Double.TYPE;
        } else if (type == Boolean.class) {
            type = Boolean.TYPE;
        }
        return type;
    }
}

