/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.materialdrawer.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.core.view.ViewCompat;
import com.mikepenz.materialdrawer.R;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0016\u0018\u00002\u00020\u0001:\u0001<B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0012J\u0010\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020$H\u0014J\u0010\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020\u001bH\u0016J\u0010\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020.H\u0014J(\u0010/\u001a\u00020$2\u0006\u00100\u001a\u00020\u00072\u0006\u00101\u001a\u00020\u00072\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0014J(\u00104\u001a\u00020\u00122\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u00072\u0006\u00108\u001a\u00020\u0007H\u0014J\u000e\u00109\u001a\u00020$2\u0006\u0010:\u001a\u00020\u0007J\u0010\u0010;\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u001bH\u0014R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/mikepenz/materialdrawer/view/BezelImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mBlackPaint", "Landroid/graphics/Paint;", "mBounds", "Landroid/graphics/Rect;", "mBoundsF", "Landroid/graphics/RectF;", "mCacheBitmap", "Landroid/graphics/Bitmap;", "mCacheValid", "", "mCachedHeight", "mCachedWidth", "mDesaturateColorFilter", "Landroid/graphics/ColorMatrixColorFilter;", "mDrawCircularShadow", "mIsPressed", "mIsSelected", "mMaskDrawable", "Landroid/graphics/drawable/Drawable;", "mMaskedPaint", "mSelectorAlpha", "mSelectorColor", "mSelectorFilter", "Landroid/graphics/ColorFilter;", "mTempDesaturateColorFilter", "mTempSelectorFilter", "disableTouchFeedback", "", "disable", "dispatchTouchEvent", "event", "Landroid/view/MotionEvent;", "drawableStateChanged", "invalidateDrawable", "who", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "w", "h", "old_w", "old_h", "setFrame", "l", "t", "r", "b", "setSelectorColor", "selectorColor", "verifyDrawable", "CustomOutline", "materialdrawer"})
public class BezelImageView
extends AppCompatImageView {
    private final Paint mBlackPaint;
    private final Paint mMaskedPaint;
    private Rect mBounds;
    private RectF mBoundsF;
    private final Drawable mMaskDrawable;
    private boolean mDrawCircularShadow;
    private ColorMatrixColorFilter mDesaturateColorFilter;
    private final int mSelectorAlpha;
    private int mSelectorColor;
    private ColorFilter mSelectorFilter;
    private boolean mCacheValid;
    private Bitmap mCacheBitmap;
    private int mCachedWidth;
    private int mCachedHeight;
    private boolean mIsPressed;
    private boolean mIsSelected;
    private ColorMatrixColorFilter mTempDesaturateColorFilter;
    private ColorFilter mTempSelectorFilter;

    protected void onSizeChanged(int w, int h, int old_w, int old_h) {
        if (Build.VERSION.SDK_INT >= 21 && this.mDrawCircularShadow) {
            this.setOutlineProvider(new CustomOutline(w, h));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setFrame(int l, int t, int r, int b) {
        void it;
        boolean changed = super.setFrame(l, t, r, b);
        Rect rect = new Rect(0, 0, r - l, b - t);
        boolean bl = false;
        boolean bl2 = false;
        Rect rect2 = rect;
        BezelImageView bezelImageView = this;
        boolean bl3 = false;
        this.mBoundsF = new RectF((Rect)it);
        if (this.mMaskDrawable != null) {
            this.mMaskDrawable.setBounds((Rect)it);
        }
        Unit unit = Unit.INSTANCE;
        bezelImageView.mBounds = rect;
        if (changed) {
            this.mCacheValid = false;
        }
        return changed;
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Rect rect = this.mBounds;
        if (rect == null) {
            return;
        }
        Rect bounds = rect;
        int width = bounds.width();
        int height = bounds.height();
        if (width == 0 || height == 0) {
            return;
        }
        if (!this.mCacheValid || width != this.mCachedWidth || height != this.mCachedHeight || this.mIsSelected != this.mIsPressed) {
            if (width == this.mCachedWidth && height == this.mCachedHeight) {
                this.mCacheBitmap.eraseColor(0);
            } else {
                this.mCacheBitmap.recycle();
                Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(widt\u2026 Bitmap.Config.ARGB_8888)");
                this.mCacheBitmap = bitmap;
                this.mCachedWidth = width;
                this.mCachedHeight = height;
            }
            Canvas cacheCanvas = new Canvas(this.mCacheBitmap);
            if (this.mMaskDrawable != null) {
                int sc = cacheCanvas.save();
                this.mMaskDrawable.draw(cacheCanvas);
                if (this.mIsSelected) {
                    if (this.mSelectorFilter != null) {
                        this.mMaskedPaint.setColorFilter(this.mSelectorFilter);
                    } else {
                        this.mMaskedPaint.setColorFilter((ColorFilter)this.mDesaturateColorFilter);
                    }
                } else {
                    this.mMaskedPaint.setColorFilter((ColorFilter)null);
                }
                cacheCanvas.saveLayer(this.mBoundsF, this.mMaskedPaint, 31);
                super.onDraw(cacheCanvas);
                cacheCanvas.restoreToCount(sc);
            } else if (this.mIsSelected) {
                int sc = cacheCanvas.save();
                cacheCanvas.drawRect(0.0f, 0.0f, (float)this.mCachedWidth, (float)this.mCachedHeight, this.mBlackPaint);
                if (this.mSelectorFilter != null) {
                    this.mMaskedPaint.setColorFilter(this.mSelectorFilter);
                } else {
                    this.mMaskedPaint.setColorFilter((ColorFilter)this.mDesaturateColorFilter);
                }
                cacheCanvas.saveLayer(this.mBoundsF, this.mMaskedPaint, 31);
                super.onDraw(cacheCanvas);
                cacheCanvas.restoreToCount(sc);
            } else {
                super.onDraw(cacheCanvas);
            }
        }
        canvas.drawBitmap(this.mCacheBitmap, (float)bounds.left, (float)bounds.top, null);
        this.mIsPressed = this.isPressed();
    }

    public boolean dispatchTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.isClickable()) {
            this.mIsSelected = false;
            return super.onTouchEvent(event);
        }
        switch (event.getAction()) {
            case 0: {
                this.mIsSelected = true;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                this.mIsSelected = false;
                break;
            }
        }
        this.invalidate();
        return super.dispatchTouchEvent(event);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mMaskDrawable != null && this.mMaskDrawable.isStateful()) {
            this.mMaskDrawable.setState(this.getDrawableState());
        }
        if (this.isDuplicateParentStateEnabled()) {
            ViewCompat.postInvalidateOnAnimation((View)((View)this));
        }
    }

    public void invalidateDrawable(@NotNull Drawable who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        if (who == this.mMaskDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(who);
        }
    }

    protected boolean verifyDrawable(@NotNull Drawable who) {
        Intrinsics.checkNotNullParameter((Object)who, (String)"who");
        return who == this.mMaskDrawable || super.verifyDrawable(who);
    }

    public final void setSelectorColor(int selectorColor) {
        this.mSelectorColor = selectorColor;
        this.mSelectorFilter = (ColorFilter)new PorterDuffColorFilter(Color.argb((int)this.mSelectorAlpha, (int)Color.red((int)this.mSelectorColor), (int)Color.green((int)this.mSelectorColor), (int)Color.blue((int)this.mSelectorColor)), PorterDuff.Mode.SRC_ATOP);
        this.invalidate();
    }

    public final void disableTouchFeedback(boolean disable) {
        if (disable) {
            this.mTempDesaturateColorFilter = this.mDesaturateColorFilter;
            this.mTempSelectorFilter = this.mSelectorFilter;
            this.mSelectorFilter = null;
            this.mDesaturateColorFilter = null;
        } else {
            if (this.mTempDesaturateColorFilter != null) {
                this.mDesaturateColorFilter = this.mTempDesaturateColorFilter;
            }
            if (this.mTempSelectorFilter != null) {
                this.mSelectorFilter = this.mTempSelectorFilter;
            }
        }
    }

    @JvmOverloads
    public BezelImageView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.mDrawCircularShadow = true;
        this.mSelectorAlpha = 150;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.BezelImageView, defStyle, R.style.BezelImageView);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026, R.style.BezelImageView)");
        TypedArray a = typedArray;
        this.mMaskDrawable = a.getDrawable(R.styleable.BezelImageView_materialDrawerMaskDrawable);
        if (this.mMaskDrawable != null) {
            this.mMaskDrawable.setCallback((Drawable.Callback)this);
        }
        this.mDrawCircularShadow = a.getBoolean(R.styleable.BezelImageView_materialDrawerDrawCircularShadow, true);
        this.mSelectorColor = a.getColor(R.styleable.BezelImageView_materialDrawerSelectorOnPress, 0);
        a.recycle();
        this.mBlackPaint = new Paint();
        this.mBlackPaint.setColor(-16777216);
        this.mMaskedPaint = new Paint();
        this.mMaskedPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        Bitmap bitmap = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888)");
        this.mCacheBitmap = bitmap;
        ColorMatrix cm = new ColorMatrix();
        cm.setSaturation(0.0f);
        this.mDesaturateColorFilter = new ColorMatrixColorFilter(cm);
        if (this.mSelectorColor != 0) {
            this.mSelectorFilter = (ColorFilter)new PorterDuffColorFilter(Color.argb((int)this.mSelectorAlpha, (int)Color.red((int)this.mSelectorColor), (int)Color.green((int)this.mSelectorColor), (int)Color.blue((int)this.mSelectorColor)), PorterDuff.Mode.SRC_ATOP);
        }
    }

    public /* synthetic */ BezelImageView(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public BezelImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public BezelImageView(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0083\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/mikepenz/materialdrawer/view/BezelImageView$CustomOutline;", "Landroid/view/ViewOutlineProvider;", "width", "", "height", "(Lcom/mikepenz/materialdrawer/view/BezelImageView;II)V", "getHeight$materialdrawer", "()I", "setHeight$materialdrawer", "(I)V", "getWidth$materialdrawer", "setWidth$materialdrawer", "getOutline", "", "view", "Landroid/view/View;", "outline", "Landroid/graphics/Outline;", "materialdrawer"})
    @TargetApi(value=21)
    private final class CustomOutline
    extends ViewOutlineProvider {
        private int width;
        private int height;

        public void getOutline(@NotNull View view, @NotNull Outline outline) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)outline, (String)"outline");
            outline.setOval(0, 0, this.width, this.height);
        }

        public final int getWidth$materialdrawer() {
            return this.width;
        }

        public final void setWidth$materialdrawer(int n) {
            this.width = n;
        }

        public final int getHeight$materialdrawer() {
            return this.height;
        }

        public final void setHeight$materialdrawer(int n) {
            this.height = n;
        }

        public CustomOutline(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }
}

