/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui;

import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.TextUtils;
import android.view.MenuItem;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.ui.LibsFragment;
import com.mikepenz.aboutlibraries.util.Colors;

public class LibsActivity
extends AppCompatActivity {
    public void onCreate(Bundle savedInstanceState) {
        ActionBar ab;
        boolean customTheme = false;
        Libs.ActivityStyle activityStyle = Libs.ActivityStyle.DARK;
        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            String style2;
            int themeId = bundle.getInt("ABOUT_LIBRARIES_THEME", -1);
            if (themeId != -1) {
                customTheme = true;
                this.setTheme(themeId);
            }
            if ((style2 = bundle.getString("ABOUT_LIBRARIES_STYLE")) != null) {
                activityStyle = Libs.ActivityStyle.valueOf(style2);
            }
        }
        if (!customTheme) {
            if (activityStyle == Libs.ActivityStyle.DARK) {
                this.setTheme(R.style.AboutLibrariesTheme);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT) {
                this.setTheme(R.style.AboutLibrariesTheme_Light);
            } else if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
                this.setTheme(R.style.AboutLibrariesTheme_Light_DarkToolbar);
            }
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_opensource);
        String title = "";
        if (bundle != null && bundle.containsKey("ABOUT_LIBRARIES_TITLE")) {
            title = bundle.getString("ABOUT_LIBRARIES_TITLE");
        }
        LibsFragment fragment = new LibsFragment();
        fragment.setArguments(bundle);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR) {
            toolbar.setTitleTextColor(-1);
            toolbar.setSubtitleTextColor(-1);
        }
        this.setSupportActionBar(toolbar);
        if (activityStyle == Libs.ActivityStyle.LIGHT_DARK_TOOLBAR && this.getSupportActionBar() != null) {
            Drawable upArrow = this.getResources().getDrawable(R.drawable.abc_ic_ab_back_mtrl_am_alpha);
            upArrow.setColorFilter(this.getResources().getColor(17170443), PorterDuff.Mode.SRC_ATOP);
            this.getSupportActionBar().setHomeAsUpIndicator(upArrow);
        }
        if ((ab = this.getSupportActionBar()) != null) {
            if (bundle != null && bundle.containsKey("ABOUT_COLOR")) {
                Colors colors = (Colors)bundle.getSerializable("ABOUT_COLOR");
                if (colors != null) {
                    ab.setBackgroundDrawable((Drawable)new ColorDrawable(colors.appBarColor));
                    if (Build.VERSION.SDK_INT >= 21) {
                        this.getWindow().setStatusBarColor(colors.statusBarColor);
                    }
                } else {
                    ab.setBackgroundDrawable(null);
                }
            }
            ab.setDisplayHomeAsUpEnabled(true);
            if (TextUtils.isEmpty((CharSequence)title)) {
                ab.setDisplayShowTitleEnabled(false);
            } else {
                ab.setDisplayShowTitleEnabled(true);
                ab.setTitle((CharSequence)title);
            }
        }
        FragmentManager fragmentManager = this.getSupportFragmentManager();
        fragmentManager.beginTransaction().replace(R.id.frame_container, (Fragment)fragment).commit();
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.finish();
                return true;
            }
        }
        return false;
    }
}

