/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.ui;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.widget.DefaultItemAnimator;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LayoutAnimationController;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.LibsBuilder;
import com.mikepenz.aboutlibraries.R;
import com.mikepenz.aboutlibraries.entity.Library;
import com.mikepenz.aboutlibraries.ui.adapter.LibsRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class LibsFragment
extends Fragment {
    private RecyclerView mRecyclerView;
    private LibsRecyclerViewAdapter mAdapter;
    LibsBuilder builder = null;
    private ArrayList<Library> libraries;
    private Comparator<Library> comparator;

    public void setLibraryComparator(Comparator<Library> comparator) {
        this.comparator = comparator;
    }

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        Bundle bundle = this.getArguments();
        if (bundle != null) {
            this.builder = (LibsBuilder)bundle.getSerializable("data");
        }
        Libs libs = this.builder.fields == null ? new Libs((Context)this.getActivity()) : new Libs((Context)this.getActivity(), this.builder.fields);
        this.builder.aboutShowIcon = this.extractBooleanBundleOrResource(libs, this.builder.aboutShowIcon, "aboutLibraries_description_showIcon");
        this.builder.aboutShowVersion = this.extractBooleanBundleOrResource(libs, this.builder.aboutShowVersion, "aboutLibraries_description_showVersion");
        this.builder.aboutShowVersionName = this.extractBooleanBundleOrResource(libs, this.builder.aboutShowVersionName, "aboutLibraries_description_showVersionName");
        this.builder.aboutShowVersionCode = this.extractBooleanBundleOrResource(libs, this.builder.aboutShowVersionCode, "aboutLibraries_description_showVersionCode");
        this.builder.aboutAppName = this.extractStringBundleOrResource(libs, this.builder.aboutAppName, "aboutLibraries_description_name");
        this.builder.aboutDescription = this.extractStringBundleOrResource(libs, this.builder.aboutDescription, "aboutLibraries_description_text");
        this.builder.aboutAppSpecial1 = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial1, "aboutLibraries_description_special1_name");
        this.builder.aboutAppSpecial1Description = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial1Description, "aboutLibraries_description_special1_text");
        this.builder.aboutAppSpecial2 = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial2, "aboutLibraries_description_special2_name");
        this.builder.aboutAppSpecial2Description = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial2Description, "aboutLibraries_description_special2_text");
        this.builder.aboutAppSpecial3 = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial3, "aboutLibraries_description_special3_name");
        this.builder.aboutAppSpecial3Description = this.extractStringBundleOrResource(libs, this.builder.aboutAppSpecial3Description, "aboutLibraries_description_special3_text");
        libs.modifyLibraries(this.builder.libraryModification);
        this.libraries = libs.prepareLibraries(this.builder.internalLibraries, this.builder.excludeLibraries, this.builder.autoDetect, this.builder.sort);
        if (this.comparator != null) {
            Collections.sort(this.libraries, this.comparator);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.fragment_opensource, container, false);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.cardListView);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this.getActivity()));
        this.mRecyclerView.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        this.mAdapter = new LibsRecyclerViewAdapter(this.builder);
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.generateAboutThisAppSection();
        return view;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        this.mAdapter.addLibs(this.libraries);
        if (this.builder.animate.booleanValue()) {
            Animation fadeIn = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)17432578);
            fadeIn.setDuration(500L);
            LayoutAnimationController layoutAnimationController = new LayoutAnimationController(fadeIn);
            this.mRecyclerView.setLayoutAnimation(layoutAnimationController);
            this.mRecyclerView.startLayoutAnimation();
        }
        super.onViewCreated(view, savedInstanceState);
    }

    private void generateAboutThisAppSection() {
        if (this.builder.aboutShowIcon != null && (this.builder.aboutShowVersion != null || this.builder.aboutShowVersionName != null || this.builder.aboutShowVersionCode.booleanValue())) {
            PackageManager pm = this.getActivity().getPackageManager();
            String packageName = this.getActivity().getPackageName();
            ApplicationInfo appInfo = null;
            PackageInfo packageInfo = null;
            try {
                appInfo = pm.getApplicationInfo(packageName, 0);
                packageInfo = pm.getPackageInfo(packageName, 0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Drawable icon = null;
            if (this.builder.aboutShowIcon.booleanValue() && appInfo != null) {
                icon = appInfo.loadIcon(pm);
            }
            String versionName = null;
            Integer versionCode = null;
            if (packageInfo != null) {
                versionName = packageInfo.versionName;
                versionCode = packageInfo.versionCode;
            }
            this.mAdapter.setHeader(versionName, versionCode, icon);
        }
    }

    private Boolean extractBooleanBundleOrResource(Libs libs, Boolean value, String resName) {
        Boolean result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                try {
                    result = Boolean.parseBoolean(descriptionShowVersion);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String extractStringBundleOrResource(Libs libs, String value, String resName) {
        String result = null;
        if (value != null) {
            result = value;
        } else {
            String descriptionShowVersion = libs.getStringResourceByName(resName);
            if (!TextUtils.isEmpty((CharSequence)descriptionShowVersion)) {
                result = descriptionShowVersion;
            }
        }
        return result;
    }
}

