/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans;

import com.midtrans.ConfigBuilder;
import com.midtrans.Midtrans;
import com.midtrans.proxy.ProxyConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class Config {
    private String serverKey;
    private String clientKey;
    private String irisMerchantKey;
    private boolean isProduction;
    private boolean enabledLog;
    private int connectionTimeout;
    private int readTimeout;
    private int writeTimeout;
    private int maxConnectionPool;
    private int keepAliveDuration;
    private TimeUnit httpClientTimeUnit;
    private String irisIdempotencyKey;
    private String paymentIdempotencyKey;
    private String xAppendNotification;
    private String xOverrideNotification;
    private ProxyConfig proxyConfig;
    private Map<String, String> customHeaders;

    public Config(String serverKey, String clientKey, boolean isProduction) {
        this.serverKey = serverKey;
        this.clientKey = clientKey;
        this.isProduction = isProduction;
        this.readTimeout = 10;
        this.writeTimeout = 10;
        this.connectionTimeout = 10;
        this.maxConnectionPool = 16;
        this.keepAliveDuration = 300;
    }

    public Config(String serverKey, String clientKey, boolean isProduction, int connectionTimeout, int readTimeout, int writeTimeout, int maxConnectionPool, int keepAliveDuration) {
        this.serverKey = serverKey;
        this.clientKey = clientKey;
        this.isProduction = isProduction;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.maxConnectionPool = maxConnectionPool;
        this.keepAliveDuration = keepAliveDuration;
    }

    public Config(String serverKey, String clientKey, boolean isProduction, int connectionTimeout, int readTimeout, int writeTimeout, int maxConnectionPool, int keepAliveDuration, ProxyConfig proxyConfig) {
        this.serverKey = serverKey;
        this.clientKey = clientKey;
        this.isProduction = isProduction;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.maxConnectionPool = maxConnectionPool;
        this.keepAliveDuration = keepAliveDuration;
        this.proxyConfig = proxyConfig;
    }

    public Config(String serverKey, String clientKey, boolean isProduction, boolean enabledLog, int connectionTimeout, int readTimeout, int writeTimeout, int maxConnectionPool, int keepAliveDuration, TimeUnit httpClientTimeUnit, String irisIdempotencyKey, String paymentIdempotencyKey, String xAppendNotification, String xOverrideNotification, ProxyConfig proxyConfig, Map<String, String> customHeaders) {
        this.serverKey = serverKey;
        this.clientKey = clientKey;
        this.isProduction = isProduction;
        this.enabledLog = enabledLog;
        this.connectionTimeout = connectionTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.maxConnectionPool = maxConnectionPool;
        this.keepAliveDuration = keepAliveDuration;
        this.httpClientTimeUnit = httpClientTimeUnit;
        this.irisIdempotencyKey = irisIdempotencyKey;
        this.paymentIdempotencyKey = paymentIdempotencyKey;
        this.xAppendNotification = xAppendNotification;
        this.xOverrideNotification = xOverrideNotification;
        this.proxyConfig = proxyConfig;
        this.customHeaders = customHeaders;
    }

    public static Config getGlobalConfig() {
        return new Config(Midtrans.getServerKey(), Midtrans.getClientKey(), Midtrans.isProduction(), Midtrans.enableLog(), Midtrans.getConnectTimeout(), Midtrans.getReadTimeout(), Midtrans.getWriteTimeout(), Midtrans.getMaxConnectionPool(), Midtrans.getKeepAliveDuration(), Midtrans.getHttpClientTimeUnit(), null, null, Midtrans.getPaymentAppendNotification(), Midtrans.getPaymentOverrideNotification(), Midtrans.getProxyConfig(), null);
    }

    public boolean isProduction() {
        return this.isProduction;
    }

    public String getSERVER_KEY() {
        return this.getServerKey();
    }

    public String getServerKey() {
        return this.serverKey;
    }

    public String getCLIENT_KEY() {
        return this.getClientKey();
    }

    public String getClientKey() {
        return this.clientKey;
    }

    public int getConnectionTimeout() {
        if (this.connectionTimeout < -1) {
            return 10;
        }
        return this.connectionTimeout;
    }

    public int getReadTimeout() {
        if (this.readTimeout < -1) {
            return 10;
        }
        return this.readTimeout;
    }

    public int getWriteTimeout() {
        if (this.writeTimeout < -1) {
            return 10;
        }
        return this.writeTimeout;
    }

    public int getMaxConnectionPool() {
        if (this.maxConnectionPool < -1) {
            return 16;
        }
        return this.maxConnectionPool;
    }

    public int getKeepAliveDuration() {
        if (this.keepAliveDuration < -1) {
            return 300;
        }
        return this.keepAliveDuration;
    }

    public TimeUnit getHttpClientTimeUnit() {
        return this.httpClientTimeUnit != null ? this.httpClientTimeUnit : TimeUnit.SECONDS;
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public boolean isEnabledLog() {
        return this.enabledLog;
    }

    public String getCoreApiURL() {
        if (this.isProduction) {
            this.setEnabledLog(false);
            return Midtrans.getProductionBaseUrl();
        }
        this.setEnabledLog(true);
        return Midtrans.getSandboxBaseUrl();
    }

    public String getSnapApiURL() {
        if (this.isProduction) {
            this.setEnabledLog(false);
            return Midtrans.getSnapProductionBaseUrl();
        }
        this.setEnabledLog(true);
        return Midtrans.getSnapSandboxBaseUrl();
    }

    public String getIrisApiURL() {
        if (this.isProduction) {
            this.setEnabledLog(false);
            return Midtrans.getIrisProductionBaseUrl();
        }
        this.setEnabledLog(true);
        return Midtrans.getIrisSandboxBaseUrl();
    }

    public String getIrisIdempotencyKey() {
        return this.irisIdempotencyKey;
    }

    public String getPaymentIdempotencyKey() {
        return this.paymentIdempotencyKey;
    }

    public String getPaymentAppendNotification() {
        return this.xAppendNotification;
    }

    public String getPaymentOverrideNotification() {
        return this.xOverrideNotification;
    }

    public String getIRIS_MERCHANT_KEY() {
        return this.getIrisMerchantKey();
    }

    public String getIrisMerchantKey() {
        return this.irisMerchantKey;
    }

    public void setSERVER_KEY(String SERVER_KEY) {
        this.setServerKey(SERVER_KEY);
    }

    public void setServerKey(String serverKey) {
        this.serverKey = serverKey;
    }

    public void setCLIENT_KEY(String CLIENT_KEY) {
        this.setClientKey(CLIENT_KEY);
    }

    public void setClientKey(String clientKey) {
        this.clientKey = clientKey;
    }

    public void setProduction(boolean production) {
        this.isProduction = production;
    }

    public void setEnabledLog(boolean enabledLog) {
        this.enabledLog = enabledLog;
    }

    public void setConnectionTimeout(int connectionTimeout, TimeUnit timeUnit) {
        this.connectionTimeout = connectionTimeout;
        this.httpClientTimeUnit = timeUnit;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.setConnectionTimeout(connectionTimeout, null);
    }

    public void setReadTimeout(int readTimeout, TimeUnit timeUnit) {
        this.readTimeout = readTimeout;
        this.httpClientTimeUnit = timeUnit;
    }

    public void setReadTimeout(int readTimeout) {
        this.setReadTimeout(readTimeout, null);
    }

    public void setWriteTimeout(int writeTimeout, TimeUnit timeUnit) {
        this.writeTimeout = writeTimeout;
        this.httpClientTimeUnit = timeUnit;
    }

    public void setWriteTimeout(int writeTimeout) {
        this.setWriteTimeout(writeTimeout, null);
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }

    public void setMaxConnectionPool(int maxConnectionPool) {
        this.maxConnectionPool = maxConnectionPool;
    }

    public void setKeepAliveDuration(int keepAliveDuration, TimeUnit timeUnit) {
        this.keepAliveDuration = keepAliveDuration;
        this.httpClientTimeUnit = timeUnit;
    }

    public void setKeepAliveDuration(int keepAliveDuration) {
        this.setKeepAliveDuration(keepAliveDuration, null);
    }

    public void setIrisIdempotencyKey(String irisIdempotencyKey) {
        this.irisIdempotencyKey = irisIdempotencyKey;
    }

    public void setPaymentIdempotencyKey(String paymentIdempotencyKey) {
        this.paymentIdempotencyKey = paymentIdempotencyKey;
    }

    public void paymentAppendNotification(String xAppendNotification) {
        this.xAppendNotification = xAppendNotification;
    }

    public void paymentOverrideNotification(String xOverrideNotification) {
        this.xOverrideNotification = xOverrideNotification;
    }

    @Deprecated
    public void setIRIS_MERCHANT_KEY(String IRIS_MERCHANT_KEY) {
        this.setIrisMerchantKey(IRIS_MERCHANT_KEY);
    }

    public void setIrisMerchantKey(String irisMerchantKey) {
        this.irisMerchantKey = irisMerchantKey;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public static ConfigBuilder builder() {
        return new ConfigBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config other = (Config)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverKey = this.getServerKey();
        String other$serverKey = other.getServerKey();
        if (this$serverKey == null ? other$serverKey != null : !this$serverKey.equals(other$serverKey)) {
            return false;
        }
        String this$clientKey = this.getClientKey();
        String other$clientKey = other.getClientKey();
        if (this$clientKey == null ? other$clientKey != null : !this$clientKey.equals(other$clientKey)) {
            return false;
        }
        String this$irisMerchantKey = this.getIrisMerchantKey();
        String other$irisMerchantKey = other.getIrisMerchantKey();
        if (this$irisMerchantKey == null ? other$irisMerchantKey != null : !this$irisMerchantKey.equals(other$irisMerchantKey)) {
            return false;
        }
        if (this.isProduction() != other.isProduction()) {
            return false;
        }
        if (this.isEnabledLog() != other.isEnabledLog()) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getReadTimeout() != other.getReadTimeout()) {
            return false;
        }
        if (this.getWriteTimeout() != other.getWriteTimeout()) {
            return false;
        }
        if (this.getMaxConnectionPool() != other.getMaxConnectionPool()) {
            return false;
        }
        if (this.getKeepAliveDuration() != other.getKeepAliveDuration()) {
            return false;
        }
        TimeUnit this$httpClientTimeUnit = this.getHttpClientTimeUnit();
        TimeUnit other$httpClientTimeUnit = other.getHttpClientTimeUnit();
        if (this$httpClientTimeUnit == null ? other$httpClientTimeUnit != null : !((Object)((Object)this$httpClientTimeUnit)).equals((Object)other$httpClientTimeUnit)) {
            return false;
        }
        String this$irisIdempotencyKey = this.getIrisIdempotencyKey();
        String other$irisIdempotencyKey = other.getIrisIdempotencyKey();
        if (this$irisIdempotencyKey == null ? other$irisIdempotencyKey != null : !this$irisIdempotencyKey.equals(other$irisIdempotencyKey)) {
            return false;
        }
        String this$paymentIdempotencyKey = this.getPaymentIdempotencyKey();
        String other$paymentIdempotencyKey = other.getPaymentIdempotencyKey();
        if (this$paymentIdempotencyKey == null ? other$paymentIdempotencyKey != null : !this$paymentIdempotencyKey.equals(other$paymentIdempotencyKey)) {
            return false;
        }
        String this$xAppendNotification = this.xAppendNotification;
        String other$xAppendNotification = other.xAppendNotification;
        if (this$xAppendNotification == null ? other$xAppendNotification != null : !this$xAppendNotification.equals(other$xAppendNotification)) {
            return false;
        }
        String this$xOverrideNotification = this.xOverrideNotification;
        String other$xOverrideNotification = other.xOverrideNotification;
        if (this$xOverrideNotification == null ? other$xOverrideNotification != null : !this$xOverrideNotification.equals(other$xOverrideNotification)) {
            return false;
        }
        ProxyConfig this$proxyConfig = this.getProxyConfig();
        ProxyConfig other$proxyConfig = other.getProxyConfig();
        if (this$proxyConfig == null ? other$proxyConfig != null : !this$proxyConfig.equals(other$proxyConfig)) {
            return false;
        }
        Map<String, String> this$customHeaders = this.getCustomHeaders();
        Map<String, String> other$customHeaders = other.getCustomHeaders();
        return !(this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Config;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serverKey = this.getServerKey();
        result = result * 59 + ($serverKey == null ? 43 : $serverKey.hashCode());
        String $clientKey = this.getClientKey();
        result = result * 59 + ($clientKey == null ? 43 : $clientKey.hashCode());
        String $irisMerchantKey = this.getIrisMerchantKey();
        result = result * 59 + ($irisMerchantKey == null ? 43 : $irisMerchantKey.hashCode());
        result = result * 59 + (this.isProduction() ? 79 : 97);
        result = result * 59 + (this.isEnabledLog() ? 79 : 97);
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getReadTimeout();
        result = result * 59 + this.getWriteTimeout();
        result = result * 59 + this.getMaxConnectionPool();
        result = result * 59 + this.getKeepAliveDuration();
        TimeUnit $httpClientTimeUnit = this.getHttpClientTimeUnit();
        result = result * 59 + ($httpClientTimeUnit == null ? 43 : ((Object)((Object)$httpClientTimeUnit)).hashCode());
        String $irisIdempotencyKey = this.getIrisIdempotencyKey();
        result = result * 59 + ($irisIdempotencyKey == null ? 43 : $irisIdempotencyKey.hashCode());
        String $paymentIdempotencyKey = this.getPaymentIdempotencyKey();
        result = result * 59 + ($paymentIdempotencyKey == null ? 43 : $paymentIdempotencyKey.hashCode());
        String $xAppendNotification = this.xAppendNotification;
        result = result * 59 + ($xAppendNotification == null ? 43 : $xAppendNotification.hashCode());
        String $xOverrideNotification = this.xOverrideNotification;
        result = result * 59 + ($xOverrideNotification == null ? 43 : $xOverrideNotification.hashCode());
        ProxyConfig $proxyConfig = this.getProxyConfig();
        result = result * 59 + ($proxyConfig == null ? 43 : $proxyConfig.hashCode());
        Map<String, String> $customHeaders = this.getCustomHeaders();
        result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
        return result;
    }
}

