/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.corekit.utilities;

import android.text.TextUtils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.midtrans.sdk.corekit.models.snap.params.CreditCardPaymentParams;
import java.io.IOException;

public class CustomTypeAdapter
extends TypeAdapter<CreditCardPaymentParams> {
    public void write(JsonWriter jsonWriter, CreditCardPaymentParams creditCardPaymentParams) throws IOException {
        jsonWriter.beginObject();
        if (creditCardPaymentParams.getMaskedCard() != null && !TextUtils.isEmpty((CharSequence)creditCardPaymentParams.getMaskedCard())) {
            jsonWriter.name("masked_card").value(creditCardPaymentParams.getMaskedCard());
        }
        if (creditCardPaymentParams.getBank() != null && !TextUtils.isEmpty((CharSequence)creditCardPaymentParams.getBank())) {
            jsonWriter.name("bank").value(creditCardPaymentParams.getBank());
        }
        if (creditCardPaymentParams.getCardToken() != null && !TextUtils.isEmpty((CharSequence)creditCardPaymentParams.getCardToken())) {
            jsonWriter.name("card_token").value(creditCardPaymentParams.getCardToken());
        }
        if (creditCardPaymentParams.getInstallmentTerm() != null && !TextUtils.isEmpty((CharSequence)creditCardPaymentParams.getInstallmentTerm())) {
            jsonWriter.name("installment").value(creditCardPaymentParams.getInstallmentTerm());
        }
        jsonWriter.name("save_card").value(creditCardPaymentParams.isSaveCard());
        if (creditCardPaymentParams.isFromBankPoint()) {
            if (creditCardPaymentParams.getPointRedeemed() == 0.0f) {
                jsonWriter.name("point").value(0L);
            } else {
                jsonWriter.name("point").value((double)creditCardPaymentParams.getPointRedeemed());
            }
        }
        jsonWriter.endObject();
    }

    public CreditCardPaymentParams read(JsonReader jsonReader) throws IOException {
        CreditCardPaymentParams creditCardPaymentParams = new CreditCardPaymentParams(null, null, null);
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            if ("masked_card".equals(string2)) {
                creditCardPaymentParams.setMaskedCard(jsonReader.nextString());
                continue;
            }
            if ("card_token".equals(string2)) {
                creditCardPaymentParams.setCardToken(jsonReader.nextString());
                continue;
            }
            if ("bank".equals(string2)) {
                creditCardPaymentParams.setBank(jsonReader.nextString());
                continue;
            }
            if ("installment".equals(string2)) {
                creditCardPaymentParams.setInstallmentTerm(jsonReader.nextString());
                continue;
            }
            if ("save_card".equals(string2)) {
                creditCardPaymentParams.setSaveCard(jsonReader.nextBoolean());
                continue;
            }
            if (!"point".equals(string2)) continue;
            creditCardPaymentParams.setPointRedeemed((float)jsonReader.nextDouble());
        }
        jsonReader.endObject();
        return creditCardPaymentParams;
    }
}

