/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.sdk.analytics;

import android.content.Context;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.google.gson.Gson;
import com.midtrans.sdk.analytics.MixpanelEvent;
import com.midtrans.sdk.analytics.MixpanelProperties;
import com.midtrans.sdk.analytics.a;
import com.midtrans.sdk.analytics.b;
import com.midtrans.sdk.analytics.c;
import java.sql.Timestamp;
import retrofit.Callback;
import retrofit.RetrofitError;
import retrofit.client.Response;

public class MixpanelAnalyticsManager {
    public static final String CORE_FLOW = "Core";
    public static final String UI_FLOW = "UI";
    public static final String WIDGET = "Widget";
    public static final String CARD_MODE_ONE_CLICK = "one click";
    public static final String CARD_MODE_TWO_CLICK = "two click";
    public static final String CARD_MODE_NORMAL = "normal";
    private static final String TAG = "MixpanelAnalytics";
    private static final String PLATFORM = "Android";
    private static final String EVENT_BUTTON_CLICKED = "Button Clicked";
    private static final String EVENT_PAGE_VIEWED = "Page Viewed";
    private final a mixpanelApi;
    private final String sdkVersion;
    private final String deviceId;
    private final String merchantName;
    private final String flow;
    private final String deviceType;
    private final boolean isLogEnabled;
    private Context context;

    public MixpanelAnalyticsManager(String string, String string2, String string3, String string4, String string5, boolean bl, Context context) {
        this.sdkVersion = string;
        this.deviceId = string2;
        this.merchantName = string3;
        this.flow = string4;
        this.deviceType = string5;
        this.isLogEnabled = bl;
        this.mixpanelApi = new b().a(bl);
        this.context = context;
    }

    private void trackEvent(MixpanelEvent mixpanelEvent) {
        if (this.mixpanelApi != null) {
            Gson gson = new Gson();
            String string = gson.toJson((Object)mixpanelEvent);
            if (this.isLogEnabled) {
                Log.d((String)TAG, (String)("Mixpanel log : " + string));
            }
            String string2 = Base64.encodeToString((byte[])string.getBytes(), (int)0);
            this.mixpanelApi.a(string2, new Callback<Integer>(){

                public void a(Integer n, Response response) {
                    if (MixpanelAnalyticsManager.this.isLogEnabled) {
                        Log.i((String)MixpanelAnalyticsManager.TAG, (String)("Response: " + Integer.toString(n)));
                    }
                }

                public void failure(RetrofitError retrofitError) {
                    if (MixpanelAnalyticsManager.this.isLogEnabled) {
                        Log.e((String)MixpanelAnalyticsManager.TAG, (String)("Response>error: " + retrofitError.getMessage()));
                    }
                }

                public /* synthetic */ void success(Object object, Response response) {
                    this.a((Integer)object, response);
                }
            });
        } else if (this.isLogEnabled) {
            Log.e((String)TAG, (String)"No network connection");
        }
    }

    public void trackMixpanel(String string, String string2, long l) {
        MixpanelEvent mixpanelEvent = new MixpanelEvent();
        mixpanelEvent.setEvent(string2);
        MixpanelProperties mixpanelProperties = this.initMixpanelProperties();
        mixpanelProperties.setResponseTime(l);
        mixpanelProperties.setDistinctId(string);
        mixpanelEvent.setProperties(mixpanelProperties);
        this.trackEvent(mixpanelEvent);
    }

    public void trackMixpanel(String string, String string2) {
        MixpanelEvent mixpanelEvent = new MixpanelEvent();
        mixpanelEvent.setEvent(string2);
        MixpanelProperties mixpanelProperties = this.initMixpanelProperties();
        mixpanelProperties.setDistinctId(string);
        mixpanelEvent.setProperties(mixpanelProperties);
        this.trackEvent(mixpanelEvent);
    }

    public void trackMixpanel(String string, String string2, String string3) {
        MixpanelEvent mixpanelEvent = new MixpanelEvent();
        mixpanelEvent.setEvent(string2);
        MixpanelProperties mixpanelProperties = this.initMixpanelProperties();
        mixpanelProperties.setDistinctId(string);
        mixpanelProperties.setCardPaymentMode(string3);
        mixpanelEvent.setProperties(mixpanelProperties);
        this.trackEvent(mixpanelEvent);
    }

    public void trackButtonClicked(String string, String string2, String string3) {
        MixpanelEvent mixpanelEvent = new MixpanelEvent();
        mixpanelEvent.setEvent(EVENT_BUTTON_CLICKED);
        MixpanelProperties mixpanelProperties = this.initMixpanelProperties();
        mixpanelProperties.setDistinctId(string);
        mixpanelProperties.setButtonName(string2);
        mixpanelProperties.setPageName(string3);
        mixpanelEvent.setProperties(mixpanelProperties);
        this.trackEvent(mixpanelEvent);
    }

    public void trackPageViewed(String string, String string2, boolean bl) {
        MixpanelEvent mixpanelEvent = new MixpanelEvent();
        mixpanelEvent.setEvent(EVENT_PAGE_VIEWED);
        MixpanelProperties mixpanelProperties = this.initMixpanelProperties();
        mixpanelProperties.setDistinctId(string);
        mixpanelProperties.setPageName(string2);
        mixpanelProperties.setFirstPage(bl);
        mixpanelEvent.setProperties(mixpanelProperties);
        this.trackEvent(mixpanelEvent);
    }

    private MixpanelProperties initMixpanelProperties() {
        MixpanelProperties mixpanelProperties = new MixpanelProperties();
        mixpanelProperties.setMerchant(this.merchantName);
        mixpanelProperties.setDeviceId(this.deviceId);
        mixpanelProperties.setVersion(this.sdkVersion);
        mixpanelProperties.setToken("0269722c477a0e085fde32e0248c6003");
        mixpanelProperties.setOsVersion(Build.VERSION.RELEASE);
        mixpanelProperties.setPlatform(PLATFORM);
        mixpanelProperties.setFlow(this.flow);
        mixpanelProperties.setDeviceType(this.deviceType);
        mixpanelProperties.setNetwork(c.a(this.context));
        mixpanelProperties.setTimeStamp(String.valueOf(new Timestamp(System.currentTimeMillis())));
        return mixpanelProperties;
    }
}

