/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Collection;

class AttestationResponse {
    private int totalSize;
    private int identitySize;
    private int healthReportSize;
    private int enclaveReportSize;
    private byte[] enclavePK;
    private byte[] healthReportCertificate;
    private byte[] enclaveReportPackage;
    private int sessionInfoSize;
    private byte[] sessionID = new byte[8];
    private int DHPKsize;
    private int DHPKSsize;
    private byte[] DHpublicKey;
    private byte[] publicKeySig;
    private X509Certificate healthCert;

    AttestationResponse(byte[] b) throws SQLServerException {
        ByteBuffer response = ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN);
        this.totalSize = response.getInt();
        this.identitySize = response.getInt();
        this.healthReportSize = response.getInt();
        this.enclaveReportSize = response.getInt();
        this.enclavePK = new byte[this.identitySize];
        this.healthReportCertificate = new byte[this.healthReportSize];
        this.enclaveReportPackage = new byte[this.enclaveReportSize];
        response.get(this.enclavePK, 0, this.identitySize);
        response.get(this.healthReportCertificate, 0, this.healthReportSize);
        response.get(this.enclaveReportPackage, 0, this.enclaveReportSize);
        this.sessionInfoSize = response.getInt();
        response.get(this.sessionID, 0, 8);
        this.DHPKsize = response.getInt();
        this.DHPKSsize = response.getInt();
        this.DHpublicKey = new byte[this.DHPKsize];
        this.publicKeySig = new byte[this.DHPKSsize];
        response.get(this.DHpublicKey, 0, this.DHPKsize);
        response.get(this.publicKeySig, 0, this.DHPKSsize);
        if (0 != response.remaining()) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_EnclaveResponseLengthError"), "0", false);
        }
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            this.healthCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(this.healthReportCertificate));
        }
        catch (CertificateException ce) {
            SQLServerException.makeFromDriverError(null, this, ce.getLocalizedMessage(), "0", false);
        }
    }

    void validateCert(byte[] b) throws SQLServerException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Collection<? extends Certificate> certs = cf.generateCertificates(new ByteArrayInputStream(b));
            for (X509Certificate x509Certificate : certs) {
                try {
                    this.healthCert.verify(x509Certificate.getPublicKey());
                    return;
                }
                catch (SignatureException signatureException) {
                }
            }
        }
        catch (GeneralSecurityException e) {
            SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "0", false);
        }
        SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_InvalidHealthCert"), "0", false);
    }

    void validateStatementSignature() throws SQLServerException, GeneralSecurityException {
        ByteBuffer enclaveReportPackageBuffer = ByteBuffer.wrap(this.enclaveReportPackage).order(ByteOrder.LITTLE_ENDIAN);
        int packageSize = enclaveReportPackageBuffer.getInt();
        int version = enclaveReportPackageBuffer.getInt();
        int signatureScheme = enclaveReportPackageBuffer.getInt();
        int signedStatementSize = enclaveReportPackageBuffer.getInt();
        int signatureSize = enclaveReportPackageBuffer.getInt();
        int reserved = enclaveReportPackageBuffer.getInt();
        byte[] signedStatement = new byte[signedStatementSize];
        enclaveReportPackageBuffer.get(signedStatement, 0, signedStatementSize);
        byte[] signatureBlob = new byte[signatureSize];
        enclaveReportPackageBuffer.get(signatureBlob, 0, signatureSize);
        if (enclaveReportPackageBuffer.remaining() != 0) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_EnclavePackageLengthError"), "0", false);
        }
        Signature sig = Signature.getInstance("RSASSA-PSS");
        PSSParameterSpec pss = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
        sig.setParameter(pss);
        sig.initVerify(this.healthCert);
        sig.update(signedStatement);
        if (!sig.verify(signatureBlob)) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_InvalidSignedStatement"), "0", false);
        }
    }

    void validateDHPublicKey() throws SQLServerException, GeneralSecurityException {
        ByteBuffer enclavePKBuffer = ByteBuffer.wrap(this.enclavePK).order(ByteOrder.LITTLE_ENDIAN);
        byte[] rsa1 = new byte[4];
        enclavePKBuffer.get(rsa1);
        int bitCount = enclavePKBuffer.getInt();
        int publicExponentLength = enclavePKBuffer.getInt();
        int publicModulusLength = enclavePKBuffer.getInt();
        int prime1 = enclavePKBuffer.getInt();
        int prime2 = enclavePKBuffer.getInt();
        byte[] exponent = new byte[publicExponentLength];
        enclavePKBuffer.get(exponent);
        byte[] modulus = new byte[publicModulusLength];
        enclavePKBuffer.get(modulus);
        if (enclavePKBuffer.remaining() != 0) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_EnclavePKLengthError"), "0", false);
        }
        RSAPublicKeySpec spec = new RSAPublicKeySpec(new BigInteger(1, modulus), new BigInteger(1, exponent));
        KeyFactory factory = KeyFactory.getInstance("RSA");
        PublicKey pub = factory.generatePublic(spec);
        Signature sig = Signature.getInstance("SHA256withRSA");
        sig.initVerify(pub);
        sig.update(this.DHpublicKey);
        if (!sig.verify(this.publicKeySig)) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_InvalidDHKeySignature"), "0", false);
        }
    }

    byte[] getDHpublicKey() {
        return this.DHpublicKey;
    }

    byte[] getSessionID() {
        return this.sessionID;
    }
}

