/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AttestationResponse;
import com.microsoft.sqlserver.jdbc.CekTableEntry;
import com.microsoft.sqlserver.jdbc.ColumnEncryptionVersion;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.DescribeParameterEncryptionResultSet1;
import com.microsoft.sqlserver.jdbc.DescribeParameterEncryptionResultSet2;
import com.microsoft.sqlserver.jdbc.EnclaveSession;
import com.microsoft.sqlserver.jdbc.ISQLServerEnclaveProvider;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerAeadAes256CbcHmac256Algorithm;
import com.microsoft.sqlserver.jdbc.SQLServerAeadAes256CbcHmac256EncryptionKey;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerEncryptionType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.VSMAttestationParameters;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;

public class SQLServerVSMEnclaveProvider
implements ISQLServerEnclaveProvider {
    private VSMAttestationParameters vsmParams = null;
    private AttestationResponse hgsResponse = null;
    private String attestationURL = null;
    private EnclaveSession enclaveSession = null;

    @Override
    public void getAttestationParameters(boolean createNewParameters, String url) throws SQLServerException {
        if (null == this.vsmParams || createNewParameters) {
            this.attestationURL = url;
            this.vsmParams = new VSMAttestationParameters();
        }
    }

    @Override
    public ArrayList<byte[]> createEnclaveSession(SQLServerConnection connection, String userSql, String preparedTypeDefinitions, Parameter[] params, ArrayList<String> parameterNames) throws SQLServerException {
        ArrayList<byte[]> b = this.describeParameterEncryption(connection, userSql, preparedTypeDefinitions, params, parameterNames);
        if (null != this.hgsResponse && !connection.enclaveEstablished()) {
            try {
                this.enclaveSession = new EnclaveSession(this.hgsResponse.getSessionID(), this.vsmParams.createSessionSecret(this.hgsResponse.getDHpublicKey()));
            }
            catch (GeneralSecurityException e) {
                SQLServerException.makeFromDriverError(connection, this, e.getLocalizedMessage(), "0", false);
            }
        }
        return b;
    }

    @Override
    public void invalidateEnclaveSession() {
        this.enclaveSession = null;
        this.vsmParams = null;
        this.attestationURL = null;
    }

    @Override
    public EnclaveSession getEnclaveSession() {
        return this.enclaveSession;
    }

    @Override
    public byte[] getEnclavePackage(String userSQL, ArrayList<byte[]> enclaveCEKs) throws SQLServerException {
        if (null != this.enclaveSession) {
            try {
                ByteArrayOutputStream enclavePackage = new ByteArrayOutputStream();
                enclavePackage.writeBytes(this.enclaveSession.getSessionID());
                ByteArrayOutputStream keys = new ByteArrayOutputStream();
                byte[] randomGUID = new byte[16];
                SecureRandom.getInstanceStrong().nextBytes(randomGUID);
                keys.writeBytes(randomGUID);
                keys.writeBytes(ByteBuffer.allocate(8).putLong(this.enclaveSession.getCounter()).array());
                keys.writeBytes(MessageDigest.getInstance("SHA-256").digest(userSQL.getBytes(StandardCharsets.UTF_16LE)));
                for (byte[] b : enclaveCEKs) {
                    keys.writeBytes(b);
                }
                enclaveCEKs.clear();
                SQLServerAeadAes256CbcHmac256EncryptionKey encryptedKey = new SQLServerAeadAes256CbcHmac256EncryptionKey(this.enclaveSession.getSessionSecret(), "AEAD_AES_256_CBC_HMAC_SHA256");
                SQLServerAeadAes256CbcHmac256Algorithm algo = new SQLServerAeadAes256CbcHmac256Algorithm(encryptedKey, SQLServerEncryptionType.Randomized, 1);
                enclavePackage.writeBytes(algo.encryptData(keys.toByteArray()));
                return enclavePackage.toByteArray();
            }
            catch (SQLServerException | GeneralSecurityException e) {
                SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "0", false);
            }
        }
        return null;
    }

    private AttestationResponse validateAttestationResponse(AttestationResponse ar) throws SQLServerException {
        try {
            byte[] attestationCerts = this.getAttestationCertificates();
            ar.validateCert(attestationCerts);
            ar.validateStatementSignature();
            ar.validateDHPublicKey();
        }
        catch (IOException | GeneralSecurityException e) {
            SQLServerException.makeFromDriverError(null, this, e.getLocalizedMessage(), "0", false);
        }
        return ar;
    }

    private byte[] getAttestationCertificates() throws IOException {
        URL url = new URL(this.attestationURL + "/attestationservice.svc/v2.0/signingCertificates/");
        URLConnection con = url.openConnection();
        String s = new String(con.getInputStream().readAllBytes());
        String[] bytesString = s.substring(1, s.length() - 1).split(",");
        byte[] certData = new byte[bytesString.length];
        for (int i = 0; i < certData.length; ++i) {
            certData[i] = (byte)Integer.parseInt(bytesString[i]);
        }
        return certData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<byte[]> describeParameterEncryption(SQLServerConnection connection, String userSql, String preparedTypeDefinitions, Parameter[] params, ArrayList<String> parameterNames) throws SQLServerException {
        ArrayList<byte[]> enclaveRequestedCEKs = new ArrayList<byte[]>();
        ResultSet rs = null;
        try (PreparedStatement stmt = connection.prepareStatement("EXEC sp_describe_parameter_encryption ?,?,?");){
            ((SQLServerPreparedStatement)stmt).isInternalEncryptionQuery = true;
            stmt.setNString(1, userSql);
            if (preparedTypeDefinitions != null && preparedTypeDefinitions.length() != 0) {
                stmt.setNString(2, preparedTypeDefinitions);
            } else {
                stmt.setNString(2, "");
            }
            stmt.setBytes(3, this.vsmParams.getBytes());
            rs = ((SQLServerPreparedStatement)stmt).executeQueryInternal();
            if (null == rs) {
                ArrayList<byte[]> arrayList = enclaveRequestedCEKs;
                return arrayList;
            }
            HashMap<Integer, CekTableEntry> cekList = new HashMap<Integer, CekTableEntry>();
            CekTableEntry cekEntry = null;
            boolean isRequestedByEnclave = false;
            try {
                while (rs.next()) {
                    int currentOrdinal = rs.getInt(DescribeParameterEncryptionResultSet1.KeyOrdinal.value());
                    if (!cekList.containsKey(currentOrdinal)) {
                        cekEntry = new CekTableEntry(currentOrdinal);
                        cekList.put(cekEntry.ordinal, cekEntry);
                    } else {
                        cekEntry = (CekTableEntry)cekList.get(currentOrdinal);
                    }
                    String keyStoreName = rs.getString(DescribeParameterEncryptionResultSet1.ProviderName.value());
                    String algo = rs.getString(DescribeParameterEncryptionResultSet1.KeyEncryptionAlgorithm.value());
                    String keyPath = rs.getString(DescribeParameterEncryptionResultSet1.KeyPath.value());
                    int dbID = rs.getInt(DescribeParameterEncryptionResultSet1.DbId.value());
                    byte[] mdVer = rs.getBytes(DescribeParameterEncryptionResultSet1.KeyMdVersion.value());
                    int keyID = rs.getInt(DescribeParameterEncryptionResultSet1.KeyId.value());
                    byte[] encryptedKey = rs.getBytes(DescribeParameterEncryptionResultSet1.EncryptedKey.value());
                    cekEntry.add(encryptedKey, dbID, keyID, rs.getInt(DescribeParameterEncryptionResultSet1.KeyVersion.value()), mdVer, keyPath, keyStoreName, algo);
                    if (ColumnEncryptionVersion.AE_v2.value() <= connection.getServerColumnEncryptionVersion().value()) {
                        isRequestedByEnclave = rs.getBoolean(DescribeParameterEncryptionResultSet1.IsRequestedByEnclave.value());
                    }
                    if (!isRequestedByEnclave) continue;
                    byte[] keySignature = rs.getBytes(DescribeParameterEncryptionResultSet1.EnclaveCMKSignature.value());
                    String serverName = connection.getTrustedServerNameAE();
                    SQLServerSecurityUtility.verifyColumnMasterKeyMetadata(connection, keyStoreName, keyPath, serverName, isRequestedByEnclave, keySignature);
                    ByteBuffer aev2CekEntry = ByteBuffer.allocate(46);
                    aev2CekEntry.order(ByteOrder.LITTLE_ENDIAN).putInt(dbID);
                    aev2CekEntry.put(mdVer);
                    aev2CekEntry.putShort((short)keyID);
                    aev2CekEntry.put(connection.getColumnEncryptionKeyStoreProvider(keyStoreName).decryptColumnEncryptionKey(keyPath, algo, encryptedKey));
                    enclaveRequestedCEKs.add(aev2CekEntry.array());
                }
            }
            catch (SQLException e) {
                if (!(e instanceof SQLServerException)) throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
                throw (SQLServerException)e;
            }
            if (!stmt.getMoreResults()) {
                throw new SQLServerException((Object)this, SQLServerException.getErrString("R_UnexpectedDescribeParamFormat"), null, 0, false);
            }
            try {
                rs = (SQLServerResultSet)stmt.getResultSet();
                while (rs.next() && null != params) {
                    String paramName = rs.getString(DescribeParameterEncryptionResultSet2.ParameterName.value());
                    int paramIndex = parameterNames.indexOf(paramName);
                    int cekOrdinal = rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncryptionKeyOrdinal.value());
                    cekEntry = (CekTableEntry)cekList.get(cekOrdinal);
                    if (null != cekEntry && cekList.size() < cekOrdinal) {
                        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidEncryptionKeyOridnal"));
                        Object[] msgArgs = new Object[]{cekOrdinal, cekEntry.getSize()};
                        throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                    }
                    SQLServerEncryptionType encType = SQLServerEncryptionType.of((byte)rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncrytionType.value()));
                    if (SQLServerEncryptionType.PlainText != encType) {
                        params[paramIndex].cryptoMeta = new CryptoMetadata(cekEntry, (short)cekOrdinal, (byte)rs.getInt(DescribeParameterEncryptionResultSet2.ColumnEncryptionAlgorithm.value()), null, encType.value, (byte)rs.getInt(DescribeParameterEncryptionResultSet2.NormalizationRuleVersion.value()));
                        SQLServerSecurityUtility.decryptSymmetricKey(params[paramIndex].cryptoMeta, connection);
                        continue;
                    }
                    if (!params[paramIndex].getForceEncryption()) continue;
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn"));
                    Object[] msgArgs = new Object[]{userSql, paramIndex + 1};
                    SQLServerException.makeFromDriverError(connection, this, form.format(msgArgs), "0", true);
                }
            }
            catch (SQLException e) {
                if (!(e instanceof SQLServerException)) throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
                throw (SQLServerException)e;
            }
            if (connection.isAEv2() && stmt.getMoreResults()) {
                rs = (SQLServerResultSet)stmt.getResultSet();
                while (rs.next()) {
                    this.hgsResponse = new AttestationResponse(rs.getBytes(1));
                    if (connection.enclaveEstablished()) continue;
                    this.hgsResponse = this.validateAttestationResponse(this.hgsResponse);
                }
            }
            rs.close();
            return enclaveRequestedCEKs;
        }
        catch (SQLException e) {
            if (!(e instanceof SQLServerException)) throw new SQLServerException(SQLServerException.getErrString("R_UnableRetrieveParameterMetadata"), null, 0, (Throwable)e);
            throw (SQLServerException)e;
        }
    }
}

