/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.BaseAttestationRequest;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResource;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

class VSMAttestationParameters
extends BaseAttestationRequest {
    private static byte[] ECDH_MAGIC = new byte[]{69, 67, 75, 51, 48, 0, 0, 0};
    private static byte[] ENCLAVE_TYPE = new byte[]{3, 0, 0, 0};
    private static byte[] ENCLAVE_CHALLENGE = new byte[]{0, 0, 0, 0};
    private static int ENCLAVE_LENGTH = 104;
    private byte[] x;
    private byte[] y;

    VSMAttestationParameters() throws SQLServerException {
        KeyPairGenerator kpg = null;
        try {
            kpg = KeyPairGenerator.getInstance("EC");
            kpg.initialize(new ECGenParameterSpec("secp384r1"));
        }
        catch (GeneralSecurityException e) {
            SQLServerException.makeFromDriverError(null, kpg, e.getLocalizedMessage(), "0", false);
        }
        KeyPair kp = kpg.generateKeyPair();
        ECPublicKey publicKey = (ECPublicKey)kp.getPublic();
        this.privateKey = kp.getPrivate();
        ECPoint w = publicKey.getW();
        this.x = w.getAffineX().toByteArray();
        this.y = w.getAffineY().toByteArray();
        if (this.x[0] == 0 && this.x.length != 48) {
            this.x = Arrays.copyOfRange(this.x, 1, this.x.length);
        }
        if (this.y[0] == 0 && this.y.length != 48) {
            this.y = Arrays.copyOfRange(this.y, 1, this.y.length);
        }
    }

    @Override
    byte[] getBytes() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        os.writeBytes(ENCLAVE_TYPE);
        os.writeBytes(ENCLAVE_CHALLENGE);
        os.writeBytes(ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(ENCLAVE_LENGTH).array());
        os.writeBytes(ECDH_MAGIC);
        os.writeBytes(this.x);
        os.writeBytes(this.y);
        return os.toByteArray();
    }

    byte[] createSessionSecret(byte[] serverResponse) throws GeneralSecurityException, SQLServerException {
        if (serverResponse.length != ENCLAVE_LENGTH) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_MalformedECDHPublicKey"), "0", false);
        }
        ByteBuffer sr = ByteBuffer.wrap(serverResponse);
        byte[] magic = new byte[8];
        sr.get(magic);
        if (!Arrays.equals(magic, ECDH_MAGIC)) {
            SQLServerException.makeFromDriverError(null, this, SQLServerResource.getResource("R_MalformedECDHHeader"), "0", false);
        }
        byte[] x = new byte[48];
        byte[] y = new byte[48];
        sr.get(x);
        sr.get(y);
        ECPublicKeySpec keySpec = new ECPublicKeySpec(new ECPoint(new BigInteger(1, x), new BigInteger(1, y)), ((ECPrivateKey)this.privateKey).getParams());
        KeyAgreement ka = KeyAgreement.getInstance("ECDH");
        ka.init(this.privateKey);
        ka.doPhase(KeyFactory.getInstance("EC").generatePublic(keySpec), true);
        return MessageDigest.getInstance("SHA-256").digest(ka.generateSecret());
    }
}

