package com.microsoft.sqlserver.jdbc;
import java.util.*;
public final class SQLServerResource_de extends ListResourceBundle
				  {
protected Object[][]  getContents()
{
return contents;
}


static final Object[][] contents =
{
{"R_timedOutBeforeRouting","Der Timeout ist abgelaufen, bevor eine Verbindung mit dem Routingziel hergestellt wurde."},
{"R_invalidRoutingInfo","Unerwartete Routinginformationen empfangen. Überprüfen Sie die Verbindungseigenschaften und die SQL Server-Konfiguration."},
{"R_multipleRedirections","Es sind mindestens zwei Umleitungen aufgetreten. Pro Anmeldeversuch ist nur eine Umleitung zulässig."},
{"R_dbMirroringWithMultiSubnetFailover","Das Herstellen einer Verbindung mit einer gespiegelten SQL Server-Instanz unter Verwendung der multiSubnetFailover-Verbindungseigenschaft wird nicht unterstützt."},
{"R_dbMirroringWithReadOnlyIntent","Das Herstellen einer Verbindung mit einer gespiegelten SQL Server-Instanz unter Verwendung der ApplicationIntent ReadOnly-Verbindungseigenschaft wird nicht unterstützt."},
{"R_ipAddressLimitWithMultiSubnetFailover","Das Herstellen einer Verbindung mit einer SQL Server-Instanz, für die mehr als {0} IP-Adressen konfiguriert sind, unter Verwendung der multiSubnetFailover-Verbindungseigenschaft wird nicht unterstützt."},
{"R_connectionTimedOut","Verbindungstimeout: Keine weiteren Informationen."},
{"R_invalidPositionIndex","Ungültiger Positionsindex: {0}."},
{"R_invalidLength","Ungültige Länge: {0}."},
{"R_unknownSSType","Ungültiger SQL Server-Datentyp {0}."},
{"R_unknownJDBCType","Ungültiger JDBC-Datentyp {0}."},
{"R_notSQLServer","Der Treiber hat eine unerwartete Antwort vor der Anmeldung erhalten. Überprüfen Sie die Verbindungseigenschaften, und stellen Sie sicher, dass eine SQL Server-Instanz auf dem Host ausgeführt wird, die TCP/IP-Verbindungen am Port annimmt. Dieser Treiber kann nur mit SQL Server 2005 oder höher verwendet werden."},
{"R_tcpOpenFailed","{0}. Überprüfen Sie die Verbindungseigenschaften. Stellen Sie sicher, dass eine SQL Server-Instanz auf dem Host ausgeführt wird und am Port TCP/IP-Verbindungen akzeptiert. Vergewissern Sie sich, dass am Port keine TCP-Verbindungen durch eine Firewall blockiert werden."},
{"R_unsupportedServerVersion","SQL Server, Version {0}, wird von diesem Treiber nicht unterstützt."},
{"R_noServerResponse","SQL Server hat keine Antwort zurückgegeben. Die Verbindung wurde geschlossen."},
{"R_truncatedServerResponse","SQL Server hat eine unvollständige Antwort zurückgegeben. Die Verbindung wurde geschlossen."},
{"R_queryTimedOut","Timeoutwert für Abfrage überschritten."},
{"R_queryCancelled","Die Abfrage wurde abgebrochen."},
{"R_errorReadingStream","Fehler beim Lesen des Werts aus dem Datenstromobjekt. Fehler: \"{0}\""},
{"R_streamReadReturnedInvalidValue","Beim Lesen des Datenstroms wurde ein ungültiger Wert für die gelesene Datenmenge zurückgegeben."},
{"R_mismatchedStreamLength","Der Datenstromwert hat nicht die angegebene Länge. Die angegebene Länge war {0}, die tatsächliche Länge ist {1}."},
{"R_notSupported","Dieser Vorgang wird nicht unterstützt."},
{"R_invalidOutputParameter","Index \"{0}\" des Ausgabeparameters ist ungültig."},
{"R_outputParameterNotRegisteredForOutput","Der Ausgabeparameter \"{0}\" wurde nicht für die Ausgabe registriert."},
{"R_parameterNotDefinedForProcedure","Parameter \"{0}\" für gespeicherte Prozedur \"{1}\" wurde nicht definiert."},
{"R_connectionIsClosed","Die Verbindung wurde geschlossen."},
{"R_invalidBooleanValue","Die {0}-Eigenschaft enthält keinen gültigen booleschen Wert. Es können nur \"true\" und \"false\" verwendet werden."},
{"R_propertyMaximumExceedsChars","Die {0}-Eigenschaft überschreitet die maximal zulässige Anzahl von {1} Zeichen."},
{"R_invalidPortNumber","Ungültige Portnummer: {0}."},
{"R_invalidTimeOut","Ungültiger Wert für ''timeout'': {0}."},
{"R_invalidLockTimeOut","Ungültiger Wert für \"lockTimeOut\": {0}."},
{"R_invalidAuthenticationScheme","Das authenticationScheme \"{0}\" ist ungültig."},
{"R_invalidPacketSize","Ungültiger Wert für \"packetSize\": {0}."},
{"R_packetSizeTooBigForSSL","Die SSL-Verschlüsselung kann bei einer Netzwerkpaketgröße von über {0} Bytes nicht verwendet werden. Überprüfen Sie die Verbindungseinstellungen und die SQL Server-Konfiguration."},
{"R_tcpipConnectionFailed","Fehler beim Herstellen der TCP/IP-Verbindung mit dem Host ''{0}'', Port {1}. Fehler: ''{2}''."},
{"R_invalidTransactionLevel","Ungültige Transaktionsebene: {0}."},
{"R_cantInvokeRollback","Wenn der AutoCommit-Modus auf \"true\" festgelegt wurde, können keine Rollbackvorgänge aufgerufen werden."},
{"R_cantSetSavepoint","Wenn der AutoCommit-Modus auf \"true\" festgelegt wurde, kann kein Sicherungspunkt (savepoint) gespeichert werden."},
{"R_sqlServerHoldability","SQL Server unterstützt die Holdability-Eigenschaft nur auf Verbindungsebene. Verwenden Sie die connection.setHoldability()-Methode."},
{"R_invalidHoldability","Der Holdability-Wert ''{0}'' ist ungültig."},
{"R_invalidColumnArrayLength","Ungültiges Spaltenarray. Der zulässige Wert für die Länge ist 1."},
{"R_valueNotSetForParameter","Wert für Parameternummer \"{0}\" wurde nicht festgelegt."},
{"R_sqlBrowserFailed","Fehler beim Herstellen einer Verbindung mit dem Host \"{0}\", benannte Instanz \"{1}\". Fehler: \"{2}\". Überprüfen Sie die Server- und Instanznamen, und stellen Sie sicher, dass der UDP-Datenverkehr an Port 1434 nicht von einer Firewall blockiert wird. Überprüfen Sie für SQL Server 2005 oder höher, ob der SQL Server Browser Dienst auf dem Host ausgeführt wird."},
{"R_notConfiguredToListentcpip","Server \"{0}\" wurde nicht für Überwachung mit TCP/IP konfiguriert."},
{"R_cantIdentifyTableMetadata","Tabelle \"{0}\" für die Metadaten konnte nicht ermittelt werden."},
{"R_metaDataErrorForParameter","Metadatenfehler für den Parameter \"{0}\"."},
{"R_invalidParameterNumber","Ungültige Parameternummer: {0}."},
{"R_noMetadata","Es sind keine Metadaten vorhanden."},
{"R_resultsetClosed","Das Resultset wurde geschlossen."},
{"R_invalidColumnName","Ungültiger Spaltenname: {0}."},
{"R_resultsetNotUpdatable","Das Resultset kann nicht aktualisiert werden."},
{"R_indexOutOfRange","Der Index \"{0}\" liegt außerhalb des gültigen Bereichs."},
{"R_savepointNotNamed","Der Sicherungspunkt (savepoint) wurde nicht benannt."},
{"R_savepointNamed","Der Sicherungspunkt (savepoint) \"{0}\" wurde benannt."},
{"R_resultsetNoCurrentRow","Das Resultset verfügt über keine aktuelle Zeile."},
{"R_mustBeOnInsertRow","Der Cursor befindet sich nicht in der Einfügezeile."},
{"R_mustNotBeOnInsertRow","Der angeforderte Vorgang kann in einer Einfügezeile nicht ausgeführt werden."},
{"R_cantUpdateDeletedRow","Eine gelöschte Zeile kann nicht aktualisiert werden."},
{"R_noResultset","Es wurde kein Resultset von der Anweisung zurückgegeben."},
{"R_resultsetGeneratedForUpdate","Es wurde ein Resultset für den Updatevorgang generiert."},
{"R_statementIsClosed","Die Anweisung wurde geschlossen."},
{"R_invalidRowcount","Die maximal zulässige Anzahl von Zeilen {0} für ein Resultset darf nicht negativ sein."},
{"R_invalidQueryTimeOutValue","Ungültiger Wert für Abfragetimeout: {0}."},
{"R_invalidFetchDirection","Ungültige Richtung für Abrufvorgang: {0}."},
{"R_invalidFetchSize","Die Größe der Datenmenge für den Abrufvorgang darf nicht negativ sein."},
{"R_noColumnParameterValue","Es wurden keine Spaltenparameterwerte zum Aktualisieren der Zeile angegeben."},
{"R_statementMustBeExecuted","Die Anweisung muss ausgeführt werden, bevor Ergebnisse abgerufen werden können."},
{"R_modeSuppliedNotValid","Der angegebene Modus ist ungültig."},
{"R_errorConnectionString","Die Verbindungszeichenfolge enthält einen falsch formatierten Namen oder Wert."},
{"R_errorProcessingComplexQuery","Fehler beim Verarbeiten der komplexen Abfrage."},
{"R_invalidOffset","Ungültiger Offset: {0}."},
{"R_nullConnection","Die Verbindungs-URL ist NULL."},
{"R_invalidConnection","Die Verbindungs-URL ist ungültig."},
{"R_cannotTakeArgumentsPreparedOrCallable","Die {0}-Methode kann \"PreparedStatement\" oder \"CallableStatement\" nicht mit Argumenten verwenden."},
{"R_unsupportedConversionFromTo","Die Konvertierung von \"{0}\" in \"{1}\" wird nicht unterstützt."},
{"R_unsupportedConversionTo","Die Konvertierung in \"{0}\" wird nicht unterstützt."},
{"R_errorConvertingValue","Fehler beim Konvertieren des Werts ''{0}'' in den JDBC-Datentyp ''{1}''."},
{"R_streamIsClosed","Der Datenstrom wurde geschlossen."},
{"R_invalidTDS","Ungültiger Datenstrom in TDS-Protokoll."},
{"R_unexpectedToken"," Unerwartetes token {0}."},
{"R_selectNotPermittedinBatch","SELECT-Anweisungen sind in einem Batch nicht zulässig."},
{"R_failedToCreateXAConnection","Fehler beim Herstellen der XA-Steuerungsverbindung. Fehler: ''{0}''."},
{"R_codePageNotSupported","Codepage \"{0}\" wird von der Java-Umgebung nicht unterstützt."},
{"R_unknownSortId","Die SQL Server-Sortierung {0} wird von diesem Treiber nicht unterstützt."},
{"R_unknownLCID","Die Windows-Sortierung {0} wird von diesem Treiber nicht unterstützt."},
{"R_encodingErrorWritingTDS","Codierungsfehler beim Schreiben einer Zeichenfolge in den TDS-Puffer. Fehler: ''{0}''."},
{"R_processingError","Verarbeitungsfehler \"{0}\"."},
{"R_requestedOpNotSupportedOnForward","Der angeforderte Vorgang wird für nur vorwärts gerichtete Resultsets nicht unterstützt."},
{"R_unsupportedCursor","Dieser Cursortyp wird nicht unterstützt."},
{"R_unsupportedCursorOperation","Der angeforderte Vorgang wird für diesen Cursortyp nicht unterstützt."},
{"R_unsupportedConcurrency","Vollständige Parallelität wird nicht unterstützt."},
{"R_unsupportedCursorAndConcurrency","Die angegebene Kombination von Cursortyp und vollständiger Parallelität wird nicht unterstützt."},
{"R_stringReadError","Fehler beim Lesen einer Zeichenfolge bei folgendem Offset: {0}."},
{"R_stringWriteError","Fehler beim Schreiben einer Zeichenfolge bei folgendem Offset: {0}."},
{"R_stringNotInHex","Das Hexadezimalformat der Zeichenfolge ist ungültig."},
{"R_unknownType","Der Javatyp \"{0}\" wird nicht unterstützt."},
{"R_physicalConnectionIsClosed","Die physische Verbindung wird für diese Poolverbindung geschlossen."},
{"R_invalidDataSourceReference","Ungültige DataSource-Referenz."},
{"R_cantGetColumnValueFromDeletedRow","Aus einer gelöschten Zeile kann kein Wert abgerufen werden."},
{"R_cantGetUpdatedColumnValue","Der Zugriff auf aktualisierte Spalten kann erst nach dem Aufrufen von updateRow() oder cancelRowUpdates() erfolgen."},
{"R_cantUpdateColumn","Der Spaltenwert kann nicht aktualisiert werden."},
{"R_positionedUpdatesNotSupported","Positionierte Update- und Löschvorgänge werden nicht unterstützt."},
{"R_invalidAutoGeneratedKeys","Ungültiger Wert für Parameter \"autoGeneratedKeys\": {0}. Nur die Werte \"Statement.RETURN_GENERATED_KEYS\" und \"Statement.NO_GENERATED_KEYS\" sind zulässig."},
{"R_notConfiguredForIntegrated","Dieser Treiber ist nicht für integrierte Authentifizierung konfiguriert."},
{"R_failoverPartnerWithoutDB","databaseName ist erforderlich, wenn die failoverPartner-Verbindungseigenschaft verwendet wird."},
{"R_invalidPartnerConfiguration","Die Datenbank \"{0}\" auf dem Server \"{1}\" ist nicht für das Spiegeln von Datenbanken konfiguriert."},
{"R_invaliddisableStatementPooling","Ungültiger Wert für \"disableStatementPooling\": {0}."},
{"R_invalidselectMethod","Ungültiger Wert für \"selectMethod\": {0}."},
{"R_invalidpropertyValue","Der Datentyp für die {0}-Verbindungseigenschaft ist ungültig. Alle Eigenschaften für diese Verbindung müssen vom Typ ''String'' sein."},
{"R_invalidArgument","Das {0}-Argument ist ungültig."},
{"R_streamWasNotMarkedBefore","Der Datenstrom wurde nicht markiert."},
{"R_invalidresponseBuffering","Die responseBuffering-Verbindungseigenschaft {0} ist ungültig."},
{"R_invalidapplicationIntent","Die applicationIntent-Verbindungseigenschaft {0} ist ungültig."},
{"R_dataAlreadyAccessed","Auf die Daten wurde zugegriffen; sie sind für diese Spalte oder diesen Parameter nicht verfügbar."},
{"R_outParamsNotPermittedinBatch","Die Parameter OUT und INOUT sind in einem Stapel nicht zulässig."},
{"R_sslRequiredNoServerSupport","Der Treiber konnte keine sichere Verbindung mit SQL Server über die SSL (Secure Sockets Layer)-Verschlüsselung herstellen. Von der Anwendung wurde eine Verschlüsselung angefordert, aber der Server ist für die Unterstützung von SSL nicht konfiguriert."},
{"R_sslRequiredByServer","Für die SQL Server-Anmeldung ist eine verschlüsselte Verbindung mit SSL (Secure Sockets Layer) erforderlich."},
{"R_sslFailed","Der Treiber konnte keine sichere Verbindung mit SQL Server über die SSL (Secure Sockets Layer)-Verschlüsselung herstellen. Fehler: ''{0}''."},
{"R_certNameFailed","Fehler bei der Überprüfung des Servernamens in einem Zertifikat während der SSL (Secure Sockets Layer)-Initialisierung."},
{"R_failedToInitializeXA","Fehler beim Initialisieren der gespeicherten Prozedur ''xp_sqljdbc_xa_init''. Status: ''{0}''. Fehler: ''{1}''."},
{"R_failedFunctionXA","Fehler bei der Funktion \"{0}\". Status: {1}. Fehler: \"{2}\""},
{"R_noTransactionCookie","Fehler bei der Funktion \"{0}\". Es wurde kein Transaktionscookie zurückgegeben."},
{"R_failedToEnlist","Fehler beim Eintragungsvorgang. Fehler: ''{0}''."},
{"R_failedToUnEnlist","Fehler beim Austragungsvorgang. Fehler: ''{0}''."},
{"R_failedToReadRecoveryXIDs","Fehler beim Lesen der XA-Verzweigungstransaktions-IDs für die Wiederherstellung (XIDs). Fehler: ''{0}''."},
{"R_userPropertyDescription","Der Datenbankbenutzer."},
{"R_passwordPropertyDescription","Das Datenbankkennwort."},
{"R_databaseNamePropertyDescription","Der Name der Datenbank, mit der eine Verbindung hergestellt werden soll."},
{"R_domainPropertyDescription","Die Windows-Domäne zur Authentifizierung mit NTLM."},
{"R_serverNamePropertyDescription","Der Computer, auf dem SQL Server ausgeführt wird."},
{"R_portNumberPropertyDescription","Der TCP-Port, auf dem eine SQL Server-Instanz lauscht."},
{"R_serverSpnPropertyDescription","Gibt den SQL Server-SPN an."},
{"R_columnEncryptionSettingPropertyDescription","Die Einstellung für die Spaltenverschlüsselung."},
{"R_serverNameAsACEPropertyDescription","Übersetzt den serverName von Unicode in ASCII Compatible Encoding (ACE) gemäß Definition durch den ToASCII-Vorgang von RFC 3490."},
{"R_sendStringParametersAsUnicodePropertyDescription","Bestimmt, ob die Zeichenfolgenparameter als Unicode-Zeichensatz oder als Zeichensatz der Datenbank an den Server gesendet werden sollen."},
{"R_multiSubnetFailoverPropertyDescription","Gibt an, dass die Anwendung eine Verbindung mit dem Availability Group Listener einer Availability Group oder einer Failover Cluster Instance herstellt."},
{"R_applicationNamePropertyDescription","Der Anwendungsname für SQL Server-Profilerstellungs- und -Protokollierungstools."},
{"R_lastUpdateCountPropertyDescription","Stellt sicher, dass nur der Wert für die letzte Updateanzahl von einer an den Server übergebenen SQL-Anweisung zurückgegeben wird."},
{"R_disableStatementPoolingPropertyDescription","Deaktiviert die Anweisungspoolingfunktion."},
{"R_integratedSecurityPropertyDescription","Gibt an, ob die Windows-Authentifizierung zum Herstellen einer Verbindung mit SQL Server verwendet werden soll."},
{"R_authenticationSchemePropertyDescription","Das für die integrierte Authentifizierung zu verwendende Authentifizierungsschema."},
{"R_lockTimeoutPropertyDescription","Die Wartezeit in Millisekunden, nach der die Datenbank ein Sperrtimeout melden soll."},
{"R_loginTimeoutPropertyDescription","Die Wartezeit in Sekunden, nach der der Treiber ein Timeout für eine fehlerhafte Verbindung ausführen soll."},
{"R_instanceNamePropertyDescription","Der Name der SQL Server-Instanz, mit der eine Verbindung hergestellt werden soll."},
{"R_xopenStatesPropertyDescription","Bestimmt, ob der Treiber XOPEN-kompatible SQL-Statuscodes in Ausnahmen zurückgeben soll."},
{"R_selectMethodPropertyDescription","Ermöglicht es der Anwendung, schreibgeschützte Vorwärtscursor-Resultsets mithilfe von Servercursorn zu verarbeiten."},
{"R_responseBufferingPropertyDescription","Steuert das adaptive Pufferungsverhalten, damit die Anwendung große Resultsets ohne Servercursor verarbeiten kann."},
{"R_applicationIntentPropertyDescription","Deklariert den Arbeitsauslastungstyp der Anwendung beim Herstellen einer Verbindung mit einem Server. Mögliche Werte sind ReadOnly und ReadWrite."},
{"R_workstationIDPropertyDescription","Der Hostname der Arbeitsstation."},
{"R_failoverPartnerPropertyDescription","Der Name des in einer Datenbank-Spiegelungskonfiguration verwendeten Failoverservers."},
{"R_packetSizePropertyDescription","Die für die Kommunikation mit SQL Server verwendete Netzwerkpaketgröße."},
{"R_encryptPropertyDescription","Bestimmt, ob zwischen dem Client und dem Server die SSL (Secure Sockets Layer)-Verschlüsselung verwendet werden soll."},
{"R_trustServerCertificatePropertyDescription","Bestimmt, ob der Treiber das SQL Server-SSL (Secure Sockets Layer)-Zertifikat überprüfen soll."},
{"R_trustStoreTypePropertyDescription","Der KeyStore-Typ."},
{"R_trustStorePropertyDescription","Der Pfad zur TrustStore-Datei für das Zertifikat."},
{"R_trustStorePasswordPropertyDescription","Das Kennwort zur Überprüfung der Integrität der Vertrauensspeicherdaten."},
{"R_trustManagerClassPropertyDescription","Die Klasse, die als TrustManager für SSL-Verbindungen instanziiert werden soll."},
{"R_trustManagerConstructorArgPropertyDescription","Das optionale Argument, das durch trustManagerClass an den Konstruktor übergeben wird."},
{"R_hostNameInCertificatePropertyDescription","Der bei der Überprüfung des SQL Server-SSL (Secure Sockets Layer)-Zertifikats zu verwendende Hostname."},
{"R_sendTimeAsDatetimePropertyDescription","Legt fest, ob zum Senden von java.sql.Time-Werten an die Datenbank der SQL Server-Datentyp \"datetime\" verwendet wird."},
{"R_TransparentNetworkIPResolutionPropertyDescription","Bestimmt, ob das Feature für die transparente Netzwerk-IP-Auflösung verwendet wird."},
{"R_queryTimeoutPropertyDescription","Die Wartezeit in Sekunden, nach der die Datenbank ein Abfragetimeout meldet."},
{"R_socketTimeoutPropertyDescription","Die Wartezeit in Millisekunden, bevor die java.net.SocketTimeoutException ausgelöst wird."},
{"R_serverPreparedStatementDiscardThresholdPropertyDescription","Der Schwellenwert für das Schließen verworfener PREPARE-Anweisungen auf dem Server (durch Aufrufen eines Batchs von \"sp_unprepare\"). Bei einem Wert von 1 oder weniger wird \"sp_unprepare\" beim Schließen von PreparedStatement sofort aufgerufen."},
{"R_enablePrepareOnFirstPreparedStatementCallPropertyDescription","Diese Einstellung legt fest, ob eine vorbereitete Anweisung (sp_prepexec) bei der ersten Verwendung (Eigenschaft=TRUE) oder bei der zweiten vorbereitet wird, nachdem zuerst \"sp_executesql\" aufgerufen wurde (Eigenschaft=FALSE)."},
{"R_statementPoolingCacheSizePropertyDescription","Diese Einstellung gibt die Größe des Caches für vorbereitete Anweisungen für eine Verbindung an. Bei einem Wert unter 1 wird kein Cache verwendet."},
{"R_gsscredentialPropertyDescription","GSS-Anmeldeinformation mit Identitätswechsel für den Zugriff auf SQL Server."},
{"R_msiClientIdPropertyDescription","Die Client-ID der benutzerseitig zugewiesenen verwalteten Identität, die zum Generieren des Zugriffstokens für die Azure AD-MSI-Authentifizierung verwendet wird."},
{"R_noParserSupport","Fehler beim Instanziieren des erforderlichen Parsers. Fehler: ''{0}''."},
{"R_writeOnlyXML","Aus dieser SQLXML-Instanz kann nicht gelesen werden. Die Instanz ist nur zum Schreiben von Daten vorgesehen."},
{"R_dataHasBeenReadXML","Aus dieser SQLXML-Instanz kann nicht gelesen werden. Die Daten wurden bereits gelesen."},
{"R_readOnlyXML","In diese SQLXML-Instanz kann nicht geschrieben werden. Die Instanz ist nur zum Lesen von Daten vorgesehen."},
{"R_dataHasBeenSetXML","In diese SQLXML-Instanz kann nicht geschrieben werden. Die Daten wurden bereits festgelegt."},
{"R_noDataXML","In dieser SQLXML-Instanz wurden keine Daten festgelegt."},
{"R_cantSetNull","Es kann kein NULL-Wert festgelegt werden."},
{"R_failedToParseXML","Fehler beim Analysieren des XML. Fehler: \"{0}\""},
{"R_isFreed","Das {0}-Objekt wurde freigegeben. Es ist kein Zugriff mehr darauf möglich."},
{"R_invalidProperty","Die Eigenschaft wird nicht unterstützt: {0}."},
{"R_referencingFailedTSP","Das DataSource-Kennwort \"trustStore\" muss festgelegt werden."},
{"R_valueOutOfRange","Für den SQL Server-Datentyp \"{0}\" liegt mindestens ein Wert außerhalb des gültigen Wertebereichs."},
{"R_valueOutOfRangeSQLType","Für den SQL-Typ \"{0}\" liegt mindestens ein Wert vor, der außerhalb des Gültigkeitsbereichs liegt."},
{"R_integratedAuthenticationFailed","Fehler bei der integrierten Authentifizierung."},
{"R_permissionDenied","Sicherheitsverletzung. Berechtigung für den Zugriff auf \"{0}\" verweigert."},
{"R_getSchemaError","Fehler beim Abrufen des Standardschemanamens."},
{"R_setSchemaWarning","Warnung: \"setSchema\" ist in dieser Treiberversion kein Vorgang."},
{"R_updateCountOutofRange","Der Updatezahlwert ist außerhalb des Bereichs."},
{"R_limitOffsetNotSupported","OFFSET-Klausel wird in beschränkter Escapesequenz nicht unterstützt."},
{"R_limitEscapeSyntaxError","Fehler in beschränkter Escapesyntax. Fehler bei der Abfrageanalyse."},
{"R_featureNotSupported","{0} wird nicht unterstützt."},
{"R_zoneOffsetError","Fehler beim Abrufen des Zonenoffsets."},
{"R_invalidMaxRows","Die unterstützte maximale Zeilenzahl für ein Resultset beträgt \" Integer.MAX_VALUE\" oder weniger."},
{"R_schemaMismatch","Quell- und Zielschemas stimmen nicht überein."},
{"R_invalidColumn","Spalte \"{0}\" ist ungültig. Bitte prüfen Sie die Spaltenzuordnungen."},
{"R_invalidDestinationTable","Der Name der Zieltabelle fehlt oder ist ungültig."},
{"R_unableRetrieveColMeta","Die Spaltenmetadaten können nicht abgerufen werden."},
{"R_invalidDestConnection","Die Zielverbindung muss eine vom Microsoft JDBC-Treiber für SQL Server ausgehende Verbindung sein."},
{"R_unableRetrieveSourceData","Es können keine Daten von der Quelle angerufen werden."},
{"R_ParsingError","Fehler beim Analysieren von Daten für den Typ \"{0}\"."},
{"R_BulkTypeNotSupported","Der Datentyp \"{0}\" wird beim Massenkopieren nicht unterstützt."},
{"R_BulkTypeNotSupportedDW","Der Datentyp \"{0}\" wird beim Massenkopieren für Azure Data Warehouse nicht unterstützt."},
{"R_invalidTransactionOption","Die Option \"UseInternalTransaction\" kann nicht auf TRUE festgelegt werden, wenn sie mit einem Connection-Objekt verwendet wird."},
{"R_invalidNegativeArg","Das Argument \"{0}\" darf nicht negativ sein."},
{"R_BulkColumnMappingsIsEmpty","Es kann keine Massenkopieren-Operation ausgeführt werden, wenn die einzige Zuordnung eine Identitätsspalte ist und \"KeepIdentity\" auf \"false\" festgelegt ist."},
{"R_DataSchemaMismatch","Die Quelldaten stimmen nicht mit dem Quellschema überein."},
{"R_BulkDataDuplicateColumn","Es sind keine doppelten Spaltennamen zulässig."},
{"R_invalidColumnOrdinal","Spalte \"{0}\" ist ungültig. Die Spaltennummer muss größer als null sein."},
{"R_unsupportedEncoding","Die Verschlüsselung \"{0}\" wird nicht unterstützt."},
{"R_UnexpectedDescribeParamFormat","Interner Fehler. Das Format des von \"sp_describe_parameter_encryption\" zurückgegebenen Resultsets ist ungültig. Eines der Resultsets fehlt."},
{"R_InvalidEncryptionKeyOridnal","Interner Fehler. Die Verschlüsselungsschlüssel-Ordnungszahl {0} der referenzierten Spalte fehlt in den Verschlüsselungsmetadaten, die von \"sp_describe_parameter_encryption\" zurückgegeben wurden. Die maximale Ordnungszahl ist {1}."},
{"R_MissingParamEncryptionMetadata","Interner Fehler. Metadaten für einige Parameter in Anweisung oder Prozedur \"{0}\" fehlen im Resultset, das von \"sp_describe_parameter_encryption\" zurückgegeben wird."},
{"R_UnableRetrieveParameterMetadata","Metadaten der Parameterverschlüsselung können nicht abgerufen werden."},
{"R_InvalidCipherTextSize","Angegebener Chiffretext weist eine ungültige Größe von {0} Bytes auf, die unter der für die Entschlüsselung erforderlichen Mindestanzahl von {1} Bytes liegt."},
{"R_InvalidAlgorithmVersion","Der Verschlüsselungsalgorithmus \"{0}\" des angegebenen Chiffretexts entspricht nicht der erwarteten Version \"{1}\"."},
{"R_InvalidAuthenticationTag","Der angegebene Chiffretext weist ein ungültiges Authentifizierungstag auf. "},
{"R_EncryptionFailed","Interner Fehler bei der Verschlüsselung: {0} "},
{"R_DecryptionFailed","Interner Fehler bei der Entschlüsselung: {0} "},
{"R_InvalidKeySize","Der Spaltenverschlüsselungsschlüssel wurde erfolgreich entschlüsselt. Seine Länge von {0} entspricht jedoch nicht der Länge von {1} für den Algorithmus \"{2}\". Prüfen Sie den verschlüsselten Wert des Spaltenverschlüsselungsschlüssels in der Datenbank."},
{"R_InvalidEncryptionType","Der für die Spalte in der Datenbank festgelegte Verschlüsselungstyp \"{0}\" ist entweder ungültig oder beschädigt. Gültige Verschlüsselungstypen für den Algorithmus \"{1}\" sind: \"{2}\"."},
{"R_UnknownColumnEncryptionAlgorithm","Der Algorithmus \"{0}\" ist nicht vorhanden. In der Factory registrierte Algorithmen sind {1}."},
{"R_KeyExtractionFailed","Fehler beim Extrahieren des Schlüssels: {0}."},
{"R_UntrustedKeyPath","Der Pfad des Spaltenhauptschlüssels \"{0}\", der vom Server \"{1}\" empfangen wurde, ist kein vertrauenswürdiger Schlüsselpfad. Der Pfad des Spaltenhauptschlüssels könnte beschädigt sein, oder Sie sollten \"{0}\" unter Verwendung von SQLServerConnection.setColumnEncryptionTrustedMasterKeyPaths() als vertrauenswürdigen Schlüsselpfad festlegen."},
{"R_UnrecognizedKeyStoreProviderName","Fehler beim Entschlüsseln eines Spaltenverschlüsselungsschlüssels. Ungültiger Name des Schlüsselspeicheranbieters: \"{0}\". Der Name eines Schlüsselspeicheranbieters muss entweder einen Systemschlüsselspeicher-Anbieter oder einen registrierten benutzerdefinierten Schlüsselspeicheranbieter bezeichnen. Gültige Systemschlüsselspeicheranbieternamen sind: \"{1}\". Gültige (derzeit registrierte) benutzerdefinierte Schlüsselspeicheranbieternamen sind: \"{2}\". Prüfen Sie die Daten zu den Schlüsselspeicheranbietern in der Spalte mit den Hauptschlüsseldefinitionen in der Datenbank. Stellen Sie außerdem sicher, dass alle benutzerdefinierten Schlüsselspeicheranbieter, die in der Anwendung verwendet werden, korrekt registriert sind."},
{"R_UnsupportedDataTypeAE","Die Verschlüsselung und Entschlüsselung des Datentyps \"{0}\" wird nicht unterstützt."},
{"R_NormalizationErrorAE","Fehler bei Entschlüsselung von Datentyp \"{0}\". Normalisierungsfehler."},
{"R_UnsupportedNormalizationVersionAE","Normalisierungsversion \"{0}\", die SQL Server erhalten hat, ist ungültig oder beschädigt. Gültige Normalisierungsversionen sind: \"{1}\"."},
{"R_NullCipherTextAE","Interner Fehler. Ciphertext-Wert darf nicht NULL sein."},
{"R_NullColumnEncryptionAlgorithmAE","Interner Fehler. Verschlüsselungsalgorithmus darf nicht NULL sein. Gültige Algorithmen sind: \"{1}\"."},
{"R_CustomCipherAlgorithmNotSupportedAE","Ein benutzerdefinierter Verschlüsselungsverfahrenalgorithmus wird nicht unterstützt."},
{"R_PlainTextNullAE","Interner Fehler. Plaintext-Wert darf nicht NULL sein."},
{"R_StreamingDataTypeAE","Daten mit einer Länge über {0} werden in der verschlüsselten {1}-Spalte nicht unterstützt."},
{"R_AE_NotSupportedByServer","Die verwendete SQL Server-Instanz unterstützt keine Spaltenverschlüsselung."},
{"R_InvalidAEVersionNumber","Ungültige Versionsnummer \"{0}\" für \"Always Encrypted\" empfangen."},
{"R_NullEncryptedColumnEncryptionKey","Interner Fehler. Verschlüsselter Spaltenverschlüsselungsschlüssel darf nicht NULL sein."},
{"R_EmptyEncryptedColumnEncryptionKey","Interner Fehler. Leerer Spaltenverschlüsselungsschlüssel festgelegt."},
{"R_InvalidMasterKeyDetails","Ungültige Hauptschlüsseldetails angegeben."},
{"R_CertificateError","Fehler beim Abrufen des Zertifikats \"{0}\" aus dem Schlüsselspeicher \"{1}\"."},
{"R_ByteToShortConversion","Fehler beim Entschlüsseln des Spaltenverschlüsselungsschlüssels."},
{"R_InvalidCertificateSignature","Die angegebene Verschlüsselungsschlüsselsignatur der verschlüsselten Spalte entspricht nicht der Signatur, die mit dem Spaltenhauptschlüssel (Zertifikat) in \"{0}\" berechnet wurde. Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Pfad ist falsch."},
{"R_CEKDecryptionFailed","Ausnahme beim Entschlüsseln des verschlüsselten Spaltenverschlüsselungsschlüssels: {0} "},
{"R_NullKeyEncryptionAlgorithm","Der Schlüsselverschlüsselungsalgorithmus darf nicht NULL sein."},
{"R_NullKeyEncryptionAlgorithmInternal","Interner Fehler. Schlüsselverschlüsselungsalgorithmus darf nicht NULL sein."},
{"R_InvalidKeyEncryptionAlgorithm","Ungültiger Schlüsselverschlüsselungsalgorithmus angegeben: \"{0}\". Erwarteter Wert: \"{1}\"."},
{"R_InvalidKeyEncryptionAlgorithmInternal","Interner Fehler. Ungültiger Schlüsselverschlüsselungsalgorithmus angegeben: \"{0}\". Erwarteter Wert: \"{1}\"."},
{"R_NullColumnEncryptionKey","Der Spaltenverschlüsselungsschlüssel darf nicht NULL sein."},
{"R_EmptyColumnEncryptionKey","Es wurde ein leerer Spaltenverschlüsselungsschlüssel angegeben."},
{"R_CertificateNotFoundForAlias","Das Zertifikat mit dem Alias \"{0}\" wurde nicht im von \"{1}\" bereitgestellten Speicher gefunden. Überprüfen Sie, ob das Zertifikat richtig in den Zertifikatspeicherort/-speicher importiert wurde."},
{"R_UnrecoverableKeyAE","Der private Schlüssel kann nicht aus dem Keystore mit den Zertifikatdetails \"{0}\" wiederhergestellt werden. Stellen Sie sicher, dass das importierte Always Encrypted-Zertifikat den privaten Schlüssel enthält, und dass das für das Zertifikat bereitgestellte Kennwort richtig ist."},
{"R_KeyStoreNotFound","Das System kann die Schlüsselspeicherdatei nicht im angegebenen Pfad finden. Stellen Sie sicher, dass der Pfad richtig ist, und Sie über ausreichende Zugriffsberechtigungen verfügen."},
{"R_CustomKeyStoreProviderMapNull","Die Speicheranbieterzuordnung für den Spaltenverschlüsselungsschlüssel darf nicht NULL sein. Ein anderer Wert als NULL wird erwartet."},
{"R_EmptyCustomKeyStoreProviderName","Ungültiger Name des Schlüsselspeicheranbieters angegeben. Name des Schlüsselspeicheranbieters darf nicht NULL oder leer sein."},
{"R_InvalidCustomKeyStoreProviderName","Ungültiger Name des Schlüsselspeicheranbieters \"{0}\". Das Präfix \"{1}\" ist für Systemschlüsselspeicheranbieter reserviert."},
{"R_CustomKeyStoreProviderValueNull","Es wurde ein Nullverweis für Schlüsselspeicheranbieter \"{0}\" angegeben. Es wird ein anderer Wert als NULL erwartet."},
{"R_CustomKeyStoreProviderSetOnce","Schlüsselspeicheranbieter dürfen nicht mehrfach festgelegt werden."},
{"R_unknownColumnEncryptionType","Ungültiger Spaltenverschlüsselungstyp \"{0}\"."},
{"R_unsupportedStmtColEncSetting","SQLServerStatementColumnEncryptionSetting darf nicht NULL sein."},
{"R_unsupportedConversionAE","Die Konvertierung von \"{0}\" in \"{1}\" wird für verschlüsselte Spalten nicht unterstützt."},
{"R_InvalidDataForAE","Der angegebene Wert vom Typ \"{0}\" aus der Datenquelle kann nicht in den Typ \"{1}\" der angegebenen Zielspalte konvertiert werden."},
{"R_authenticationPropertyDescription","Die zu verwendende Authentifizierung."},
{"R_accessTokenPropertyDescription","Das Zugriffstoken zur Verwendung für Azure Active Directory."},
{"R_FedAuthRequiredPreLoginResponseInvalidValue","Der Server sendete einen unerwarteten Wert für die Option \"FedAuthRequired PreLogin\". Der Wert war \"{0}\"."},
{"R_FedAuthInfoLengthTooShortForCountOfInfoIds","Das FedAuthInfo-Token muss mindestens 4 Bytes enthalten, die die Nummer von Info-IDs angeben."},
{"R_FedAuthInfoInvalidOffset","FedAuthInfoDataOffset zeigt auf einen ungültigen Speicherort. Aktuelles dataOffset ist \"{0}\"."},
{"R_FedAuthInfoFailedToReadData","Fehler beim Lesen von FedAuthInfoData."},
{"R_FedAuthInfoLengthTooShortForData","Der FEDAUTHINFO-Tokenstream ist nicht lang genug ({0}), um die beanspruchten Daten zu enthalten."},
{"R_FedAuthInfoDoesNotContainStsurlAndSpn","Der FEDAUTHINFO-Tokenstream enthält weder STSURL noch SPN."},
{"R_ADALExecution","Fehler beim Authentifizieren des Benutzers \"{0}\" in Active Directory (Authentication={1})."},
{"R_UnrequestedFeatureAckReceived","Es wurde eine nicht angeforderten Featurebestätigung empfangen. Feature-ID: {0}."},
{"R_FedAuthFeatureAckContainsExtraData","Die Bestätigung der Erweiterung der Verbundauthentifizierungsfunktion für ADAL und Sicherheitstoken umfasst zusätzliche Daten."},
{"R_FedAuthFeatureAckUnknownLibraryType","Es wird versucht, eine unbekannte Verbundauthentifizierungsbibliothek zu verwenden. Bibliotheks-ID: \"{0}\"."},
{"R_UnknownFeatureAck","Es wurde eine unbekannte Featurebestätigung empfangen."},
{"R_SetAuthenticationWhenIntegratedSecurityTrue","\"Authentication\" kann nicht festgelegt werden, wenn \"IntegratedSecurity\" auf \"true\" festgelegt ist."},
{"R_NtlmNoUserPasswordDomain","Für die NTLM-Authentifizierung müssen die Verbindungseigenschaften \"User\" (oder \"UserName\") und \"Password\" angegeben werden."},
{"R_SetAccesstokenWhenIntegratedSecurityTrue","Die AccessToken-Eigenschaft kann nicht festgelegt werden, wenn das Schlüsselwort für Verbindungszeichenfolgen IntegratedSecurity auf \"true\" festgelegt wurde."},
{"R_IntegratedAuthenticationWithUserPassword","\"Authentication=ActiveDirectoryIntegrated\" kann nicht mit den Schlüsselwörtern für Verbindungszeichenfolgen \"User\", \"UserName\" oder \"Password\" verwendet werden."},
{"R_MSIAuthenticationWithUserPassword","\"Authentication=ActiveDirectoryMSI\" kann nicht mit den Schlüsselwörtern für Verbindungszeichenfolgen \"User\", \"UserName\" oder \"Password\" verwendet werden."},
{"R_AccessTokenWithUserPassword","Die AccessToken-Eigenschaft kann nicht festgelegt werden, wenn \"User\", \"UserName\" oder \"Password\" in der Verbindungszeichenfolge angegeben wurde."},
{"R_AccessTokenCannotBeEmpty","AccesToken darf nicht leer sein."},
{"R_SetBothAuthenticationAndAccessToken","Die AccessToken-Eigenschaft kann nicht festgelegt werden, wenn \"Authentication\" in der Verbindungszeichenfolge angegeben wurde."},
{"R_NoUserPasswordForActivePassword","Bei Festlegung von Authentication=ActiveDirectoryPassword muss sowohl das Schlüsselwort für Verbindungszeichenfolgen \"User\" (bzw. UserName) als auch \"Password\" angegeben werden."},
{"R_NoUserPasswordForSqlPassword","Bei Festlegung von Authentication=SqlPassword muss sowohl das Schlüsselwort für Verbindungszeichenfolgen \"User\" (bzw. UserName) als auch \"Password\" angegeben werden."},
{"R_ForceEncryptionTrue_HonorAEFalse","\"Verschlüsselung erzwingen\" kann für Parameter \"{0}\" nicht auf TRUE festgelegt werden, weil die Verschlüsselung nicht für die Anweisung oder Prozedur \"{1}\" aktiviert ist."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumn","Die Anweisung oder die Prozedur \"{0}\" kann nicht ausgeführt werden, da \"Verschlüsselung erzwingen\" für Parameter \"{1}\" auf \"true\" festgelegt wurde, und die Datenbank erwartet, dass dieser Parameter als Klartext gesendet wird. Dies kann auf einen Konfigurationsfehler zurückzuführen sein."},
{"R_ForceEncryptionTrue_HonorAEFalseRS","\"Verschlüsselung erzwingen\" kann für Parameter \"{0}\" nicht auf TRUE festgelegt werden, weil die Verschlüsselung nicht für die Anweisung oder Prozedur aktiviert ist."},
{"R_ForceEncryptionTrue_HonorAETrue_UnencryptedColumnRS","Das Update kann nicht ausgeführt werden, weil \"Verschlüsselung erzwingen\" für Parameter \"{0}\" auf \"true\" festgelegt wurde, und die Datenbank erwartet, dass dieser Parameter als Klartext gesendet wird. Dies kann auf einen Konfigurationsfehler zurückzuführen sein."},
{"R_NullValue","\"{0}\" darf nicht NULL sein."},
{"R_AKVPathNull","Azure Key Vault-Schlüsselpfad darf nicht NULL sein."},
{"R_AKVURLInvalid","Ungültige URL angegeben: {0}."},
{"R_AKVMasterKeyPathInvalid","Ungültiger Azure Key Vault-Pfad angegeben: \"{0}\"."},
{"R_EmptyCEK","Es wurde ein leerer Spaltenverschlüsselungsschlüssel angegeben."},
{"R_EncryptedCEKNull","Der verschlüsselte Spaltenverschlüsselungsschlüssel darf nicht NULL sein."},
{"R_EmptyEncryptedCEK","Die Länge des verschlüsselten Spaltenverschlüsselungsschlüssels sollte nicht 0 sein."},
{"R_NonRSAKey","Ein Nicht-RSA-Schlüssel kann nicht verwendet werden: \"{0}\"."},
{"R_GetAKVKeySize","Das Abrufen der Größe des öffentlichen Azure Key Vault-Schlüssels in Bytes ist nicht möglich."},
{"R_InvalidEcryptionAlgorithmVersion","Der Verschlüsselungsschlüssel der angegebenen verschlüsselten Spalte enthält die ungültige Verschlüsselungsalgorithmusversion \"{0}\". Erwartet wird die Version \"{1}\"."},
{"R_AKVKeyLengthError","Die Chiffretextlänge {0} für den Verschlüsselungsschlüssel der angegebenen verschlüsselten Spalte entspricht nicht der Chiffretextlänge {1} bei Verwendung des Spaltenhauptschlüssels (Azure Key Vault-Schlüssel) in \"{2}\". Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Azure Key Vault-Schlüsselpfad ist falsch."},
{"R_AKVSignatureLengthError","Die Länge {0} der Signatur des Verschlüsselungsschlüssels der angegebenen verschlüsselten Spalte entspricht nicht der Länge {1} der Signatur bei Verwendung des Spaltenhauptschlüssels (Azure Key Vault-Schlüssel) in \"{2}\". Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Azure Key Vault-Schlüsselpfad ist falsch."},
{"R_HashNull","Beim Entschlüsseln des verschlüsselten Spaltenverschlüsselungsschlüssels sollte der Hash nicht NULL sein."},
{"R_NoSHA256Algorithm","Der SHA-256-Algorithmus wird nicht unterstützt."},
{"R_VerifySignature","Die Signatur des Spaltenverschlüsselungsschlüssels kann nicht überprüft werden."},
{"R_CEKSignatureNotMatchCMK","Die angegebene Verschlüsselungsschlüsselsignatur der verschlüsselten Spalte entspricht nicht der Signatur, die mit dem Spaltenhauptschlüssel (asymmetrischer Schlüssel in Azure Key Vault) in \"{0}\" berechnet wurde. Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Pfad ist falsch."},
{"R_DecryptCEKError","Der Spaltenverschlüsselungsschlüssel kann mit dem angegebenen Azure Key Vault-Schlüssel nicht entschlüsselt werden."},
{"R_EncryptCEKError","Der Spaltenverschlüsselungsschlüssel kann ist mit dem angegebenen Azure Key Vault-Schlüssel nicht verschlüsselt werden."},
{"R_CipherTextLengthNotMatchRSASize","Die Länge von CipherText entspricht nicht der Größe des RSA-Schlüssels."},
{"R_GenerateSignature","Die Signatur kann mit einer angegebenen Azure Key Vault-Schlüssel-URL nicht generiert werden."},
{"R_SignedHashLengthError","Die signierte Hashlänge entspricht nicht der Größe des RSA-Schlüssels."},
{"R_InvalidSignatureComputed","Die Signatur des berechneten verschlüsselten Spaltenverschlüsselungsschlüssels ist ungültig."},
{"R_UnableLoadADALSqlDll","Die Datei \"adalsql.dll.\" kann nicht geladen werden. Fehlercode: 0x{0}. Ausführliche Informationen finden Sie unter http://go.microsoft.com/fwlink/?LinkID=513072."},
{"R_ADALAuthenticationMiddleErrorMessage","Fehlercode 0x{0}; Status \"{1}\"."},
{"R_unsupportedDataTypeTVP","Der Datentyp \"{0}\" wird im Tabellenwertparameter nicht unterstützt."},
{"R_moreDataInRowThanColumnInTVP","Das Eingabearray ist länger als die Anzahl von Spalten in dieser Tabelle."},
{"R_invalidTVPName"," Der Tabellenwertparameter muss einen gültigen Typnamen aufweisen."},
{"R_invalidThreePartName","Ungültiges dreiteiliges Namenformat für TypeName."},
{"R_unsupportedConversionTVP","Die Konvertierung von \"{0}\" in \"{1}\" wird für Tabellenwertparameter nicht unterstützt."},
{"R_TVPMixedSource","Hinzufügen von Spaltenmetadaten nicht möglich. Dieser Tabellenwertparameter verfügt über ein ResultSet, aus dem Metadaten abgeleitet werden."},
{"R_TVPEmptyMetadata","Im Structured-Typ sind nicht genügend Felder enthalten. Structured-Typen müssen mindestens ein Feld aufweisen."},
{"R_TVPInvalidValue","Der für den Tabellenwertparameter \"{0}\" angegebene Wert ist ungültig. Nur SQLServerDataTable-, ResultSet- und ISQLServerDataRecord-Objekte werden unterstützt."},
{"R_TVPInvalidColumnValue","Die Eingabedaten liegen nicht im richtigen Format vor."},
{"R_TVPSortOrdinalGreaterThanFieldCount","Der Sortierordinalwert {0} für Feld \"{1}\" überschreitet die Gesamtzahl der Felder."},
{"R_TVPMissingSortOrderOrOrdinal","Es müssen entweder Sortierreihenfolge und Ordinalwert oder keines von beiden angegeben werden. (SortOrder.Unspecified und -1). Die angegebenen Werte waren: order = {0}, ordinal = {1}."},
{"R_TVPDuplicateSortOrdinal","Der Sortierordinalwert {0} wurde zweimal angegeben."},
{"R_TVPMissingSortOrdinal","Der Sortierordinalwert {0} wurde nicht angegeben."},
{"R_TVPDuplicateColumnName","Ein Spaltenname \"{0}\" gehört bereits zu dieser SQLServerDataTable."},
{"R_InvalidConnectionSetting","Der {0}-Wert \"{1}\" ist ungültig."},
{"R_InvalidWindowsCertificateStoreEncryption","Das Verschlüsseln eines Spaltenverschlüsselungsschlüssels ist mit dem Windows-Zertifikatspeicher nicht möglich."},
{"R_AEKeypathEmpty","Interner Fehler. Zertifikatpfad darf nicht NULL sein. Verwenden Sie das folgende Format: \"Zertifikatspeicherort/Zertifikatspeicher/Zertifikatfingerabdruck\", wobei \"Zertifikatspeicherort\" entweder LocalMachine oder CurrentUser ist."},
{"R_AEWinApiErr","Windows-API: nativer Fehler."},
{"R_AECertpathBad","Interner Fehler. Ungültiger Zertifikatpfad: \"{0}\". Verwenden Sie das folgende Format: \"Zertifikatspeicherort/Zertifikatspeicher/Zertifikatfingerabdruck\", wobei \"Zertifikatspeicherort\" entweder LocalMachine oder CurrentUser ist."},
{"R_AECertLocBad","Interner Fehler. Ungültiger Zertifikatspeicherort \"{0}\" im Zertifikatpfad \"{1}\". Verwenden Sie das folgende Format: \"Zertifikatspeicherort/Zertifikatspeicher/Zertifikatfingerabdruck\", wobei \"Zertifikatspeicherort\" entweder LocalMachine oder CurrentUser ist."},
{"R_AECertStoreBad","Interner Fehler. Ungültiger Zertifikatspeicher \"{0}\" im Zertifikatpfad \"{1}\". Erwarteter Wert: \"My\"."},
{"R_AECertHashEmpty","Interner Fehler. Leerer Zertifikatfingerabdruck im Zertifikatpfad \"{0}\" festgelegt."},
{"R_AECertNotFound","Das Zertifikat mit dem Fingerabdruck \"{2}\" wurde nicht im Zertifikatspeicher \"{1}\" am Zertifikatspeicherort \"{0}\" gefunden. Überprüfen Sie, ob der Zertifikatpfad in der Spaltenhauptschlüsseldefinition in der Datenbank korrekt ist, und das Zertifikat richtig in den Zertifikatspeicherort/-speicher importiert wurde."},
{"R_AEMaloc","Fehler bei der Speicherbelegung."},
{"R_AEKeypathLong","Interner Fehler. Der angegebene Zertifikatpfad umfasst {0} Bytes. Dies überschreitet die maximale Länge von {1} Bytes."},
{"R_AEECEKLenBad","Die angegebene Chiffretextlänge {0} des Verschlüsselungsschlüssels der verschlüsselten Spalte entspricht nicht der Chiffretextlänge {1}, wenn der Spaltenhauptschlüssel (Zertifikat) in \"{2}\" verwendet wird. Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Zertifikatpfad ist falsch."},
{"R_AEECEKSigLenBad","Die angegebene Signaturlänge {0} des Verschlüsselungsschlüssels der verschlüsselten Spalte entspricht nicht der Länge {1}, wenn der Spaltenhauptschlüssel (Zertifikat) in \"{2}\" verwendet wird. Der Verschlüsselungsschlüssel der verschlüsselten Spalte ist möglicherweise beschädigt, oder der angegebene Zertifikatpfad ist falsch."},
{"R_AEKeyPathEmptyOrReserved","Der Zertifikatpfad \"{0}\" ist ungültig; er ist leer oder enthält reservierte Verzeichnisnamen."},
{"R_AEKeyPathCurUser","Im Schlüsselpfad wurde CurrentUser angegeben, aber beim Abrufen des ursprünglichen Arbeitsverzeichnisses für den aktuellen Benutzers ist ein Fehler aufgetreten."},
{"R_AEKeyFileOpenError","Fehler beim Öffnen der Zertifikatdatei \"{0}\"."},
{"R_AEKeyFileReadError","Fehler beim Lesen der Zertifikatdatei \"{0}\"."},
{"R_keyStoreAuthenticationPropertyDescription","Der Name, der einen Schlüsselspeicher bezeichnet."},
{"R_keyStoreSecretPropertyDescription","Das Geheimnis für die Authentifizierung bzw. die Informationen, die zum Auffinden des Geheimnisses benötigt werden."},
{"R_keyStoreLocationPropertyDescription","Der Standort des Schlüsselspeichers."},
{"R_keyStoreAuthenticationNotSet","Das Schlüsselwort für die keyStoreAuthentication-Verbindungszeichenfolge muss angegeben werden, wenn \"{0}\" angegeben wird."},
{"R_keyStoreSecretOrLocationNotSet","Sowohl \"keyStoreSecret\" als auch \"keyStoreLocation\" müssen festgelegt werden, wenn in der Verbindungszeichenfolge \"keyStoreAuthentication=JavaKeyStorePassword\" angegeben wurde."},
{"R_certificateStoreInvalidKeyword","\"keyStoreSecret\" kann nicht festgelegt werden, wenn in der Verbindungszeichenfolge \"keyStoreAuthentication=CertificateStore\" angegeben wurde."},
{"R_certificateStoreLocationNotSet","\"keyStoreLocation\" muss angegeben werden, wenn in der Verbindungszeichenfolge \"keyStoreAuthentication=CertificateStore\" angegeben wurde."},
{"R_certificateStorePlatformInvalid","\"keyStoreAuthentication=CertificateStore\" kann auf einem Windows-Betriebssystem nicht festgelegt werden."},
{"R_invalidKeyStoreFile","Das Analysieren von \"{0}\" ist nicht möglich. Entweder ist das Dateiformat ungültig, oder das Kennwort ist falsch."},
{"R_invalidCEKCacheTtl","Es wurde eine ungültige Gültigkeitsdauer (TTL) für den Spaltenverschlüsselungs-Schlüsselcache angegeben. Der columnEncryptionKeyCacheTtl-Wert darf nicht negativ sein, und timeUnit kann nur auf DAYS, HOURS, MINUTES oder SECONDS festgelegt werden."},
{"R_sendTimeAsDateTimeForAE","Verwenden Sie \"sendTimeAsDateTime=false\" mit Always Encrypted."},
{"R_TVPnotWorkWithSetObjectResultSet","\"setObject()\" mit ResultSet wird für Tabellenwertparameter nicht unterstützt. Verwenden Sie \"setStructured()\"."},
{"R_invalidQueryTimeout","Das queryTimeout \"{0}\" ist ungültig."},
{"R_invalidSocketTimeout","Das socketTimeout \"{0}\" ist ungültig."},
{"R_fipsPropertyDescription","Hiermit wird bestimmt, ob der FIPS-Modus aktiviert ist."},
{"R_invalidFipsConfig","Die Einstellungen für den FIPS-Modus können nicht überprüft werden."},
{"R_serverPreparedStatementDiscardThreshold","Der serverPreparedStatementDiscardThreshold \"{0}\" ist ungültig."},
{"R_statementPoolingCacheSize","Der statementPoolingCacheSize-Wert \"{0}\" ist ungültig."},
{"R_kerberosLoginFailedForUsername","Die Anmeldung beim Kerberos-Prinzipal \"{0}\" ist nicht möglich, prüfen Sie Ihre Anmeldeinformationen. {1}"},
{"R_kerberosLoginFailed","Fehler bei der Kerberos-Anmeldung: {0}. Ursache: {1} ({2})"},
{"R_StoredProcedureNotFound","Die gespeicherte Prozedur \"{0}\" wurde nicht gefunden."},
{"R_jaasConfigurationNamePropertyDescription","Anmeldekonfigurationsdatei für die Kerberos-Authentifizierung."},
{"R_AKVKeyNotFound","Schlüssel nicht gefunden: {0}"},
{"R_SQLVariantSupport","SQL_VARIANT wird in Vorgängerversionen von SQL Server 2008 nicht unterstützt."},
{"R_invalidProbbytes","SQL_VARIANT: Ungültige probBytes für Typ \"{0}\"."},
{"R_invalidStringValue","SQL_VARIANT unterstützt keine Zeichenfolgenwerte mit einer Länge von mehr als 8000."},
{"R_invalidValueForTVPWithSQLVariant","Die Verwendung von TVPs mit NULL-sql_variant-Spalten wird nicht unterstützt."},
{"R_invalidDataTypeSupportForSQLVariant","Unerwarteter TDS-Typ \"{0}\" in SQL_VARIANT."},
{"R_sslProtocolPropertyDescription","SSL-Protokollbezeichnung aus TLS, TLSv1, TLSv1.1 und TLSv1.2. Der Standardwert ist TLS."},
{"R_invalidSSLProtocol","Die Bezeichnung des SSL-Protokolls \"{0}\" ist ungültig. Es werden nur TLS, TLSv1, TLSv1.1 und TLSv1.2 unterstützt."},
{"R_cancelQueryTimeoutPropertyDescription","Die Anzahl von Sekunden, die abgewartet wird, bevor zum Abbruch ein Abfragetimeout gesendet wird."},
{"R_invalidCancelQueryTimeout","Ungültiger Wert für Abbruchtimeout: {0}."},
{"R_useBulkCopyForBatchInsertPropertyDescription","Gibt an, ob der Treiber für Batcheinfügevorgänge die API für das Massenkopieren verwendet."},
{"R_UnknownDataClsTokenNumber","Unbekanntes Token für die Datenklassifizierung."},
{"R_InvalidDataClsVersionNumber","Ungültige Versionsnummer {0} für die Datenklassifizierung."},
{"R_unknownUTF8SupportValue","Unbekannter Wert für UTF8-Unterstützung."},
{"R_illegalWKT","Unzulässiger WKT (Well-Known Text). Stellen Sie sicher, dass der WKT gültig ist."},
{"R_illegalTypeForGeometry","\"{0}\" wird für \"Geometry\" nicht unterstützt."},
{"R_illegalWKTposition","Ungültiges Zeichen in WKT (Well-Known Text) an der Position \"{0}\"."},
{"R_keyVaultProviderClientIdPropertyDescription","Die Client-ID für den Zugriff auf den Schlüsseltresor, in dem der Hauptschlüssel für die Spaltenverschlüsselung gespeichert ist."},
{"R_keyVaultProviderClientKeyPropertyDescription","Der Clientschlüssel für den Zugriff auf den Schlüsseltresor, in dem der Hauptschlüssel für die Spaltenverschlüsselung gespeichert ist."},
{"R_ADALMissing","Fehler beim Laden der ADAL4J Java-Bibliothek zum Ausführen der {0}-Authentifizierung."},
{"R_DLLandADALMissing","Fehler beim Laden von \"sqljdbc_auth.dll\" und der ADAL4J Java-Bibliothek zum Ausführen der {0}-Authentifizierung. Installieren Sie eine der Bibliotheken, um den Vorgang fortzusetzen."},
{"R_MSITokenFailureImds","MSI-Tokenfehler: Fehler beim Abrufen des Zugriffstokens aus IMDS."},
{"R_MSITokenFailureImdsClientId","MSI-Tokenfehler: Fehler beim Abrufen des Zugriffstokens aus IMDS, überprüfen Sie Ihre clientId."},
{"R_MSITokenFailureUnexpected","MSI-Tokenfehler: Fehler beim Abrufen des Zugriffstokens aus IMDS, es wurde ein unerwarteter Fehler festgestellt."},
{"R_MSITokenFailureEndpoint","MSI-Tokenfehler: Fehler beim Abrufen des Tokens vom MSI-Endpunkt."},
{"R_propertyNotSupported","Der Microsoft JDBC-Treiber für SQL Server bietet aktuell keine Unterstützung für die Eigenschaft \"{0}\"."},
{"R_ntlmHmacMD5Error","Die NTLM-Authentifizierung kann nicht initialisiert werden: HMAC-MD5-Initialisierungsfehler."},
{"R_ntlmSignatureError","Signaturfehler in der NTLM-Aufforderungsnachricht: {0}"},
{"R_ntlmMessageTypeError","Fehler beim Typ der NTLM-Aufforderungsnachricht: {0}"},
{"R_ntlmAuthenticateError","NTLM-Fehler beim Erstellen der Authentifizierungsnachricht: {0}"},
{"R_ntlmNoTargetInfo","In der NTLM-Aufforderungsnachricht fehlt die TargetInfo."},
{"R_ntlmUnknownValue","TargetInfo-Fehler in der NTLM-Aufforderungsnachricht: unbekannter Wert \"{0}\""},
{"R_useFmtOnlyPropertyDescription","Legt fest, ob die Verwendung von SET FMTONLY zum Abrufen von Parametermetadaten aktiviert/deaktiviert werden soll."},
{"R_invalidOpenqueryCall","Ungültige Syntax: Bei OPENQUERY/OPENJSON/OPENDATASOURCE/OPENROWSET/OPENXML müssen runde Klammern vorangestellt werden."},
{"R_invalidCTEFormat","Ungültige Syntax: Auf AS müssen in allgemeinen Tabellenausdrücken runde Klammern folgen."},
{"R_noTokensFoundInUserQuery","Ungültige Abfrage: Es wurden keine Token aus der SQL-Angabe analysiert."},
{"R_invalidUserSQL","Fehler beim Analysieren von Benutzer-SQL. Überprüfen Sie die SQL-Syntax."},
{"R_invalidInsertValuesQuery","Fehler beim Abgleich der VALUES-Liste mit den Tabellenspalten. Überprüfen Sie die SQL-Syntax."},
{"R_invalidValuesList","Fehler beim Lesen der VALUES-List. Überprüfen Sie die SQL-Syntax."},
};
}
