/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

final class TimeoutTimer
implements Runnable {
    private static final String threadGroupName = "mssql-jdbc-TimeoutTimer";
    private final int timeoutSeconds;
    private final TDSCommand command;
    private volatile Future<?> task;
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicReference<ThreadGroup> tgr = new AtomicReference();
        private final AtomicInteger threadNumber = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            ThreadGroup tg = this.tgr.get();
            if (tg == null || tg.isDestroyed()) {
                tg = new ThreadGroup(TimeoutTimer.threadGroupName);
                this.tgr.set(tg);
            }
            Thread t = new Thread(tg, r, tg.getName() + "-" + this.threadNumber.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    });
    private volatile boolean canceled = false;

    TimeoutTimer(int timeoutSeconds, TDSCommand command) {
        assert (timeoutSeconds > 0);
        assert (null != command);
        this.timeoutSeconds = timeoutSeconds;
        this.command = command;
    }

    final void start() {
        this.task = executor.submit(this);
    }

    final void stop() {
        this.task.cancel(true);
        this.canceled = true;
    }

    @Override
    public void run() {
        int secondsRemaining = this.timeoutSeconds;
        try {
            do {
                if (this.canceled) {
                    return;
                }
                Thread.sleep(1000L);
            } while (--secondsRemaining > 0);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
        try {
            this.command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
        }
        catch (SQLServerException e) {
            this.command.log(Level.FINE, "Command could not be timed out. Reason: " + e.getMessage());
        }
    }
}

