/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DriverError;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.ISQLServerBulkRecord;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLState;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class SQLServerBulkCSVFileRecord
implements ISQLServerBulkRecord,
AutoCloseable {
    private BufferedReader fileReader;
    private InputStreamReader sr;
    private FileInputStream fis;
    private Map<Integer, ColumnMetadata> columnMetadata;
    private String currentLine = null;
    private final String delimiter;
    private String[] columnNames = null;
    private DateTimeFormatter dateTimeFormatter = null;
    private DateTimeFormatter timeFormatter = null;
    private static final String loggerClassName = "com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord";
    private static final Logger loggerExternal = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerBulkCSVFileRecord");

    public SQLServerBulkCSVFileRecord(String fileToParse, String encoding, String delimiter, boolean firstLineIsColumnNames) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCSVFileRecord", new Object[]{fileToParse, encoding, delimiter, firstLineIsColumnNames});
        if (null == fileToParse) {
            this.throwInvalidArgument("fileToParse");
        } else if (null == delimiter) {
            this.throwInvalidArgument("delimiter");
        }
        this.delimiter = delimiter;
        try {
            this.fis = new FileInputStream(fileToParse);
            this.sr = null == encoding || 0 == encoding.length() ? new InputStreamReader(this.fis) : new InputStreamReader((InputStream)this.fis, encoding);
            this.fileReader = new BufferedReader(this.sr);
            if (firstLineIsColumnNames) {
                this.currentLine = this.fileReader.readLine();
                if (null != this.currentLine) {
                    this.columnNames = this.currentLine.split(delimiter, -1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncoding) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            throw new SQLServerException(form.format(new Object[]{encoding}), null, 0, (Throwable)unsupportedEncoding);
        }
        catch (Exception e) {
            throw new SQLServerException(null, e.getMessage(), null, 0, false);
        }
        this.columnMetadata = new HashMap<Integer, ColumnMetadata>();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCSVFileRecord");
    }

    public SQLServerBulkCSVFileRecord(InputStream fileToParse, String encoding, String delimiter, boolean firstLineIsColumnNames) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "SQLServerBulkCSVFileRecord", new Object[]{fileToParse, encoding, delimiter, firstLineIsColumnNames});
        if (null == fileToParse) {
            this.throwInvalidArgument("fileToParse");
        } else if (null == delimiter) {
            this.throwInvalidArgument("delimiter");
        }
        this.delimiter = delimiter;
        try {
            this.sr = null == encoding || 0 == encoding.length() ? new InputStreamReader(fileToParse) : new InputStreamReader(fileToParse, encoding);
            this.fileReader = new BufferedReader(this.sr);
            if (firstLineIsColumnNames) {
                this.currentLine = this.fileReader.readLine();
                if (null != this.currentLine) {
                    this.columnNames = this.currentLine.split(delimiter, -1);
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncoding) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedEncoding"));
            throw new SQLServerException(form.format(new Object[]{encoding}), null, 0, (Throwable)unsupportedEncoding);
        }
        catch (Exception e) {
            throw new SQLServerException(null, e.getMessage(), null, 0, false);
        }
        this.columnMetadata = new HashMap<Integer, ColumnMetadata>();
        loggerExternal.exiting(loggerClassName, "SQLServerBulkCSVFileRecord");
    }

    public SQLServerBulkCSVFileRecord(String fileToParse, String encoding, boolean firstLineIsColumnNames) throws SQLServerException {
        this(fileToParse, encoding, ",", firstLineIsColumnNames);
    }

    public SQLServerBulkCSVFileRecord(String fileToParse, boolean firstLineIsColumnNames) throws SQLServerException {
        this(fileToParse, null, ",", firstLineIsColumnNames);
    }

    public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
        this.addColumnMetadataInternal(positionInFile, name, jdbcType, precision, scale, dateTimeFormatter);
    }

    public void addColumnMetadata(int positionInFile, String name, int jdbcType, int precision, int scale) throws SQLServerException {
        this.addColumnMetadataInternal(positionInFile, name, jdbcType, precision, scale, null);
    }

    void addColumnMetadataInternal(int positionInFile, String name, int jdbcType, int precision, int scale, DateTimeFormatter dateTimeFormatter) throws SQLServerException {
        loggerExternal.entering(loggerClassName, "addColumnMetadata", new Object[]{positionInFile, name, jdbcType, precision, scale});
        String colName = "";
        if (0 >= positionInFile) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidColumnOrdinal"));
            Object[] msgArgs = new Object[]{positionInFile};
            throw new SQLServerException(form.format(msgArgs), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
        }
        if (null != name) {
            colName = name.trim();
        } else if (this.columnNames != null && this.columnNames.length >= positionInFile) {
            colName = this.columnNames[positionInFile - 1];
        }
        if (this.columnNames != null && positionInFile > this.columnNames.length) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
            Object[] msgArgs = new Object[]{positionInFile};
            throw new SQLServerException(form.format(msgArgs), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
        }
        this.checkDuplicateColumnName(positionInFile, name);
        switch (jdbcType) {
            case -155: 
            case 91: 
            case 92: 
            case 93: {
                this.columnMetadata.put(positionInFile, new ColumnMetadata(colName, jdbcType, 50, scale, dateTimeFormatter));
                break;
            }
            case 2009: {
                this.columnMetadata.put(positionInFile, new ColumnMetadata(colName, -16, precision, scale, dateTimeFormatter));
                break;
            }
            case 6: {
                this.columnMetadata.put(positionInFile, new ColumnMetadata(colName, 8, precision, scale, dateTimeFormatter));
                break;
            }
            case 16: {
                this.columnMetadata.put(positionInFile, new ColumnMetadata(colName, -7, precision, scale, dateTimeFormatter));
                break;
            }
            default: {
                this.columnMetadata.put(positionInFile, new ColumnMetadata(colName, jdbcType, precision, scale, dateTimeFormatter));
            }
        }
        loggerExternal.exiting(loggerClassName, "addColumnMetadata");
    }

    public void setTimestampWithTimezoneFormat(String dateTimeFormat) {
        DriverJDBCVersion.checkSupportsJDBC42();
        loggerExternal.entering(loggerClassName, "setTimestampWithTimezoneFormat", dateTimeFormat);
        this.dateTimeFormatter = DateTimeFormatter.ofPattern(dateTimeFormat);
        loggerExternal.exiting(loggerClassName, "setTimestampWithTimezoneFormat");
    }

    public void setTimestampWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        loggerExternal.entering(loggerClassName, "setTimestampWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.dateTimeFormatter = dateTimeFormatter;
        loggerExternal.exiting(loggerClassName, "setTimestampWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(String timeFormat) {
        DriverJDBCVersion.checkSupportsJDBC42();
        loggerExternal.entering(loggerClassName, "setTimeWithTimezoneFormat", timeFormat);
        this.timeFormatter = DateTimeFormatter.ofPattern(timeFormat);
        loggerExternal.exiting(loggerClassName, "setTimeWithTimezoneFormat");
    }

    public void setTimeWithTimezoneFormat(DateTimeFormatter dateTimeFormatter) {
        loggerExternal.entering(loggerClassName, "setTimeWithTimezoneFormat", new Object[]{dateTimeFormatter});
        this.timeFormatter = dateTimeFormatter;
        loggerExternal.exiting(loggerClassName, "setTimeWithTimezoneFormat");
    }

    @Override
    public void close() throws SQLServerException {
        loggerExternal.entering(loggerClassName, "close");
        if (this.fileReader != null) {
            try {
                this.fileReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.sr != null) {
            try {
                this.sr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fis != null) {
            try {
                this.fis.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        loggerExternal.exiting(loggerClassName, "close");
    }

    public DateTimeFormatter getColumnDateTimeFormatter(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).dateTimeFormatter;
    }

    @Override
    public Set<Integer> getColumnOrdinals() {
        return this.columnMetadata.keySet();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).columnName;
    }

    @Override
    public int getColumnType(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).columnType;
    }

    @Override
    public int getPrecision(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).precision;
    }

    @Override
    public int getScale(int column) {
        return this.columnMetadata.get((Object)Integer.valueOf((int)column)).scale;
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public Object[] getRowData() throws SQLServerException {
        if (null == this.currentLine) {
            return null;
        }
        String[] data = this.currentLine.split(this.delimiter, -1);
        Object[] dataRow = new Object[data.length];
        for (Map.Entry<Integer, ColumnMetadata> pair : this.columnMetadata.entrySet()) {
            Object[] msgArgs;
            MessageFormat form;
            ColumnMetadata cm = pair.getValue();
            if (data.length < pair.getKey() - 1) {
                form = new MessageFormat(SQLServerException.getErrString("R_invalidColumn"));
                msgArgs = new Object[]{pair.getKey()};
                throw new SQLServerException(form.format(msgArgs), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
            }
            if (this.columnNames != null && this.columnNames.length > data.length) {
                form = new MessageFormat(SQLServerException.getErrString("R_CSVDataSchemaMismatch"));
                msgArgs = new Object[]{};
                throw new SQLServerException(form.format(msgArgs), SQLState.COL_NOT_FOUND, DriverError.NOT_SET, null);
            }
            try {
                if (0 == data[pair.getKey() - 1].length()) {
                    dataRow[pair.getKey().intValue() - 1] = null;
                    continue;
                }
                switch (cm.columnType) {
                    case 4: {
                        DecimalFormat decimalFormatter = new DecimalFormat("#");
                        String formatedfInput = decimalFormatter.format(Double.parseDouble(data[pair.getKey() - 1]));
                        dataRow[pair.getKey().intValue() - 1] = Integer.valueOf(formatedfInput);
                        break;
                    }
                    case -6: 
                    case 5: {
                        DecimalFormat decimalFormatter = new DecimalFormat("#");
                        String formatedfInput = decimalFormatter.format(Double.parseDouble(data[pair.getKey() - 1]));
                        dataRow[pair.getKey().intValue() - 1] = Short.valueOf(formatedfInput);
                        break;
                    }
                    case -5: {
                        BigDecimal bd = new BigDecimal(data[pair.getKey() - 1].trim());
                        try {
                            dataRow[pair.getKey().intValue() - 1] = bd.setScale(0, 1).longValueExact();
                            break;
                        }
                        catch (ArithmeticException ex) {
                            String value = "'" + data[pair.getKey() - 1] + "'";
                            MessageFormat form2 = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                            throw new SQLServerException(form2.format(new Object[]{value, JDBCType.of(cm.columnType)}), null, 0, (Throwable)ex);
                        }
                    }
                    case 2: 
                    case 3: {
                        BigDecimal bd = new BigDecimal(data[pair.getKey() - 1].trim());
                        dataRow[pair.getKey().intValue() - 1] = bd.setScale(cm.scale, RoundingMode.HALF_UP);
                        break;
                    }
                    case -7: {
                        try {
                            dataRow[pair.getKey().intValue() - 1] = 0.0 == Double.parseDouble(data[pair.getKey() - 1]) ? Boolean.FALSE : Boolean.TRUE;
                        }
                        catch (NumberFormatException e) {
                            dataRow[pair.getKey().intValue() - 1] = Boolean.parseBoolean(data[pair.getKey() - 1]);
                        }
                        break;
                    }
                    case 7: {
                        dataRow[pair.getKey().intValue() - 1] = Float.valueOf(Float.parseFloat(data[pair.getKey() - 1]));
                        break;
                    }
                    case 8: {
                        dataRow[pair.getKey().intValue() - 1] = Double.parseDouble(data[pair.getKey() - 1]);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: 
                    case 2004: {
                        String binData = data[pair.getKey() - 1].trim();
                        if (binData.startsWith("0x") || binData.startsWith("0X")) {
                            dataRow[pair.getKey().intValue() - 1] = binData.substring(2);
                            break;
                        }
                        dataRow[pair.getKey().intValue() - 1] = binData;
                        break;
                    }
                    case 2013: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                        OffsetTime offsetTimeValue = null != cm.dateTimeFormatter ? OffsetTime.parse(data[pair.getKey() - 1], cm.dateTimeFormatter) : (this.timeFormatter != null ? OffsetTime.parse(data[pair.getKey() - 1], this.timeFormatter) : OffsetTime.parse(data[pair.getKey() - 1]));
                        dataRow[pair.getKey().intValue() - 1] = offsetTimeValue;
                        break;
                    }
                    case 2014: {
                        DriverJDBCVersion.checkSupportsJDBC42();
                        OffsetDateTime offsetDateTimeValue = null != cm.dateTimeFormatter ? OffsetDateTime.parse(data[pair.getKey() - 1], cm.dateTimeFormatter) : (this.dateTimeFormatter != null ? OffsetDateTime.parse(data[pair.getKey() - 1], this.dateTimeFormatter) : OffsetDateTime.parse(data[pair.getKey() - 1]));
                        dataRow[pair.getKey().intValue() - 1] = offsetDateTimeValue;
                        break;
                    }
                    case 0: {
                        dataRow[pair.getKey().intValue() - 1] = null;
                        break;
                    }
                    default: {
                        dataRow[pair.getKey().intValue() - 1] = data[pair.getKey() - 1];
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                String value = "'" + data[pair.getKey() - 1] + "'";
                MessageFormat form3 = new MessageFormat(SQLServerException.getErrString("R_errorConvertingValue"));
                throw new SQLServerException(form3.format(new Object[]{value, JDBCType.of(cm.columnType)}), null, 0, (Throwable)e);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new SQLServerException(SQLServerException.getErrString("R_CSVDataSchemaMismatch"), e);
            }
        }
        return dataRow;
    }

    @Override
    public boolean next() throws SQLServerException {
        try {
            this.currentLine = this.fileReader.readLine();
        }
        catch (IOException e) {
            throw new SQLServerException(e.getMessage(), null, 0, (Throwable)e);
        }
        return null != this.currentLine;
    }

    private void throwInvalidArgument(String argument) throws SQLServerException {
        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidArgument"));
        Object[] msgArgs = new Object[]{argument};
        SQLServerException.makeFromDriverError(null, null, form.format(msgArgs), null, false);
    }

    private void checkDuplicateColumnName(int positionInFile, String colName) throws SQLServerException {
        if (null != colName && colName.trim().length() != 0) {
            for (Map.Entry<Integer, ColumnMetadata> entry : this.columnMetadata.entrySet()) {
                if (null == entry || entry.getKey() == positionInFile || null == entry.getValue() || !colName.trim().equalsIgnoreCase(entry.getValue().columnName)) continue;
                throw new SQLServerException(SQLServerException.getErrString("R_BulkCSVDataDuplicateColumn"), null);
            }
        }
    }

    private class ColumnMetadata {
        String columnName;
        int columnType;
        int precision;
        int scale;
        DateTimeFormatter dateTimeFormatter = null;

        ColumnMetadata(String name, int type, int precision, int scale, DateTimeFormatter dateTimeFormatter) {
            this.columnName = name;
            this.columnType = type;
            this.precision = precision;
            this.scale = scale;
            this.dateTimeFormatter = dateTimeFormatter;
        }
    }
}

