/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import java.util.logging.Level;

final class TimeoutTimer
implements Runnable {
    private final int timeoutSeconds;
    private final TDSCommand command;
    private Thread timerThread;
    private volatile boolean canceled = false;

    TimeoutTimer(int timeoutSeconds, TDSCommand command) {
        assert (timeoutSeconds > 0);
        assert (null != command);
        this.timeoutSeconds = timeoutSeconds;
        this.command = command;
    }

    final void start() {
        this.timerThread = new Thread(this);
        this.timerThread.setDaemon(true);
        this.timerThread.start();
    }

    final void stop() {
        this.canceled = true;
        this.timerThread.interrupt();
    }

    @Override
    public void run() {
        int secondsRemaining = this.timeoutSeconds;
        try {
            do {
                if (this.canceled) {
                    return;
                }
                Thread.sleep(1000L);
            } while (--secondsRemaining > 0);
        }
        catch (InterruptedException e) {
            return;
        }
        try {
            this.command.interrupt(SQLServerException.getErrString("R_queryTimedOut"));
        }
        catch (SQLServerException e) {
            this.command.log(Level.FINE, "Command could not be timed out. Reason: " + e.getMessage());
        }
    }
}

