/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.DataTypeFilter;
import com.microsoft.sqlserver.jdbc.DriverJDBCVersion;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.SQLServerCallableStatement;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerPreparedStatement;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.ZeroFixupFilter;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SQLServerParameterMetaData
implements ParameterMetaData {
    private static final int SQL_SERVER_2012_VERSION = 11;
    private final SQLServerStatement stmtParent;
    private SQLServerConnection con;
    private Statement stmtCall;
    private SQLServerResultSet rsProcedureMeta;
    private static final Logger logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.internals.SQLServerParameterMetaData");
    private static final AtomicInteger baseID = new AtomicInteger(0);
    private final String traceID = " SQLServerParameterMetaData:" + SQLServerParameterMetaData.nextInstanceID();
    boolean isTVP = false;
    Map<Integer, QueryMeta> queryMetaMap = null;

    private static int nextInstanceID() {
        return baseID.incrementAndGet();
    }

    public final String toString() {
        return this.traceID;
    }

    private String parseColumns(String columnSet, String columnStartToken) {
        StringTokenizer st = new StringTokenizer(columnSet, " =?<>!", true);
        boolean START = false;
        boolean PARAMNAME = true;
        int PARAMVALUE = 2;
        int nState = 0;
        String sLastField = null;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String paramN;
            String sToken = st.nextToken();
            if (sToken.equalsIgnoreCase(columnStartToken)) {
                nState = 1;
                continue;
            }
            if (nState == 0) continue;
            if (sToken.charAt(0) == '=' || sToken.equalsIgnoreCase("is") || sToken.charAt(0) == '<' || sToken.charAt(0) == '>' || sToken.equalsIgnoreCase("like") || sToken.equalsIgnoreCase("not") || sToken.equalsIgnoreCase("in") || sToken.charAt(0) == '!') {
                nState = 2;
                continue;
            }
            if (sToken.charAt(0) == '?' && sLastField != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(sLastField);
                nState = 1;
                sLastField = null;
                continue;
            }
            if (nState != 1 || sToken.equals(" ") || (paramN = this.escapeParse(st, sToken)).length() <= 0) continue;
            sLastField = paramN;
        }
        return sb.toString();
    }

    private String parseInsertColumns(String sql, String columnMarker) {
        StringTokenizer st = new StringTokenizer(sql, " (),", true);
        int nState = 0;
        String sLastField = null;
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            if (sToken.equalsIgnoreCase(columnMarker)) {
                nState = 1;
                continue;
            }
            if (nState == 0) continue;
            if (sToken.charAt(0) == '=') {
                nState = 2;
                continue;
            }
            if ((sToken.charAt(0) == ',' || sToken.charAt(0) == ')' || sToken.charAt(0) == ' ') && sLastField != null) {
                if (sb.length() != 0) {
                    sb.append(", ");
                }
                sb.append(sLastField);
                nState = 1;
                sLastField = null;
            }
            if (sToken.charAt(0) == ')') {
                nState = 0;
                break;
            }
            if (nState != 1 || sToken.trim().length() <= 0 || sToken.charAt(0) == ',') continue;
            sLastField = this.escapeParse(st, sToken);
        }
        return sb.toString();
    }

    private void parseQueryMeta(ResultSet rsQueryMeta) throws SQLServerException {
        Pattern datatypePattern = Pattern.compile("(.*)\\((.*)(\\)|,(.*)\\))");
        try {
            while (rsQueryMeta.next()) {
                QueryMeta qm = new QueryMeta();
                SSType ssType = null;
                int paramOrdinal = rsQueryMeta.getInt("parameter_ordinal");
                String typename = rsQueryMeta.getString("suggested_system_type_name");
                if (null == typename) {
                    typename = rsQueryMeta.getString("suggested_user_type_name");
                    SQLServerPreparedStatement pstmt = (SQLServerPreparedStatement)((Object)this.con.prepareCall("select max_length, precision, scale, is_nullable from sys.assembly_types where name = ?"));
                    pstmt.setNString(1, typename);
                    ResultSet assemblyRs = pstmt.executeQuery();
                    if (assemblyRs.next()) {
                        qm.parameterTypeName = typename;
                        qm.precision = assemblyRs.getInt("max_length");
                        qm.scale = assemblyRs.getInt("scale");
                        ssType = SSType.UDT;
                    }
                } else {
                    qm.precision = rsQueryMeta.getInt("suggested_precision");
                    qm.scale = rsQueryMeta.getInt("suggested_scale");
                    Matcher matcher = datatypePattern.matcher(typename);
                    if (matcher.matches()) {
                        ssType = SSType.of(matcher.group(1));
                        if (typename.equalsIgnoreCase("varchar(max)") || typename.equalsIgnoreCase("varbinary(max)")) {
                            qm.precision = Integer.MAX_VALUE;
                        } else if (typename.equalsIgnoreCase("nvarchar(max)")) {
                            qm.precision = 0x3FFFFFFF;
                        } else if (SSType.Category.CHARACTER == ssType.category || SSType.Category.BINARY == ssType.category || SSType.Category.NCHARACTER == ssType.category) {
                            try {
                                qm.precision = Integer.parseInt(matcher.group(2));
                            }
                            catch (NumberFormatException e) {
                                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
                                Object[] msgArgs = new Object[]{new Integer(paramOrdinal)};
                                SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs) + " " + e.toString(), null, false);
                            }
                        }
                    } else {
                        ssType = SSType.of(typename);
                    }
                    if (SSType.FLOAT == ssType) {
                        qm.precision = 15;
                    } else if (SSType.REAL == ssType) {
                        qm.precision = 7;
                    } else if (SSType.TEXT == ssType) {
                        qm.precision = Integer.MAX_VALUE;
                    } else if (SSType.NTEXT == ssType) {
                        qm.precision = 0x3FFFFFFF;
                    } else if (SSType.IMAGE == ssType) {
                        qm.precision = Integer.MAX_VALUE;
                    } else if (SSType.GUID == ssType) {
                        qm.precision = 36;
                    } else if (SSType.TIMESTAMP == ssType) {
                        qm.precision = 8;
                    } else if (SSType.XML == ssType) {
                        qm.precision = 0x3FFFFFFF;
                    }
                    qm.parameterTypeName = ssType.toString();
                }
                if (null == ssType) {
                    throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), null);
                }
                JDBCType jdbcType = ssType.getJDBCType();
                qm.parameterClassName = jdbcType.className();
                qm.parameterType = jdbcType.getIntValue();
                qm.isSigned = SSType.Category.NUMERIC == ssType.category && SSType.BIT != ssType && SSType.TINYINT != ssType;
                this.queryMetaMap.put(paramOrdinal, qm);
            }
        }
        catch (SQLException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), e);
        }
    }

    private void parseQueryMetaFor2008(ResultSet rsQueryMeta) throws SQLServerException {
        try {
            ResultSetMetaData md = rsQueryMeta.getMetaData();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                QueryMeta qm = new QueryMeta();
                qm.parameterClassName = md.getColumnClassName(i);
                qm.parameterType = md.getColumnType(i);
                qm.parameterTypeName = md.getColumnTypeName(i);
                qm.precision = md.getPrecision(i);
                qm.scale = md.getScale(i);
                qm.isNullable = md.isNullable(i);
                qm.isSigned = md.isSigned(i);
                this.queryMetaMap.put(i, qm);
            }
        }
        catch (SQLException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_metaDataErrorForParameter"), e);
        }
    }

    private String escapeParse(StringTokenizer st, String firstToken) {
        String nameFragment = firstToken;
        while (nameFragment.equals(" ") && st.hasMoreTokens()) {
            nameFragment = st.nextToken();
        }
        String fullName = nameFragment;
        if (nameFragment.charAt(0) == '[' && nameFragment.charAt(nameFragment.length() - 1) != ']') {
            while (st.hasMoreTokens()) {
                nameFragment = st.nextToken();
                fullName = fullName.concat(nameFragment);
                if (nameFragment.charAt(nameFragment.length() - 1) != ']') continue;
            }
        }
        fullName = fullName.trim();
        return fullName;
    }

    private MetaInfo parseStatement(String sql, String sTableMarker) {
        StringTokenizer st = new StringTokenizer(sql, " ,", true);
        String metaTable = null;
        String metaFields = "";
        while (st.hasMoreTokens()) {
            String sToken = st.nextToken().trim();
            if (!sToken.equalsIgnoreCase(sTableMarker) || !st.hasMoreTokens()) continue;
            metaTable = this.escapeParse(st, st.nextToken());
            break;
        }
        if (null != metaTable) {
            metaFields = sTableMarker.equalsIgnoreCase("UPDATE") ? this.parseColumns(sql, "SET") : (sTableMarker.equalsIgnoreCase("INTO") ? this.parseInsertColumns(sql, "(") : this.parseColumns(sql, "WHERE"));
            return new MetaInfo(metaTable, metaFields);
        }
        return null;
    }

    private MetaInfo parseStatement(String sql) throws SQLServerException {
        StringTokenizer st = new StringTokenizer(sql, " ");
        if (st.hasMoreTokens()) {
            String sToken = st.nextToken().trim();
            if (sToken.equalsIgnoreCase("INSERT")) {
                return this.parseStatement(sql, "INTO");
            }
            if (sToken.equalsIgnoreCase("UPDATE")) {
                return this.parseStatement(sql, "UPDATE");
            }
            if (sToken.equalsIgnoreCase("SELECT")) {
                return this.parseStatement(sql, "FROM");
            }
            if (sToken.equalsIgnoreCase("DELETE")) {
                return this.parseStatement(sql, "FROM");
            }
        }
        return null;
    }

    String parseThreePartNames(String threeName) throws SQLServerException {
        int noofitems = 0;
        String procedureName = null;
        String procedureOwner = null;
        String procedureQualifier = null;
        StringTokenizer st = new StringTokenizer(threeName, ".", true);
        block10: while (st.hasMoreTokens()) {
            String sToken = st.nextToken();
            String nextItem = this.escapeParse(st, sToken);
            if (nextItem.equals(".")) continue;
            switch (noofitems) {
                case 2: {
                    procedureQualifier = procedureOwner;
                    procedureOwner = procedureName;
                    procedureName = nextItem;
                    ++noofitems;
                    continue block10;
                }
                case 1: {
                    procedureOwner = procedureName;
                    procedureName = nextItem;
                    ++noofitems;
                    continue block10;
                }
                case 0: {
                    procedureName = nextItem;
                    ++noofitems;
                    continue block10;
                }
            }
            ++noofitems;
        }
        StringBuilder sb = new StringBuilder(100);
        if (noofitems > 3 && 1 < noofitems) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
        switch (noofitems) {
            case 3: {
                sb.append("@procedure_qualifier =");
                sb.append(procedureQualifier);
                sb.append(", ");
                sb.append("@procedure_owner =");
                sb.append(procedureOwner);
                sb.append(", ");
                sb.append("@procedure_name =");
                sb.append(procedureName);
                sb.append(", ");
                break;
            }
            case 2: {
                sb.append("@procedure_owner =");
                sb.append(procedureOwner);
                sb.append(", ");
                sb.append("@procedure_name =");
                sb.append(procedureName);
                sb.append(", ");
                break;
            }
            case 1: {
                sb.append("@procedure_name =");
                sb.append(procedureName);
                sb.append(", ");
                break;
            }
        }
        return sb.toString();
    }

    private void checkClosed() throws SQLServerException {
        this.stmtParent.checkClosed();
    }

    SQLServerParameterMetaData(SQLServerStatement st, String sProcString) throws SQLServerException {
        assert (null != st);
        this.stmtParent = st;
        this.con = st.connection;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toString() + " created by (" + st.toString() + ")");
        }
        try {
            if (null != st.procedureName) {
                SQLServerStatement s = (SQLServerStatement)this.con.createStatement(1004, 1007);
                String sProc = this.parseThreePartNames(st.procedureName);
                this.rsProcedureMeta = this.con.isKatmaiOrLater() ? s.executeQueryInternal("exec sp_sproc_columns_100 " + sProc + " @ODBCVer=3") : s.executeQueryInternal("exec sp_sproc_columns " + sProc + " @ODBCVer=3");
                this.rsProcedureMeta.getColumn(6).setFilter(new DataTypeFilter());
                if (this.con.isKatmaiOrLater()) {
                    this.rsProcedureMeta.getColumn(8).setFilter(new ZeroFixupFilter());
                    this.rsProcedureMeta.getColumn(9).setFilter(new ZeroFixupFilter());
                    this.rsProcedureMeta.getColumn(17).setFilter(new ZeroFixupFilter());
                }
            } else {
                this.queryMetaMap = new HashMap<Integer, QueryMeta>();
                if (this.con.getServerMajorVersion() >= 11) {
                    String preparedSQL = this.con.replaceParameterMarkers(((SQLServerPreparedStatement)this.stmtParent).userSQL, ((SQLServerPreparedStatement)this.stmtParent).inOutParam, ((SQLServerPreparedStatement)this.stmtParent).bReturnValueSyntax);
                    SQLServerCallableStatement cstmt = (SQLServerCallableStatement)this.con.prepareCall("exec sp_describe_undeclared_parameters ?");
                    cstmt.setNString(1, preparedSQL);
                    this.parseQueryMeta(cstmt.executeQueryInternal());
                    cstmt.close();
                } else {
                    MetaInfo metaInfo = this.parseStatement(sProcString);
                    if (null == metaInfo) {
                        MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_cantIdentifyTableMetadata"));
                        Object[] msgArgs = new Object[]{sProcString};
                        SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs), null, false);
                    }
                    if (metaInfo.fields.length() <= 0) {
                        return;
                    }
                    Statement stmt = this.con.createStatement();
                    String sCom = "sp_executesql N'SET FMTONLY ON SELECT " + metaInfo.fields + " FROM " + metaInfo.table + " WHERE 1 = 2'";
                    ResultSet rs = stmt.executeQuery(sCom);
                    this.parseQueryMetaFor2008(rs);
                    stmt.close();
                    rs.close();
                }
            }
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        DriverJDBCVersion.checkSupportsJDBC4();
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        T t;
        DriverJDBCVersion.checkSupportsJDBC4();
        try {
            t = iface.cast(this);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(e.getMessage(), e);
        }
        return t;
    }

    private void verifyParameterPosition(int param) throws SQLServerException {
        boolean bFound = false;
        try {
            bFound = ((SQLServerPreparedStatement)this.stmtParent).bReturnValueSyntax && this.isTVP ? this.rsProcedureMeta.absolute(param) : this.rsProcedureMeta.absolute(param + 1);
        }
        catch (SQLException e) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_metaDataErrorForParameter"));
            Object[] msgArgs = new Object[]{new Integer(param)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs) + " " + e.toString(), null, false);
        }
        if (!bFound) {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
            Object[] msgArgs = new Object[]{new Integer(param)};
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, form.format(msgArgs), null, false);
        }
    }

    private void checkParam(int n) throws SQLServerException {
        if (!this.queryMetaMap.containsKey(n)) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, SQLServerException.getErrString("R_noMetadata"), null, false);
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterClassName;
            }
            this.verifyParameterPosition(param);
            JDBCType jdbcType = JDBCType.of(this.rsProcedureMeta.getShort("DATA_TYPE"));
            return jdbcType.className();
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return null;
        }
    }

    @Override
    public int getParameterCount() throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                return this.queryMetaMap.size();
            }
            this.rsProcedureMeta.last();
            int nCount = this.rsProcedureMeta.getRow() - 1;
            if (nCount < 0) {
                nCount = 0;
            }
            return nCount;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getParameterMode(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return 1;
            }
            this.verifyParameterPosition(param);
            int n = this.rsProcedureMeta.getInt("COLUMN_TYPE");
            switch (n) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 4;
                }
            }
            return 0;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getParameterType(int param) throws SQLServerException {
        this.checkClosed();
        try {
            int parameterType;
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                parameterType = this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterType;
            } else {
                this.verifyParameterPosition(param);
                parameterType = this.rsProcedureMeta.getShort("DATA_TYPE");
            }
            switch (parameterType) {
                case -151: 
                case -150: {
                    parameterType = SSType.DATETIME2.getJDBCType().asJavaSqlType();
                    break;
                }
                case -148: 
                case -146: {
                    parameterType = SSType.DECIMAL.getJDBCType().asJavaSqlType();
                    break;
                }
                case -145: {
                    parameterType = SSType.CHAR.getJDBCType().asJavaSqlType();
                }
            }
            return parameterType;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).parameterTypeName;
            }
            this.verifyParameterPosition(param);
            return this.rsProcedureMeta.getString("TYPE_NAME");
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return null;
        }
    }

    @Override
    public int getPrecision(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).precision;
            }
            this.verifyParameterPosition(param);
            int nPrec = this.rsProcedureMeta.getInt("PRECISION");
            return nPrec;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int getScale(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).scale;
            }
            this.verifyParameterPosition(param);
            int nScale = this.rsProcedureMeta.getInt("SCALE");
            return nScale;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public int isNullable(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).isNullable;
            }
            this.verifyParameterPosition(param);
            int nNull = this.rsProcedureMeta.getInt("NULLABLE");
            if (nNull == 1) {
                return 1;
            }
            if (nNull == 0) {
                return 0;
            }
            return 2;
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return 0;
        }
    }

    @Override
    public boolean isSigned(int param) throws SQLServerException {
        this.checkClosed();
        try {
            if (this.rsProcedureMeta == null) {
                this.checkParam(param);
                return this.queryMetaMap.get((Object)Integer.valueOf((int)param)).isSigned;
            }
            this.verifyParameterPosition(param);
            return JDBCType.of(this.rsProcedureMeta.getShort("DATA_TYPE")).isSigned();
        }
        catch (SQLException e) {
            SQLServerException.makeFromDriverError(this.con, this.stmtParent, e.toString(), null, false);
            return false;
        }
    }

    String getTVPSchemaFromStoredProcedure(int param) throws SQLServerException {
        this.checkClosed();
        this.verifyParameterPosition(param);
        return this.rsProcedureMeta.getString("SS_TYPE_SCHEMA_NAME");
    }

    private class MetaInfo {
        String table;
        String fields;

        MetaInfo(String table, String fields) {
            this.table = table;
            this.fields = fields;
        }
    }

    class QueryMeta {
        String parameterClassName = null;
        int parameterType = 0;
        String parameterTypeName = null;
        int precision = 0;
        int scale = 0;
        int isNullable = 2;
        boolean isSigned = false;

        QueryMeta() {
        }
    }
}

