/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;

class ConfigurableRetryRule {
    private final String PLUS_SIGN = "+";
    private final String MULTIPLICATION_SIGN = "*";
    private final String COMMA = ",";
    private final String ZERO = "0";
    private String operand = "+";
    private int initialRetryTime = 0;
    private int retryChange = 2;
    private int retryCount = 1;
    private String retryQueries = "";
    private String retryError;
    boolean isConnection = false;
    boolean replaceExisting = false;
    private ArrayList<Integer> waitTimes = new ArrayList();

    ConfigurableRetryRule(String rule) throws SQLServerException {
        this.addElements(this.removeExtraElementsAndSplitRule(rule));
        this.calculateWaitTimes();
    }

    ConfigurableRetryRule(String newRule, ConfigurableRetryRule baseRule) {
        this.copyFromRule(baseRule);
        this.retryError = newRule;
    }

    private void copyFromRule(ConfigurableRetryRule baseRule) {
        this.retryError = baseRule.retryError;
        this.operand = baseRule.operand;
        this.initialRetryTime = baseRule.initialRetryTime;
        this.retryChange = baseRule.retryChange;
        this.retryCount = baseRule.retryCount;
        this.retryQueries = baseRule.retryQueries;
        this.waitTimes = baseRule.waitTimes;
        this.isConnection = baseRule.isConnection;
    }

    private String appendOrReplace(String retryError) {
        if (retryError.startsWith("+")) {
            this.replaceExisting = false;
            StringUtils.isNumeric(retryError.substring(1));
            return retryError.substring(1);
        }
        this.replaceExisting = true;
        return retryError;
    }

    private String[] removeExtraElementsAndSplitRule(String rule) {
        if (rule.endsWith(":")) {
            rule = rule + "0";
        }
        rule = rule.replace("{", "");
        rule = rule.replace("}", "");
        rule = rule.trim();
        return rule.split(":");
    }

    private void checkParameter(String value) throws SQLServerException {
        if (!StringUtils.isNumeric(value)) {
            String[] arr;
            for (String error : arr = value.split(",")) {
                if (StringUtils.isNumeric(error)) continue;
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
                Object[] msgArgs = new Object[]{error};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
            }
        }
    }

    private void addElements(String[] rule) throws SQLServerException {
        if (rule.length == 1) {
            String errorWithoutOptionalPrefix = this.appendOrReplace(rule[0]);
            this.checkParameter(errorWithoutOptionalPrefix);
            this.isConnection = true;
            this.retryError = errorWithoutOptionalPrefix;
        } else if (rule.length == 2 || rule.length == 3) {
            this.checkParameter(rule[0]);
            this.retryError = rule[0];
            String[] timings = rule[1].split(",");
            this.checkParameter(timings[0]);
            this.retryCount = Integer.parseInt(timings[0]);
            if (timings.length == 2) {
                if (timings[1].contains("*")) {
                    String[] initialAndChange = timings[1].split("\\*");
                    this.checkParameter(initialAndChange[0]);
                    this.initialRetryTime = Integer.parseInt(initialAndChange[0]);
                    this.operand = "*";
                    if (initialAndChange.length > 1) {
                        this.checkParameter(initialAndChange[1]);
                        this.retryChange = Integer.parseInt(initialAndChange[1]);
                    } else {
                        this.retryChange = this.initialRetryTime;
                    }
                } else if (timings[1].contains("+")) {
                    String[] initialAndChange = timings[1].split("\\+");
                    this.checkParameter(initialAndChange[0]);
                    this.initialRetryTime = Integer.parseInt(initialAndChange[0]);
                    this.operand = "+";
                    if (initialAndChange.length > 1) {
                        this.checkParameter(initialAndChange[1]);
                        this.retryChange = Integer.parseInt(initialAndChange[1]);
                    } else {
                        this.retryChange = 2;
                    }
                } else {
                    this.checkParameter(timings[1]);
                    this.initialRetryTime = Integer.parseInt(timings[1]);
                }
            } else if (timings.length > 2) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_invalidParameterNumber"));
                Object[] msgArgs = new Object[]{rule[1]};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
            }
            if (rule.length == 3) {
                this.retryQueries = rule[2].equals("0") ? "" : rule[2].toLowerCase();
            }
        } else {
            MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_InvalidRuleFormat"));
            Object[] msgArgs = new Object[]{rule.length};
            throw new SQLServerException(null, form.format(msgArgs), null, 0, true);
        }
    }

    private void calculateWaitTimes() {
        for (int i = 0; i < this.retryCount; ++i) {
            int waitTime = this.initialRetryTime;
            if (this.operand.equals("+")) {
                for (int j = 0; j < i; ++j) {
                    waitTime += this.retryChange;
                }
            } else if (this.operand.equals("*")) {
                for (int k = 0; k < i; ++k) {
                    waitTime *= this.retryChange;
                }
            }
            this.waitTimes.add(waitTime);
        }
    }

    String getError() {
        return this.retryError;
    }

    int getRetryCount() {
        return this.retryCount;
    }

    String getRetryQueries() {
        return this.retryQueries;
    }

    ArrayList<Integer> getWaitTimes() {
        return this.waitTimes;
    }
}

