/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import microsoft.sql.Vector;

class VectorUtils {
    private static final int VECTOR_HEADER_LENGTH = 8;
    private static final int BYTES_PER_FLOAT = 4;
    private static final byte SCALE_BYTE_FLOAT32 = 0;

    VectorUtils() {
    }

    static Vector fromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        byte vectorTypeByte = bytes[4];
        Vector.VectorDimensionType vectorType = VectorUtils.getVectorDimensionType(vectorTypeByte);
        int bytesPerDimension = VectorUtils.getBytesPerDimensionFromScale(vectorType);
        if (bytes.length < VectorUtils.getHeaderLength()) {
            throw VectorUtils.vectorException("R_vectorByteArrayLength", new Object[0]);
        }
        if ((bytes.length - VectorUtils.getHeaderLength()) % bytesPerDimension != 0) {
            throw VectorUtils.vectorException("R_vectorByteArrayMultipleOfBytesPerDimension", new Object[]{bytesPerDimension, vectorType});
        }
        int objectCount = (bytes.length - VectorUtils.getHeaderLength()) / bytesPerDimension;
        switch (vectorType) {
            default: 
        }
        Object[] objectArray = new Float[objectCount];
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)buffer).position(VectorUtils.getHeaderLength());
        for (int i = 0; i < objectCount; ++i) {
            objectArray[i] = Float.valueOf(buffer.getFloat());
        }
        return new Vector(objectCount, vectorType, objectArray);
    }

    static byte[] toBytes(Vector vector) {
        if (vector.getData() == null) {
            return null;
        }
        int payloadSize = VectorUtils.getVectorLength(vector);
        ByteBuffer buffer = ByteBuffer.allocate(payloadSize).order(ByteOrder.LITTLE_ENDIAN);
        buffer.put((byte)-87);
        buffer.put((byte)1);
        buffer.putShort((short)vector.getDimensionCount());
        buffer.put(VectorUtils.getScaleByte(vector.getVectorDimensionType()));
        buffer.put(new byte[3]);
        Object[] data = vector.getData();
        switch (vector.getVectorDimensionType()) {
            default: 
        }
        for (Object value : data) {
            buffer.putFloat(((Number)value).floatValue());
        }
        return buffer.array();
    }

    static int getDefaultPrecision() {
        return 4;
    }

    static int getHeaderLength() {
        return 8;
    }

    static Vector.VectorDimensionType getVectorDimensionType(int scaleByte) {
        switch (scaleByte) {
            case 0: {
                return Vector.VectorDimensionType.FLOAT32;
            }
        }
        return Vector.VectorDimensionType.FLOAT32;
    }

    static int getPrecision(int vectorLength, int scale) {
        return (vectorLength - VectorUtils.getHeaderLength()) / scale;
    }

    static int getBytesPerDimensionFromScale(int scaleByte) {
        switch (scaleByte) {
            case 0: {
                return 4;
            }
        }
        return 4;
    }

    static int getBytesPerDimensionFromScale(Vector.VectorDimensionType vectorType) {
        switch (vectorType) {
            default: 
        }
        return 4;
    }

    static byte getScaleByte(Vector.VectorDimensionType vectorType) {
        switch (vectorType) {
            default: 
        }
        return 0;
    }

    static byte getScaleByte(int scale) {
        switch (scale) {
            default: 
        }
        return 0;
    }

    static int getVectorLength(Vector vector) {
        switch (vector.getVectorDimensionType()) {
            default: 
        }
        int bytesPerDimension = 4;
        return VectorUtils.getHeaderLength() + bytesPerDimension * vector.getDimensionCount();
    }

    static int getVectorLength(int scale, int precision) {
        return VectorUtils.getHeaderLength() + scale * precision;
    }

    static String getTypeDefinition(Vector vector, int scale, boolean isOutput, int outScale, int valueLength) {
        int precision = 0;
        if (isOutput && scale < outScale) {
            precision = valueLength;
        } else if (vector != null) {
            precision = vector.getDimensionCount();
        }
        return "VECTOR(" + precision + ")";
    }

    private static Short floatToFloat16(Float value) {
        int bits = Float.floatToIntBits(value.floatValue());
        int sign = bits >>> 31 & 1;
        int exponent = bits >>> 23 & 0xFF;
        int mantissa = bits & 0x7FFFFF;
        if (exponent == 255) {
            if (mantissa != 0) {
                return (short)(sign << 15 | 0x7E00);
            }
            return (short)(sign << 15 | 0x7C00);
        }
        if ((bits & Integer.MAX_VALUE) == 0) {
            return (short)(sign << 15);
        }
        int halfExponent = exponent - 127 + 15;
        if (halfExponent >= 31) {
            return (short)(sign << 15 | 0x7C00);
        }
        if (halfExponent <= 0) {
            if (halfExponent < -10) {
                return (short)(sign << 15);
            }
            int shift = 1 - halfExponent;
            int mant = (mantissa |= 0x800000) >> shift + 13;
            int roundBit = mantissa >> shift + 12 & 1;
            int lostBits = mantissa & (1 << shift + 12) - 1;
            if (roundBit == 1 && (lostBits != 0 || (mant & 1) == 1)) {
                ++mant;
            }
            return (short)(sign << 15 | mant);
        }
        int mant = mantissa >> 13;
        int roundBit = mantissa >> 12 & 1;
        int lostBits = mantissa & 0xFFF;
        if (roundBit == 1 && (lostBits != 0 || (mant & 1) == 1) && ++mant == 1024) {
            mant = 0;
            if (++halfExponent >= 31) {
                return (short)(sign << 15 | 0x7C00);
            }
        }
        return (short)(sign << 15 | halfExponent << 10 | mant);
    }

    private static Float float16ToFloat(Short value) {
        int bits = value & 0xFFFF;
        int sign = bits >>> 15 & 1;
        int exponent = bits >>> 10 & 0x1F;
        int mantissa = bits & 0x3FF;
        if (exponent == 31) {
            if (mantissa == 0) {
                return Float.valueOf(Float.intBitsToFloat(sign << 31 | 0x7F800000));
            }
            return Float.valueOf(Float.NaN);
        }
        if (exponent == 0 && mantissa == 0) {
            return Float.valueOf(Float.intBitsToFloat(sign << 31));
        }
        if (exponent == 0) {
            while ((mantissa & 0x400) == 0) {
                mantissa <<= 1;
                --exponent;
            }
            mantissa &= 0x3FF;
            ++exponent;
        }
        int result = sign << 31 | (exponent += 112) << 23 | mantissa << 13;
        return Float.valueOf(Float.intBitsToFloat(result));
    }

    static Short[] serializeFloat16Array(Float[] float32) {
        if (float32 == null) {
            return null;
        }
        Short[] result = new Short[float32.length];
        for (int i = 0; i < float32.length; ++i) {
            result[i] = VectorUtils.floatToFloat16(float32[i]);
        }
        return result;
    }

    static Float[] deserializeFloat16Array(Short[] float16Values) {
        if (float16Values == null) {
            return null;
        }
        Float[] result = new Float[float16Values.length];
        for (int i = 0; i < float16Values.length; ++i) {
            result[i] = VectorUtils.float16ToFloat(float16Values[i]);
        }
        return result;
    }

    private static IllegalArgumentException vectorException(String resourceKey, Object ... args) {
        try {
            MessageFormat form = new MessageFormat(ResourceBundle.getBundle("com.microsoft.sqlserver.jdbc.SQLServerResource").getString(resourceKey));
            return new IllegalArgumentException(form.format(args));
        }
        catch (MissingResourceException e) {
            return new IllegalArgumentException("Missing resource: " + resourceKey);
        }
    }
}

