/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CekTableEntry;
import com.microsoft.sqlserver.jdbc.CryptoCache;
import com.microsoft.sqlserver.jdbc.CryptoMetadata;
import com.microsoft.sqlserver.jdbc.Parameter;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerDriverStringProperty;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSecurityUtility;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class ParameterMetaDataCache {
    static final int CACHE_SIZE = 2000;
    static final int CACHE_TRIM_THRESHOLD = 300;
    private static Logger metadataCacheLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.ParameterMetaDataCache");

    ParameterMetaDataCache() {
    }

    static boolean getQueryMetadata(Parameter[] params, ArrayList<String> parameterNames, CryptoCache cache, SQLServerConnection connection, SQLServerStatement stmt) throws SQLServerException {
        int i;
        AbstractMap.SimpleEntry<String, String> encryptionValues = ParameterMetaDataCache.getCacheLookupKeys(stmt, connection);
        ConcurrentHashMap<String, CryptoMetadata> metadataMap = cache.getCacheEntry(encryptionValues.getKey());
        if (metadataMap == null) {
            if (metadataCacheLogger.isLoggable(Level.FINEST)) {
                metadataCacheLogger.finest("Cache Miss. Unable to retrieve cache entry from cache.");
            }
            return false;
        }
        for (i = 0; i < params.length; ++i) {
            boolean found = metadataMap.containsKey(parameterNames.get(i));
            CryptoMetadata foundData = metadataMap.get(parameterNames.get(i));
            if (!found || foundData != null && foundData.isAlgorithmInitialized()) {
                for (Parameter param : params) {
                    param.cryptoMeta = null;
                }
                if (metadataCacheLogger.isLoggable(Level.FINEST)) {
                    metadataCacheLogger.finest("Cache Miss. Cache entry either has missing parameter or initialized algorithm.");
                }
                return false;
            }
            params[i].cryptoMeta = foundData;
        }
        for (i = 0; i < params.length; ++i) {
            try {
                CryptoMetadata cryptoCopy = null;
                CryptoMetadata metaData = params[i].getCryptoMetadata();
                if (metaData != null) {
                    cryptoCopy = new CryptoMetadata(metaData.getCekTableEntry(), metaData.getOrdinal(), metaData.getEncryptionAlgorithmId(), metaData.getEncryptionAlgorithmName(), metaData.getEncryptionType().getValue(), metaData.getNormalizationRuleVersion());
                }
                params[i].cryptoMeta = cryptoCopy;
                if (cryptoCopy == null) continue;
                try {
                    SQLServerSecurityUtility.decryptSymmetricKey(cryptoCopy, connection, stmt);
                    continue;
                }
                catch (SQLServerException e) {
                    ParameterMetaDataCache.removeCacheEntry(stmt, cache, connection);
                    for (Parameter paramToCleanup : params) {
                        paramToCleanup.cryptoMeta = null;
                    }
                    if (metadataCacheLogger.isLoggable(Level.FINEST)) {
                        metadataCacheLogger.finest("Cache Miss. Unable to decrypt CEK.");
                    }
                    return false;
                }
            }
            catch (Exception e) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_CryptoCacheInaccessible"));
                Object[] msgArgs = new Object[]{e.getMessage()};
                throw new SQLServerException(form.format(msgArgs), null);
            }
        }
        if (metadataCacheLogger.isLoggable(Level.FINEST)) {
            metadataCacheLogger.finest("Cache Hit. Successfully retrieved metadata from cache.");
        }
        return true;
    }

    static boolean addQueryMetadata(Parameter[] params, ArrayList<String> parameterNames, CryptoCache cache, SQLServerConnection connection, SQLServerStatement stmt, Map<Integer, CekTableEntry> cekList) throws SQLServerException {
        AbstractMap.SimpleEntry<String, String> encryptionValues = ParameterMetaDataCache.getCacheLookupKeys(stmt, connection);
        if (encryptionValues.getKey() == null) {
            return false;
        }
        ConcurrentHashMap<String, CryptoMetadata> metadataMap = new ConcurrentHashMap<String, CryptoMetadata>(params.length);
        for (int i = 0; i < params.length; ++i) {
            try {
                CryptoMetadata cryptoCopy = null;
                CryptoMetadata metaData = params[i].getCryptoMetadata();
                if (metaData != null) {
                    cryptoCopy = new CryptoMetadata(metaData.getCekTableEntry(), metaData.getOrdinal(), metaData.getEncryptionAlgorithmId(), metaData.getEncryptionAlgorithmName(), metaData.getEncryptionType().getValue(), metaData.getNormalizationRuleVersion());
                }
                if (cryptoCopy == null || cryptoCopy.isAlgorithmInitialized()) {
                    return false;
                }
                String paramName = parameterNames.get(i);
                metadataMap.put(paramName, cryptoCopy);
                continue;
            }
            catch (SQLServerException e) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_CryptoCacheInaccessible"));
                Object[] msgArgs = new Object[]{e.getMessage()};
                throw new SQLServerException(form.format(msgArgs), null);
            }
        }
        int cacheSizeCurrent = cache.getParamMap().size();
        if (cacheSizeCurrent > 2300) {
            int entriesToRemove = cacheSizeCurrent - 2000;
            ConcurrentHashMap<String, ConcurrentHashMap<String, CryptoMetadata>> newMap = new ConcurrentHashMap<String, ConcurrentHashMap<String, CryptoMetadata>>();
            ConcurrentHashMap<String, ConcurrentHashMap<String, CryptoMetadata>> oldMap = cache.getParamMap();
            int count = 0;
            for (Map.Entry<String, ConcurrentHashMap<String, CryptoMetadata>> entry : oldMap.entrySet()) {
                if (count >= entriesToRemove) {
                    newMap.put(entry.getKey(), entry.getValue());
                }
                ++count;
            }
            cache.replaceParamMap(newMap);
            if (metadataCacheLogger.isLoggable(Level.FINEST)) {
                metadataCacheLogger.finest("Cache successfully trimmed.");
            }
        }
        cache.addParamEntry(encryptionValues.getKey(), metadataMap);
        return true;
    }

    static void removeCacheEntry(SQLServerStatement stmt, CryptoCache cache, SQLServerConnection connection) {
        AbstractMap.SimpleEntry<String, String> encryptionValues = ParameterMetaDataCache.getCacheLookupKeys(stmt, connection);
        if (encryptionValues.getKey() == null) {
            return;
        }
        cache.removeParamEntry(encryptionValues.getKey());
    }

    private static AbstractMap.SimpleEntry<String, String> getCacheLookupKeys(SQLServerStatement statement, SQLServerConnection connection) {
        StringBuilder cacheLookupKeyBuilder = new StringBuilder();
        cacheLookupKeyBuilder.append(":::");
        String databaseName = connection.activeConnectionProperties.getProperty(SQLServerDriverStringProperty.DATABASE_NAME.toString());
        cacheLookupKeyBuilder.append(databaseName);
        cacheLookupKeyBuilder.append(":::");
        cacheLookupKeyBuilder.append(statement.toString());
        String cacheLookupKey = cacheLookupKeyBuilder.toString();
        String enclaveLookupKey = cacheLookupKeyBuilder.append(":::enclaveKeys").toString();
        return new AbstractMap.SimpleEntry<String, String>(cacheLookupKey, enclaveLookupKey);
    }
}

