/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ParseNodeFactory;
import com.microsoft.kiota.serialization.TextParseNode;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.stream.Collectors;

public class TextParseNodeFactory
implements ParseNodeFactory {
    private static final String validContentType = "text/plain";

    @Nonnull
    public String getValidContentType() {
        return validContentType;
    }

    @Nonnull
    public ParseNode getParseNode(@Nonnull String contentType, @Nonnull InputStream rawResponse) {
        String rawText;
        Objects.requireNonNull(contentType, "parameter contentType cannot be null");
        Objects.requireNonNull(rawResponse, "parameter rawResponse cannot be null");
        if (contentType.isEmpty()) {
            throw new NullPointerException("contentType cannot be empty");
        }
        if (!contentType.equals(validContentType)) {
            throw new IllegalArgumentException("expected a text/plain content type");
        }
        try (InputStreamReader reader = new InputStreamReader(rawResponse, StandardCharsets.UTF_8);
             BufferedReader buff = new BufferedReader(reader);){
            rawText = buff.lines().collect(Collectors.joining("\n"));
        }
        catch (IOException ex) {
            throw new RuntimeException("could not close the reader", ex);
        }
        return new TextParseNode(rawText);
    }
}

