/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.providers.oauth2;

import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;

public class OAuth2StrategyParameters {
    @Nullable
    private final transient IPlatformComponents mPlatformComponents;
    @Nullable
    private final transient AbstractAuthenticationScheme mAuthenticationScheme;
    @Nullable
    public final List<String> mChallengeTypes;
    private transient boolean mUsingOpenIdConfiguration;

    public void setUsingOpenIdConfiguration(boolean isUsingOpenIdConfiguration) {
        this.mUsingOpenIdConfiguration = isUsingOpenIdConfiguration;
    }

    OAuth2StrategyParameters(@Nullable IPlatformComponents platformComponents, @Nullable AbstractAuthenticationScheme authenticationScheme, @Nullable List<String> challengeTypes, boolean usingOpenIdConfiguration) {
        this.mPlatformComponents = platformComponents;
        this.mAuthenticationScheme = authenticationScheme;
        this.mChallengeTypes = challengeTypes;
        this.mUsingOpenIdConfiguration = usingOpenIdConfiguration;
    }

    public static OAuth2StrategyParametersBuilder builder() {
        return new OAuth2StrategyParametersBuilder();
    }

    @Nullable
    public IPlatformComponents getPlatformComponents() {
        return this.mPlatformComponents;
    }

    @Nullable
    public AbstractAuthenticationScheme getAuthenticationScheme() {
        return this.mAuthenticationScheme;
    }

    @Nullable
    public List<String> getChallengeTypes() {
        return this.mChallengeTypes;
    }

    public boolean isUsingOpenIdConfiguration() {
        return this.mUsingOpenIdConfiguration;
    }

    public static class OAuth2StrategyParametersBuilder {
        private IPlatformComponents platformComponents;
        private AbstractAuthenticationScheme authenticationScheme;
        private List<String> challengeTypes;
        private boolean usingOpenIdConfiguration;

        OAuth2StrategyParametersBuilder() {
        }

        public OAuth2StrategyParametersBuilder platformComponents(@Nullable IPlatformComponents platformComponents) {
            this.platformComponents = platformComponents;
            return this;
        }

        public OAuth2StrategyParametersBuilder authenticationScheme(@Nullable AbstractAuthenticationScheme authenticationScheme) {
            this.authenticationScheme = authenticationScheme;
            return this;
        }

        public OAuth2StrategyParametersBuilder challengeTypes(@Nullable List<String> challengeTypes) {
            this.challengeTypes = challengeTypes;
            return this;
        }

        public OAuth2StrategyParametersBuilder usingOpenIdConfiguration(boolean usingOpenIdConfiguration) {
            this.usingOpenIdConfiguration = usingOpenIdConfiguration;
            return this;
        }

        public OAuth2StrategyParameters build() {
            return new OAuth2StrategyParameters(this.platformComponents, this.authenticationScheme, this.challengeTypes, this.usingOpenIdConfiguration);
        }

        public String toString() {
            return "OAuth2StrategyParameters.OAuth2StrategyParametersBuilder(platformComponents=" + this.platformComponents + ", authenticationScheme=" + this.authenticationScheme + ", challengeTypes=" + this.challengeTypes + ", usingOpenIdConfiguration=" + this.usingOpenIdConfiguration + ")";
        }
    }
}

