/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.net;

import com.microsoft.identity.common.java.net.HttpClient;
import com.microsoft.identity.common.java.net.HttpResponse;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import lombok.NonNull;

public abstract class AbstractHttpClient
implements HttpClient {
    @Override
    public HttpResponse method(@NonNull String httpMethod, @NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        if (httpMethod == null) {
            throw new NullPointerException("httpMethod is marked non-null but is null");
        }
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.validateAndNormalizeMethod(httpMethod), requestUrl, requestHeaders, requestContent);
    }

    @Override
    public abstract HttpResponse method(@NonNull HttpClient.HttpMethod var1, @NonNull URL var2, @NonNull Map<String, String> var3, @Nullable byte[] var4) throws IOException;

    @Override
    public HttpResponse put(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.PUT, requestUrl, requestHeaders, requestContent);
    }

    @Override
    public HttpResponse patch(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.PATCH, requestUrl, requestHeaders, requestContent);
    }

    @Override
    public HttpResponse options(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.OPTIONS, requestUrl, requestHeaders, null);
    }

    @Override
    public HttpResponse post(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.POST, requestUrl, requestHeaders, requestContent);
    }

    @Override
    public HttpResponse delete(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders, @Nullable byte[] requestContent) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.DELETE, requestUrl, requestHeaders, requestContent);
    }

    @Override
    public HttpResponse get(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.GET, requestUrl, requestHeaders, null);
    }

    @Override
    public HttpResponse head(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.HEAD, requestUrl, requestHeaders, null);
    }

    @Override
    public HttpResponse trace(@NonNull URL requestUrl, @NonNull Map<String, String> requestHeaders) throws IOException {
        if (requestUrl == null) {
            throw new NullPointerException("requestUrl is marked non-null but is null");
        }
        if (requestHeaders == null) {
            throw new NullPointerException("requestHeaders is marked non-null but is null");
        }
        return this.method(HttpClient.HttpMethod.TRACE, requestUrl, requestHeaders, null);
    }
}

