/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signup;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010$\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\u008f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u001a\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b\u0012\u001a\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u0005H\u0016J\b\u0010\"\u001a\u00020\u0005H\u0016R\u0018\u0010\u000b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R*\u0010\n\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0018\u0010\u000f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R*\u0010\u0007\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "unverifiedAttributes", "", "", "invalidAttributes", "challengeType", "error", "errorCodes", "errorDescription", "subError", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;)V", "getChallengeType", "()Ljava/lang/String;", "getContinuationToken", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getInvalidAttributes", "getStatusCode", "()I", "setStatusCode", "(I)V", "getSubError", "getUnverifiedAttributes", "toResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignUpStartApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @Expose
    @SerializedName(value="unverified_attributes")
    @Nullable
    private final List<Map<String, String>> unverifiedAttributes;
    @Expose
    @SerializedName(value="invalid_attributes")
    @Nullable
    private final List<Map<String, String>> invalidAttributes;
    @Expose
    @SerializedName(value="challenge_type")
    @Nullable
    private final String challengeType;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="suberror")
    @Nullable
    private final String subError;
    private static final String TAG = SignUpStartApiResponse.class.getSimpleName();

    public SignUpStartApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable List<? extends Map<String, String>> unverifiedAttributes, @Nullable List<? extends Map<String, String>> invalidAttributes, @Nullable String challengeType, @Nullable String error, @Nullable List<Integer> errorCodes, @Nullable String errorDescription, @Nullable String subError) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.unverifiedAttributes = unverifiedAttributes;
        this.invalidAttributes = invalidAttributes;
        this.challengeType = challengeType;
        this.error = error;
        this.errorCodes = errorCodes;
        this.errorDescription = errorDescription;
        this.subError = subError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final List<Map<String, String>> getUnverifiedAttributes() {
        return this.unverifiedAttributes;
    }

    @Nullable
    public final List<Map<String, String>> getInvalidAttributes() {
        return this.invalidAttributes;
    }

    @Nullable
    public final String getChallengeType() {
        return this.challengeType;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getSubError() {
        return this.subError;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignUpStartApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", challengeType=" + this.challengeType + "error=" + this.error + ", errorCodes=" + this.errorCodes + ", errorDescription=" + this.errorDescription + ", subError=" + this.subError + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignUpContinueApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignUpStartApiResult toResult() {
        SignUpStartApiResult signUpStartApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        switch (this.getStatusCode()) {
            case 400: {
                ApiResult apiResult;
                if (ApiErrorResponseUtilKt.isUserAlreadyExists(this.error)) {
                    String string2;
                    String string3 = this.error;
                    if (string3 == null) {
                        string3 = "";
                    }
                    if ((string2 = this.errorDescription) == null) {
                        string2 = "";
                    }
                    apiResult = new SignUpStartApiResult.UsernameAlreadyExists(string3, string2, this.getCorrelationId());
                } else {
                    List<Integer> list = this.errorCodes;
                    boolean bl = ApiErrorResponseUtilKt.isInvalidParameter(list != null ? list.get(0) : null);
                    String string4 = this.errorDescription;
                    boolean bl2 = string4 != null ? ApiErrorResponseUtilKt.isInvalidUsername(string4) : false;
                    if (bl & bl2) {
                        String string5;
                        String string6 = this.error;
                        if (string6 == null) {
                            string6 = "";
                        }
                        if ((string5 = this.errorDescription) == null) {
                            string5 = "";
                        }
                        apiResult = new SignUpStartApiResult.InvalidUsername(string6, string5, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isAuthNotSupported(this.error)) {
                        String string7;
                        String string8 = this.error;
                        if (string8 == null) {
                            string8 = "";
                        }
                        if ((string7 = this.errorDescription) == null) {
                            string7 = "";
                        }
                        apiResult = new SignUpStartApiResult.AuthNotSupported(string8, string7, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isAttributeValidationFailed(this.subError)) {
                        List<Object> list2;
                        String string9;
                        String string10;
                        String string11;
                        String string12 = this.error;
                        if (string12 == null) {
                            string12 = string11 = "";
                        }
                        if ((string10 = this.errorDescription) == null) {
                            string10 = string9 = "";
                        }
                        if ((list2 = this.invalidAttributes) == null || (list2 = ApiErrorResponseUtilKt.toAttributeList(list2)) == null) {
                            return new SignUpStartApiResult.UnknownError(ApiErrorResult.Companion.getINVALID_STATE(), "SignUp /start did not return a invalid_attributes with validation_failed error", this.getCorrelationId());
                        }
                        List<Object> list3 = list2;
                        String string13 = this.subError;
                        if (string13 == null) {
                            string13 = "";
                        }
                        String string14 = string13;
                        String string15 = this.getCorrelationId();
                        apiResult = new SignUpStartApiResult.InvalidAttributes(string15, string11, string9, list3, string14);
                    } else if (ApiErrorResponseUtilKt.isUnsupportedChallengeType(this.error)) {
                        String string16;
                        String string17 = this.error;
                        if (string17 == null) {
                            string17 = "";
                        }
                        if ((string16 = this.errorDescription) == null) {
                            string16 = "";
                        }
                        apiResult = new SignUpStartApiResult.UnsupportedChallengeType(string17, string16, this.getCorrelationId());
                    } else if (ApiErrorResponseUtilKt.isPasswordTooWeak(this.subError) || ApiErrorResponseUtilKt.isPasswordTooLong(this.subError) || ApiErrorResponseUtilKt.isPasswordTooShort(this.subError) || ApiErrorResponseUtilKt.isPasswordBanned(this.subError) || ApiErrorResponseUtilKt.isPasswordRecentlyUsed(this.subError) || ApiErrorResponseUtilKt.isPasswordInvalid(this.subError)) {
                        String string18;
                        String string19;
                        String string20;
                        String string21;
                        String string22 = this.error;
                        if (string22 == null) {
                            string22 = string21 = "";
                        }
                        if ((string20 = this.errorDescription) == null) {
                            string20 = string19 = "";
                        }
                        if ((string18 = this.subError) == null) {
                            string18 = "";
                        }
                        String string23 = string18;
                        String string24 = this.getCorrelationId();
                        apiResult = new SignUpStartApiResult.InvalidPassword(string24, string21, string19, string23);
                    } else {
                        String string25;
                        String string26 = this.error;
                        if (string26 == null) {
                            string26 = "";
                        }
                        if ((string25 = this.errorDescription) == null) {
                            string25 = "";
                        }
                        apiResult = new SignUpStartApiResult.UnknownError(string26, string25, this.getCorrelationId());
                    }
                }
                signUpStartApiResult = (SignUpStartApiResult)apiResult;
                break;
            }
            case 200: {
                if (ApiErrorResponseUtilKt.isRedirect(this.challengeType)) {
                    signUpStartApiResult = new SignUpStartApiResult.Redirect(this.getCorrelationId());
                    break;
                }
                String string27 = this.continuationToken;
                if (string27 == null) {
                    return new SignUpStartApiResult.UnknownError("invalid_state", "Sign up /start did not return a continuation token", this.getCorrelationId());
                }
                signUpStartApiResult = new SignUpStartApiResult.Success(string27, this.getCorrelationId());
                break;
            }
            default: {
                String string28;
                String string29 = this.error;
                if (string29 == null) {
                    string29 = "";
                }
                if ((string28 = this.errorDescription) == null) {
                    string28 = "";
                }
                signUpStartApiResult = new SignUpStartApiResult.UnknownError(string29, string28, this.getCorrelationId());
            }
        }
        return signUpStartApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

