/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.nativeauth.providers.responses.signin;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.nativeauth.providers.IApiResponse;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.nativeauth.util.ApiErrorResponseUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\u0005H\u0016R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u001e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0018\u0010\b\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\t\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u001e\u0010\u0002\u001a\u00020\u00038\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0018\u0010\f\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResponse;", "Lcom/microsoft/identity/common/java/nativeauth/providers/IApiResponse;", "statusCode", "", "correlationId", "", "continuationToken", "error", "errorDescription", "errorUri", "errorCodes", "", "subError", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getContinuationToken", "()Ljava/lang/String;", "getError", "getErrorCodes", "()Ljava/util/List;", "getErrorDescription", "getErrorUri", "getStatusCode", "()I", "setStatusCode", "(I)V", "getSubError", "toErrorResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "toString", "toUnsanitizedString", "Companion", "common4j"})
public final class SignInTokenApiResponse
extends IApiResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Expose
    private int statusCode;
    @SerializedName(value="continuation_token")
    @Nullable
    private final String continuationToken;
    @SerializedName(value="error")
    @Nullable
    private final String error;
    @SerializedName(value="error_description")
    @Nullable
    private final String errorDescription;
    @SerializedName(value="error_uri")
    @Nullable
    private final String errorUri;
    @SerializedName(value="error_codes")
    @Nullable
    private final List<Integer> errorCodes;
    @SerializedName(value="suberror")
    @Nullable
    private final String subError;
    private static final String TAG = SignInTokenApiResponse.class.getSimpleName();

    public SignInTokenApiResponse(int statusCode, @NotNull String correlationId, @Nullable String continuationToken, @Nullable String error, @Nullable String errorDescription, @Nullable String errorUri, @Nullable List<Integer> errorCodes, @Nullable String subError) {
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        super(statusCode, correlationId);
        this.statusCode = statusCode;
        this.continuationToken = continuationToken;
        this.error = error;
        this.errorDescription = errorDescription;
        this.errorUri = errorUri;
        this.errorCodes = errorCodes;
        this.subError = subError;
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(int n) {
        this.statusCode = n;
    }

    @Nullable
    public final String getContinuationToken() {
        return this.continuationToken;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    @Nullable
    public final String getErrorDescription() {
        return this.errorDescription;
    }

    @Nullable
    public final String getErrorUri() {
        return this.errorUri;
    }

    @Nullable
    public final List<Integer> getErrorCodes() {
        return this.errorCodes;
    }

    @Nullable
    public final String getSubError() {
        return this.subError;
    }

    @Override
    @NotNull
    public String toUnsanitizedString() {
        return "SignInTokenApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId() + ", error=" + this.error + ", errorDescription=" + this.errorDescription + ", errorCodes=" + this.errorCodes + ", errorUri=" + this.errorUri + ", subError=" + this.subError + ')';
    }

    @Override
    @NotNull
    public String toString() {
        return "SignInTokenApiResponse(statusCode=" + this.getStatusCode() + ", correlationId=" + this.getCorrelationId();
    }

    @NotNull
    public final SignInTokenApiResult toErrorResult() {
        SignInTokenApiResult signInTokenApiResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".toResult");
        if (ApiErrorResponseUtilKt.isInvalidRequest(this.error)) {
            SignInTokenApiResult signInTokenApiResult2;
            Object object = this.errorCodes;
            if (object == null || object.isEmpty()) {
                List list;
                String string2;
                String string3;
                Object object2 = this.error;
                if (object2 == null) {
                    object2 = object = "";
                }
                if ((string3 = this.errorDescription) == null) {
                    string3 = string2 = "";
                }
                if ((list = this.errorCodes) == null) {
                    list = CollectionsKt.emptyList();
                }
                List list2 = list;
                String string4 = this.getCorrelationId();
                signInTokenApiResult2 = new SignInTokenApiResult.UnknownError(string4, (String)object, string2, list2);
            } else {
                String string5;
                Object object3 = this.error;
                if (object3 == null) {
                    object3 = object = "";
                }
                if ((string5 = this.errorDescription) == null) {
                    string5 = "";
                }
                String string6 = string5;
                List<Integer> list = this.errorCodes;
                String string7 = this.getCorrelationId();
                signInTokenApiResult2 = new SignInTokenApiResult.UnknownError(string7, (String)object, string6, list);
            }
            return signInTokenApiResult2;
        }
        if (ApiErrorResponseUtilKt.isInvalidGrant(this.error)) {
            SignInTokenApiResult signInTokenApiResult3;
            Object object = this.errorCodes;
            if (object == null || object.isEmpty()) {
                List list;
                String string8;
                String string9;
                Object object4 = this.error;
                if (object4 == null) {
                    object4 = object = "";
                }
                if ((string9 = this.errorDescription) == null) {
                    string9 = string8 = "";
                }
                if ((list = this.errorCodes) == null) {
                    list = CollectionsKt.emptyList();
                }
                List list3 = list;
                String string10 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.UnknownError(string10, (String)object, string8, list3);
            } else if (ApiErrorResponseUtilKt.isInvalidCredentials(this.errorCodes.get(0))) {
                String string11;
                Object object5 = this.error;
                if (object5 == null) {
                    object5 = object = "";
                }
                if ((string11 = this.errorDescription) == null) {
                    string11 = "";
                }
                String string12 = string11;
                List<Integer> list = this.errorCodes;
                String string13 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.InvalidCredentials(string13, (String)object, string12, list);
            } else if (ApiErrorResponseUtilKt.isMFARequired(this.errorCodes.get(0))) {
                String string14;
                Object object6 = this.error;
                if (object6 == null) {
                    object6 = object = "";
                }
                if ((string14 = this.errorDescription) == null) {
                    string14 = "";
                }
                String string15 = string14;
                List<Integer> list = this.errorCodes;
                String string16 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.MFARequired(string16, (String)object, string15, list);
            } else if (ApiErrorResponseUtilKt.isInvalidOOBValue(this.subError)) {
                String string17;
                Object object7 = this.error;
                if (object7 == null) {
                    object7 = object = "";
                }
                if ((string17 = this.errorDescription) == null) {
                    string17 = "";
                }
                String string18 = string17;
                List<Integer> list = this.errorCodes;
                String string19 = this.subError;
                if (string19 == null) {
                    string19 = "";
                }
                String string20 = string19;
                String string21 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.CodeIncorrect(string21, (String)object, string18, list, string20);
            } else if (ApiErrorResponseUtilKt.isInvalidAuthenticationType(this.errorCodes.get(0))) {
                String string22;
                Object object8 = this.error;
                if (object8 == null) {
                    object8 = object = "";
                }
                if ((string22 = this.errorDescription) == null) {
                    string22 = "";
                }
                String string23 = string22;
                List<Integer> list = this.errorCodes;
                String string24 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.InvalidAuthenticationType(string24, (String)object, string23, list);
            } else {
                String string25;
                Object object9 = this.error;
                if (object9 == null) {
                    object9 = object = "";
                }
                if ((string25 = this.errorDescription) == null) {
                    string25 = "";
                }
                String string26 = string25;
                List<Integer> list = this.errorCodes;
                String string27 = this.getCorrelationId();
                signInTokenApiResult3 = new SignInTokenApiResult.UnknownError(string27, (String)object, string26, list);
            }
            return signInTokenApiResult3;
        }
        if (ApiErrorResponseUtilKt.isUserNotFound(this.error)) {
            List list;
            String string28;
            String string29;
            String string30;
            String string31 = this.error;
            if (string31 == null) {
                string31 = string30 = "";
            }
            if ((string29 = this.errorDescription) == null) {
                string29 = string28 = "";
            }
            if ((list = this.errorCodes) == null) {
                list = CollectionsKt.emptyList();
            }
            List list4 = list;
            String string32 = this.getCorrelationId();
            signInTokenApiResult = new SignInTokenApiResult.UserNotFound(string32, string30, string28, list4);
        } else {
            List list;
            String string33;
            String string34;
            String string35;
            String string36 = this.error;
            if (string36 == null) {
                string36 = string35 = "";
            }
            if ((string34 = this.errorDescription) == null) {
                string34 = string33 = "";
            }
            if ((list = this.errorCodes) == null) {
                list = CollectionsKt.emptyList();
            }
            List list5 = list;
            String string37 = this.getCorrelationId();
            signInTokenApiResult = new SignInTokenApiResult.UnknownError(string37, string35, string33, list5);
        }
        return signInTokenApiResult;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResponse$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

