/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.crypto;

import com.microsoft.identity.common.java.crypto.ICryptoFactory;
import com.microsoft.identity.common.java.crypto.IEncryptor;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.CryptoFactoryTelemetryHelper;
import com.microsoft.identity.common.java.opentelemetry.CryptoObjectName;
import com.microsoft.identity.common.java.opentelemetry.ICryptoOperation;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import lombok.NonNull;

public class BasicEncryptor
implements IEncryptor {
    private final ICryptoFactory mCryptoFactory;

    @Override
    public byte[] encryptWithIv(final @NonNull Key key, final @NonNull String encryptAlgorithm, final byte[] iv, final byte[] dataToBeEncrypted) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptAlgorithm == null) {
            throw new NullPointerException("encryptAlgorithm is marked non-null but is null");
        }
        return CryptoFactoryTelemetryHelper.performCryptoOperationAndUploadTelemetry(CryptoObjectName.Cipher, encryptAlgorithm, this.mCryptoFactory, new ICryptoOperation<byte[]>(){

            @Override
            public byte[] perform() throws ClientException {
                return BasicEncryptor.this.encryptWithIvInternal(key, encryptAlgorithm, iv, dataToBeEncrypted);
            }
        });
    }

    @Override
    public byte[] encryptWithGcm(final @NonNull Key key, final @NonNull String encryptAlgorithm, final byte[] iv, final byte[] dataToBeEncrypted, final int tagLength, final byte[] aad) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptAlgorithm == null) {
            throw new NullPointerException("encryptAlgorithm is marked non-null but is null");
        }
        return CryptoFactoryTelemetryHelper.performCryptoOperationAndUploadTelemetry(CryptoObjectName.Cipher, encryptAlgorithm, this.mCryptoFactory, new ICryptoOperation<byte[]>(){

            @Override
            public byte[] perform() throws ClientException {
                return BasicEncryptor.this.encryptWithGcmInternal(key, encryptAlgorithm, iv, dataToBeEncrypted, tagLength, aad);
            }
        });
    }

    private byte[] encryptWithIvInternal(@NonNull Key key, @NonNull String encryptAlgorithm, byte[] iv, byte[] dataToBeEncrypted) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptAlgorithm == null) {
            throw new NullPointerException("encryptAlgorithm is marked non-null but is null");
        }
        Cipher cipher = this.mCryptoFactory.getCipher(encryptAlgorithm);
        try {
            if (iv != null && iv.length > 0) {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher.init(1, key, ivSpec);
            } else {
                cipher.init(1, key);
            }
            return cipher.doFinal(dataToBeEncrypted);
        }
        catch (BadPaddingException e) {
            throw new ClientException("bad_padding", e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ClientException("invalid_block_size", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ClientException("invalid_algorithm_parameter", e.getMessage(), e);
        }
    }

    private byte[] encryptWithGcmInternal(@NonNull Key key, @NonNull String encryptAlgorithm, byte[] iv, byte[] dataToBeEncrypted, int tagLength, byte[] aad) throws ClientException {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (encryptAlgorithm == null) {
            throw new NullPointerException("encryptAlgorithm is marked non-null but is null");
        }
        Cipher cipher = this.mCryptoFactory.getCipher(encryptAlgorithm);
        try {
            GCMParameterSpec ivSpec = new GCMParameterSpec(tagLength * 8, iv);
            cipher.init(1, key, ivSpec);
            if (aad != null) {
                cipher.updateAAD(aad);
            }
            return cipher.doFinal(dataToBeEncrypted);
        }
        catch (BadPaddingException e) {
            throw new ClientException("bad_padding", e.getMessage(), e);
        }
        catch (IllegalBlockSizeException e) {
            throw new ClientException("invalid_block_size", e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new ClientException("invalid_key", e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new ClientException("invalid_algorithm_parameter", e.getMessage(), e);
        }
    }

    public BasicEncryptor(ICryptoFactory mCryptoFactory) {
        this.mCryptoFactory = mCryptoFactory;
    }
}

