/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.controllers;

import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.controllers.CommandResultCacheItem;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommandResultCache {
    private static final int DEFAULT_ITEM_COUNT = 250;
    private final Object cacheLock = new Object();
    private final Map<BaseCommand, CommandResultCacheItem> mCache;

    public CommandResultCache() {
        this(250);
    }

    public CommandResultCache(final int maxItemCount) {
        this.mCache = new LinkedHashMap<BaseCommand, CommandResultCacheItem>(maxItemCount + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<BaseCommand, CommandResultCacheItem> eldest) {
                return this.size() > maxItemCount;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult get(BaseCommand key) {
        Object object = this.cacheLock;
        synchronized (object) {
            CommandResultCacheItem item = this.mCache.get(key);
            if (item != null) {
                if (item.isExpired()) {
                    this.mCache.remove(key);
                    return null;
                }
                return item.getValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(BaseCommand key, CommandResult value) {
        Object object = this.cacheLock;
        synchronized (object) {
            CommandResultCacheItem cacheItem = new CommandResultCacheItem(value);
            this.mCache.put(key, cacheItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSize() {
        Object object = this.cacheLock;
        synchronized (object) {
            return this.mCache.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.cacheLock;
        synchronized (object) {
            this.mCache.clear();
        }
    }
}

