/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import lombok.NonNull;

public class DeviceCodeFlowAuthResultCommand
extends BaseCommand<AuthorizationResult> {
    private static final String TAG = DeviceCodeFlowAuthResultCommand.class.getSimpleName();
    public static final String DEVICE_ID_CLAIM = "deviceid";

    public DeviceCodeFlowAuthResultCommand(@NonNull DeviceCodeFlowCommandParameters parameters, @NonNull IControllerFactory controllerFactory, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        super(parameters, controllerFactory, callback, publicApiId);
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
    }

    @Override
    public AuthorizationResult execute() throws Exception {
        String methodTag = TAG + ":execute";
        Logger.verbose(methodTag, "Device Code Flow command initiating...");
        Span span = OTelUtility.createSpanFromParent(SpanName.AcquireTokenDcfAuthRequest.name(), this.getParameters().getSpanContext());
        span.setAttribute(AttributeName.application_name.name(), this.getParameters().getApplicationName());
        span.setAttribute(AttributeName.public_api_id.name(), this.getPublicApiId());
        try {
            AuthorizationResult authorizationResult;
            block18: {
                Scope scope = SpanExtension.makeCurrentSpan(span);
                try {
                    BaseController controller = this.getControllerFactory().getDefaultController();
                    span.setAttribute(AttributeName.controller_name.name(), controller.getClass().getSimpleName());
                    DeviceCodeFlowCommandParameters commandParameters = (DeviceCodeFlowCommandParameters)this.getParameters();
                    boolean isDeviceIdClaimsRequested = commandParameters.getClaimsRequestJson() != null && commandParameters.getClaimsRequestJson().contains(DEVICE_ID_CLAIM);
                    span.setAttribute(AttributeName.is_device_id_claims_requested.name(), isDeviceIdClaimsRequested);
                    Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(commandParameters.getAuthority());
                    if (!authorityResult.getKnown()) {
                        throw authorityResult.getClientException();
                    }
                    AuthorizationResult authorizationResult2 = controller.deviceCodeFlowAuthRequest(commandParameters);
                    if (authorizationResult2 == null) {
                        span.setStatus(StatusCode.ERROR, "empty result");
                    } else if (authorizationResult2.getSuccess()) {
                        span.setStatus(StatusCode.OK);
                    } else {
                        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
                        acquireTokenResult.setAuthorizationResult(authorizationResult2);
                        BaseException exception = ExceptionAdapter.exceptionFromAcquireTokenResult(acquireTokenResult, this.getParameters());
                        if (exception != null) {
                            span.recordException((Throwable)exception);
                            span.setStatus(StatusCode.ERROR);
                        } else {
                            span.setStatus(StatusCode.ERROR, "empty exception");
                        }
                    }
                    authorizationResult = authorizationResult2;
                    if (scope == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable throwable3) {
                        span.setStatus(StatusCode.ERROR);
                        span.recordException(throwable3);
                        throw throwable3;
                    }
                }
                scope.close();
            }
            return authorizationResult;
        }
        finally {
            span.end();
        }
    }

    @Override
    public boolean isEligibleForEstsTelemetry() {
        return true;
    }
}

