/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.commands;

import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.ICommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
public abstract class BaseCommand<T>
implements ICommand<T> {
    @NonNull
    private final CommandParameters parameters;
    @NonNull
    private final CommandCallback callback;
    @NonNull
    private final String publicApiId;
    @NonNull
    private final IControllerFactory controllerFactory;

    public BaseCommand(@NonNull CommandParameters parameters, @NonNull IControllerFactory controllerFactory, @NonNull CommandCallback callback, @NonNull String publicApiId) {
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        if (publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
        this.parameters = parameters;
        this.callback = callback;
        this.controllerFactory = controllerFactory;
        this.publicApiId = publicApiId;
    }

    @Override
    public abstract T execute() throws Exception;

    @Override
    public boolean isEligibleForCaching() {
        return false;
    }

    @Override
    public String getCorrelationId() {
        return this.getParameters().getCorrelationId();
    }

    @Override
    public boolean willReachTokenEndpoint() {
        return false;
    }

    protected BaseCommand(BaseCommandBuilder<T, ?, ?> b) {
        this.parameters = ((BaseCommandBuilder)b).parameters;
        if (this.parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.callback = ((BaseCommandBuilder)b).callback;
        if (this.callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.publicApiId = ((BaseCommandBuilder)b).publicApiId;
        if (this.publicApiId == null) {
            throw new NullPointerException("publicApiId is marked non-null but is null");
        }
        this.controllerFactory = ((BaseCommandBuilder)b).controllerFactory;
        if (this.controllerFactory == null) {
            throw new NullPointerException("controllerFactory is marked non-null but is null");
        }
    }

    @NonNull
    public CommandParameters getParameters() {
        return this.parameters;
    }

    @NonNull
    public CommandCallback getCallback() {
        return this.callback;
    }

    @NonNull
    public String getPublicApiId() {
        return this.publicApiId;
    }

    @NonNull
    public IControllerFactory getControllerFactory() {
        return this.controllerFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseCommand)) {
            return false;
        }
        BaseCommand other = (BaseCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommandParameters this$parameters = this.getParameters();
        CommandParameters other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandParameters $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    public static abstract class BaseCommandBuilder<T, C extends BaseCommand<T>, B extends BaseCommandBuilder<T, C, B>> {
        private CommandParameters parameters;
        private CommandCallback callback;
        private String publicApiId;
        private IControllerFactory controllerFactory;

        protected B $fillValuesFrom(C instance) {
            BaseCommandBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <T> void $fillValuesFromInstanceIntoBuilder(BaseCommand<T> instance, BaseCommandBuilder<T, ?, ?> b) {
            b.parameters(((BaseCommand)instance).parameters);
            b.callback(((BaseCommand)instance).callback);
            b.publicApiId(((BaseCommand)instance).publicApiId);
            b.controllerFactory(((BaseCommand)instance).controllerFactory);
        }

        protected abstract B self();

        public abstract C build();

        public B parameters(@NonNull CommandParameters parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters is marked non-null but is null");
            }
            this.parameters = parameters;
            return this.self();
        }

        public B callback(@NonNull CommandCallback callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this.self();
        }

        public B publicApiId(@NonNull String publicApiId) {
            if (publicApiId == null) {
                throw new NullPointerException("publicApiId is marked non-null but is null");
            }
            this.publicApiId = publicApiId;
            return this.self();
        }

        public B controllerFactory(@NonNull IControllerFactory controllerFactory) {
            if (controllerFactory == null) {
                throw new NullPointerException("controllerFactory is marked non-null but is null");
            }
            this.controllerFactory = controllerFactory;
            return this.self();
        }

        public String toString() {
            return "BaseCommand.BaseCommandBuilder(parameters=" + this.parameters + ", callback=" + this.callback + ", publicApiId=" + this.publicApiId + ", controllerFactory=" + this.controllerFactory + ")";
        }
    }
}

