/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.cache;

import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.java.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.java.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.java.cache.NameValueStorageFileManagerSimpleCacheImpl;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.util.StringUtil;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"}, justification="Lombok inserts more null checks than we need")
public class NameValueStorageBrokerApplicationMetadataCache
extends NameValueStorageFileManagerSimpleCacheImpl<BrokerApplicationMetadata>
implements IBrokerApplicationMetadataCache {
    private static final String TAG = NameValueStorageBrokerApplicationMetadataCache.class.getSimpleName();
    private static final String DEFAULT_APP_METADATA_CACHE_NAME = "com.microsoft.identity.app-meta-cache";
    private static final String KEY_CACHE_LIST = "app-meta-cache";

    public NameValueStorageBrokerApplicationMetadataCache(@NonNull IPlatformComponents context) {
        super(context, DEFAULT_APP_METADATA_CACHE_NAME, KEY_CACHE_LIST, true);
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
    }

    @Override
    public Set<String> getAllClientIds() {
        String methodName = ":getAllClientIds";
        HashSet<String> allClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            allClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllClientIds", "Found [" + allClientIds.size() + "] client ids.");
        return allClientIds;
    }

    @Override
    public Set<String> getAllFociClientIds() {
        return this.getAllFociClientIds(false);
    }

    @Override
    public Set<String> getAllNonFociClientIds() {
        return this.getAllFociClientIds(true);
    }

    @Override
    public List<BrokerApplicationMetadata> getAllFociApplicationMetadata() {
        Set<String> fociClientIds = this.getAllFociClientIds();
        ArrayList<BrokerApplicationMetadata> result = new ArrayList<BrokerApplicationMetadata>();
        List allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!fociClientIds.contains(metadata.getClientId())) continue;
            result.add(metadata);
        }
        return result;
    }

    private Set<String> getAllFociClientIds(boolean inverseMatch) {
        String methodName = ":getAllFociClientIds";
        HashSet<String> allFociClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            if (!inverseMatch) {
                if (StringUtil.isNullOrEmpty(metadata.getFoci())) continue;
                allFociClientIds.add(metadata.getClientId());
                continue;
            }
            if (!StringUtil.isNullOrEmpty(metadata.getFoci())) continue;
            allFociClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllFociClientIds", "Found [" + allFociClientIds.size() + "] client ids.");
        return allFociClientIds;
    }

    @Override
    @Nullable
    public BrokerApplicationMetadata getMetadata(@NonNull String clientId, @NonNull String environment, int processUid) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
        String methodName = ":getMetadata";
        List allMetadata = this.getAll();
        BrokerApplicationMetadata result = null;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId()) || !environment.equals(metadata.getEnvironment()) || processUid != metadata.getUid()) continue;
            Logger.verbose(TAG + metadata, "Metadata located.");
            result = metadata;
            break;
        }
        if (null == result) {
            Logger.warn(TAG + ":getMetadata", "Metadata could not be found for clientId, environment: [" + clientId + ", " + environment + "]");
        }
        return result;
    }

    public void remove(@NonNull String clientId, int processUid) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        List allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equalsIgnoreCase(metadata.getClientId()) || processUid != metadata.getUid()) continue;
            this.remove(metadata);
        }
    }

    @Override
    public Type getListTypeToken() {
        return TypeToken.getParameterized(List.class, (Type[])new Type[]{BrokerApplicationMetadata.class}).getType();
    }
}

