/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.java.authorities;

import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import lombok.NonNull;

public class CIAMAuthority
extends Authority {
    private static final transient String TAG = CIAMAuthority.class.getSimpleName();
    private final boolean CIAM_USE_OPENID_CONFIGURATION = true;
    public static final String CIAM_LOGIN_URL_SEGMENT = "ciamlogin.com";

    public CIAMAuthority(@NonNull String authorityUrl) {
        if (authorityUrl == null) {
            throw new NullPointerException("authorityUrl is marked non-null but is null");
        }
        this.mAuthorityTypeString = "CIAM";
        this.mAuthorityUrlString = authorityUrl;
    }

    private MicrosoftStsOAuth2Configuration createOAuth2Configuration() {
        String methodName = ":createOAuth2Configuration";
        Logger.verbose(TAG + ":createOAuth2Configuration", "Creating OAuth2Configuration");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setAuthorityUrl(this.getAuthorityURL());
        config.setMultipleCloudsSupported(false);
        if (this.mSlice != null) {
            Logger.info(TAG + ":createOAuth2Configuration", "Setting slice parameters...");
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            slice.setSlice(this.mSlice.getSlice());
            slice.setDataCenter(this.mSlice.getDataCenter());
            config.setSlice(slice);
        }
        return config;
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy(OAuth2StrategyParameters parameters) throws ClientException {
        MicrosoftStsOAuth2Configuration config = this.createOAuth2Configuration();
        parameters.setUsingOpenIdConfiguration(true);
        MicrosoftStsOAuth2Strategy strategy = new MicrosoftStsOAuth2Strategy(config, parameters);
        return strategy;
    }

    public static String getTenantNameVariantUrlFromAuthorityWithoutPath(@NonNull String authorityNoPath) {
        if (authorityNoPath == null) {
            throw new NullPointerException("authorityNoPath is marked non-null but is null");
        }
        if (authorityNoPath.startsWith("https://")) {
            authorityNoPath = authorityNoPath.substring(8);
        }
        if (authorityNoPath.endsWith("/")) {
            authorityNoPath = authorityNoPath.substring(0, authorityNoPath.length() - 1);
        }
        String tenant = authorityNoPath.split("\\.")[0];
        return "https://" + authorityNoPath + "/" + tenant + ".onmicrosoft.com";
    }

    public static String getTenantIdVariantUrlFromAuthorityWithoutPath(@NonNull String authorityNoPath, @NonNull String tenantId) {
        if (authorityNoPath == null) {
            throw new NullPointerException("authorityNoPath is marked non-null but is null");
        }
        if (tenantId == null) {
            throw new NullPointerException("tenantId is marked non-null but is null");
        }
        if (authorityNoPath.startsWith("https://")) {
            authorityNoPath = authorityNoPath.substring(8);
        }
        if (authorityNoPath.endsWith("/")) {
            authorityNoPath = authorityNoPath.substring(0, authorityNoPath.length() - 1);
        }
        return "https://" + authorityNoPath + "/" + tenantId;
    }
}

