/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.broker.ipc;

import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.broker.ipc.BrokerOperationBundle;
import com.microsoft.identity.common.internal.broker.ipc.IIpcStrategy;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import com.microsoft.identity.common.internal.util.ProcessUtil;
import com.microsoft.identity.common.logging.Logger;
import java.io.IOException;
import java.util.HashSet;

@SuppressLint(value={"MissingPermission"})
public class AccountManagerAddAccountStrategy
implements IIpcStrategy {
    private static final String TAG = AccountManagerAddAccountStrategy.class.getSimpleName();
    private final Context mContext;

    public AccountManagerAddAccountStrategy(Context context) {
        this.mContext = context;
    }

    @Override
    @Nullable
    public Bundle communicateToBroker(@NonNull BrokerOperationBundle brokerOperationBundle) throws BrokerCommunicationException {
        String methodTag = TAG + ":communicateToBroker";
        String operationName = brokerOperationBundle.getOperation().name();
        Logger.info(methodTag, "Broker operation: " + operationName + " brokerPackage: " + brokerOperationBundle.getTargetBrokerAppPackageName());
        try {
            AccountManagerFuture resultBundle = AccountManager.get((Context)this.mContext).addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, brokerOperationBundle.getAccountManagerBundle(), null, null, ProcessUtil.getPreferredHandler());
            Logger.verbose(methodTag, "Received result from broker");
            return (Bundle)resultBundle.getResult();
        }
        catch (AuthenticatorException | OperationCanceledException | IOException e) {
            Logger.error(methodTag, e.getMessage(), e);
            throw new BrokerCommunicationException(BrokerCommunicationException.Category.CONNECTION_ERROR, this.getType(), "Failed to connect to AccountManager", e);
        }
    }

    @Override
    @NonNull
    public IIpcStrategy.Type getType() {
        return IIpcStrategy.Type.ACCOUNT_MANAGER_ADD_ACCOUNT;
    }

    @Override
    public boolean isSupportedByTargetedBroker(@NonNull String targetedBrokerPackageName) {
        HashSet<String> brokerList = new HashSet<String>();
        brokerList.add("broker.package.name");
        return AccountManagerUtil.canUseAccountManagerOperation(this.mContext, brokerList);
    }
}

