/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.annotation.TargetApi;
import android.content.Context;
import android.security.KeyPairGeneratorSpec;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.util.AndroidKeyStoreUtil;
import com.microsoft.identity.common.java.crypto.key.AES256KeyLoader;
import com.microsoft.identity.common.java.crypto.key.KeyUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.util.CachedData;
import com.microsoft.identity.common.java.util.FileUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import lombok.NonNull;

@TargetApi(value=18)
public class AndroidWrappedKeyLoader
extends AES256KeyLoader {
    private static final String TAG = AndroidWrappedKeyLoader.class.getSimpleName() + "#";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean sSkipKeyInvalidationCheck = false;
    private static final String WRAP_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String WRAP_KEY_ALGORITHM = "RSA";
    public static final String WRAPPED_KEY_KEY_IDENTIFIER = "A001";
    static final int KEY_FILE_SIZE = 1024;
    private final Context mContext;
    private final String mAlias;
    private final String mFilePath;
    private final CachedData<SecretKey> mKeyCache = new CachedData<SecretKey>(){

        public SecretKey getData() {
            if (!(sSkipKeyInvalidationCheck || AndroidKeyStoreUtil.canLoadKey(AndroidWrappedKeyLoader.this.mAlias) && AndroidWrappedKeyLoader.this.getKeyFile().exists())) {
                this.clear();
            }
            return (SecretKey)super.getData();
        }
    };

    @NonNull
    CachedData<SecretKey> getKeyCache() {
        return this.mKeyCache;
    }

    public AndroidWrappedKeyLoader(@NonNull String alias, @NonNull String filePath, @NonNull Context context) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mAlias = alias;
        this.mFilePath = filePath;
        this.mContext = context;
    }

    @NonNull
    public String getAlias() {
        return this.mAlias;
    }

    @NonNull
    public String getKeyTypeIdentifier() {
        return WRAPPED_KEY_KEY_IDENTIFIER;
    }

    @NonNull
    public synchronized SecretKey getKey() throws ClientException {
        SecretKey key = (SecretKey)this.mKeyCache.getData();
        if (key == null) {
            key = this.readSecretKeyFromStorage();
        }
        if (key == null) {
            key = this.generateRandomKey();
        }
        this.mKeyCache.setData((Object)key);
        return key;
    }

    @NonNull
    protected SecretKey generateRandomKey() throws ClientException {
        String methodTag = TAG + ":generateRandomKey";
        SecretKey key = super.generateRandomKey();
        this.saveSecretKeyToStorage(key);
        Logger.info(methodTag, "New key is generated with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
        return key;
    }

    @Nullable
    SecretKey readSecretKeyFromStorage() throws ClientException {
        String methodTag = TAG + ":readSecretKeyFromStorage";
        try {
            KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.mAlias);
            if (keyPair == null) {
                Logger.info(methodTag, "key does not exist in keystore");
                this.deleteSecretKeyFromStorage();
                return null;
            }
            byte[] wrappedSecretKey = FileUtil.readFromFile((File)this.getKeyFile(), (int)1024);
            if (wrappedSecretKey == null) {
                Logger.warn(methodTag, "Key file is empty");
                FileUtil.deleteFile((File)this.getKeyFile());
                this.mKeyCache.clear();
                return null;
            }
            SecretKey key = AndroidKeyStoreUtil.unwrap(wrappedSecretKey, this.getKeySpecAlgorithm(), keyPair, WRAP_ALGORITHM);
            Logger.info(methodTag, "Key is loaded with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
            return key;
        }
        catch (ClientException e) {
            Logger.warn(methodTag, "Error when loading key from Storage, wipe all existing key data ");
            this.deleteSecretKeyFromStorage();
            throw e;
        }
    }

    private void saveSecretKeyToStorage(@NonNull SecretKey unencryptedKey) throws ClientException {
        if (unencryptedKey == null) {
            throw new NullPointerException("unencryptedKey is marked non-null but is null");
        }
        String methodTag = TAG + ":saveSecretKeyToStorage";
        KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.mAlias);
        if (keyPair == null) {
            Logger.info(methodTag, "No existing keypair. Generating a new one.");
            keyPair = AndroidKeyStoreUtil.generateKeyPair(WRAP_KEY_ALGORITHM, AndroidWrappedKeyLoader.getSpecForKeyStoreKey(this.mContext, this.mAlias));
        }
        byte[] keyWrapped = AndroidKeyStoreUtil.wrap(unencryptedKey, keyPair, WRAP_ALGORITHM);
        FileUtil.writeDataToFile((byte[])keyWrapped, (File)this.getKeyFile());
    }

    public void deleteSecretKeyFromStorage() throws ClientException {
        AndroidKeyStoreUtil.deleteKey(this.mAlias);
        FileUtil.deleteFile((File)this.getKeyFile());
        this.mKeyCache.clear();
    }

    @RequiresApi(api=18)
    private static AlgorithmParameterSpec getSpecForKeyStoreKey(@NonNull Context context, @NonNull String alias) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        String certInfo = String.format(Locale.ROOT, "CN=%s, OU=%s", alias, context.getPackageName());
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int certValidYears = 100;
        end.add(1, 100);
        return new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal(certInfo)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
    }

    private File getKeyFile() {
        return new File(this.mContext.getDir(this.mContext.getPackageName(), 0), this.mFilePath);
    }
}

