/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.exception;

import androidx.annotation.NonNull;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.exception.MsalException;
import java.util.List;

public class MsalDeclinedScopeException
extends MsalException {
    private List<String> mGrantedScopes;
    private List<String> mDeclinedScopes;
    private AcquireTokenSilentParameters mSilentParametersForGrantedScopes;

    public MsalDeclinedScopeException(@NonNull List<String> grantedScopes, @NonNull List<String> declinedScopes, @NonNull AcquireTokenSilentParameters silentParametersForGrantedScopes) {
        super("declined_scope_error", "Some or all requested scopes have been declined by the Server");
        this.mGrantedScopes = grantedScopes;
        this.mDeclinedScopes = declinedScopes;
        this.mSilentParametersForGrantedScopes = silentParametersForGrantedScopes;
    }

    public List<String> getGrantedScopes() {
        return this.mGrantedScopes;
    }

    public List<String> getDeclinedScopes() {
        return this.mDeclinedScopes;
    }

    public AcquireTokenSilentParameters getSilentParametersForGrantedScopes() {
        return this.mSilentParametersForGrantedScopes;
    }
}

